/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.modifiers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.command.io.CommandInfo;
import net.mt1006.mocap.command.io.CommandOutput;
import net.mt1006.mocap.mocap.files.SceneFiles;
import net.mt1006.mocap.mocap.playing.modifiers.Mirror;
import net.mt1006.mocap.mocap.playing.modifiers.Offset;
import net.mt1006.mocap.mocap.playing.modifiers.Rotation;
import net.mt1006.mocap.mocap.playing.modifiers.Scale;
import net.mt1006.mocap.mocap.playing.modifiers.TransformationsConfig;
import org.jetbrains.annotations.Nullable;

public class Transformations {
    @Nullable
    public Transformations parent;
    public Rotation rotation;
    public Mirror mirror;
    public Scale scale;
    public Offset offset;
    public TransformationsConfig config;
    private boolean ignorable;

    private Transformations(@Nullable Transformations parent, Rotation rotation, Mirror mirror, Scale scale, Offset offset, TransformationsConfig config) {
        this.parent = parent != null && !parent.areDefault() ? parent : null;
        this.rotation = rotation;
        this.mirror = mirror;
        this.scale = scale;
        this.offset = offset;
        this.config = config;
        this.refreshIgnorable();
    }

    private Transformations(SceneFiles.Reader reader) {
        this.parent = null;
        this.rotation = Rotation.fromDouble(reader.readDouble("rotation", 0.0));
        this.mirror = Mirror.fromString(reader.readString("mirror"));
        this.scale = Scale.fromObject(reader.readObject("scale"));
        this.offset = Offset.fromVec3(reader.readVec3("offset"));
        this.config = TransformationsConfig.fromObject(reader.readObject("config"));
        this.refreshIgnorable();
    }

    public static Transformations fromObject(@Nullable SceneFiles.Reader reader) {
        return reader != null ? new Transformations(reader) : Transformations.empty();
    }

    public static Transformations fromLegacyScene(double x, double y, double z) {
        return new Transformations(null, Rotation.ZERO, Mirror.NONE, Scale.NORMAL, new Offset(x, y, z), TransformationsConfig.LEGACY);
    }

    public static Transformations empty() {
        return new Transformations(null, Rotation.ZERO, Mirror.NONE, Scale.NORMAL, Offset.ZERO, TransformationsConfig.DEFAULT);
    }

    public Vec3 calculateCenter(Vec3 startPos) {
        Vec3 center = this.calculateCenterWithoutOffset(startPos);
        return this.config.centerOffset.isZero ? center : center.add((Vec3)this.config.centerOffset);
    }

    private Vec3 calculateCenterWithoutOffset(Vec3 startPos) {
        if (this.config.recordingCenter != TransformationsConfig.RecordingCenter.AUTO) {
            return switch (this.config.recordingCenter) {
                case TransformationsConfig.RecordingCenter.BLOCK_CENTER -> Transformations.getBlockCenter(startPos);
                case TransformationsConfig.RecordingCenter.BLOCK_CORNER -> Transformations.getBlockCorner(startPos);
                case TransformationsConfig.RecordingCenter.ACTUAL -> startPos;
                default -> throw new IllegalStateException("Unexpected config.centerPoint value");
            };
        }
        double sceneScale = this.scale.sceneScale;
        if (sceneScale == 1.0 || sceneScale != (double)((int)sceneScale)) {
            Vec3 blockCenter = Transformations.getBlockCenter(startPos);
            Vec3 blockCorner = Transformations.getBlockCorner(startPos);
            return startPos.distanceToSqr(blockCenter) > startPos.distanceToSqr(blockCorner) ? blockCorner : blockCenter;
        }
        return (int)sceneScale % 2 == 1 ? Transformations.getBlockCenter(startPos) : Transformations.getBlockCorner(startPos);
    }

    private static Vec3 getBlockCenter(Vec3 vec) {
        return new Vec3((double)Math.round(vec.x - 0.5) + 0.5, Math.floor(vec.y), (double)Math.round(vec.z - 0.5) + 0.5);
    }

    private static Vec3 getBlockCorner(Vec3 vec) {
        return new Vec3((double)Math.round(vec.x), Math.floor(vec.y), (double)Math.round(vec.z));
    }

    public Transformations mergeWithParent(Transformations parent) {
        Transformations copy = this.copy();
        if (copy.parent != null) {
            MocapMod.LOGGER.warn("copy.parent != null");
        }
        copy.parent = parent.areDefault() ? null : parent;
        copy.scale = copy.scale.mergeWithParent(parent.scale);
        return copy;
    }

    public Transformations copy() {
        return new Transformations(this.parent, this.rotation, this.mirror, this.scale, this.offset, this.config);
    }

    public boolean areDefault() {
        return this.parent == null && this.rotation.deg == 0.0 && this.mirror == Mirror.NONE && this.scale.isNormal() && this.offset.isZero && this.config.isDefault();
    }

    public void refreshIgnorable() {
        this.ignorable = this.rotation.deg == 0.0 && this.mirror == Mirror.NONE && this.scale.sceneScale == 1.0 && this.offset.isZero && this.config.isDefault();
    }

    @Nullable
    public SceneFiles.Writer save() {
        if (this.areDefault()) {
            return null;
        }
        SceneFiles.Writer writer = new SceneFiles.Writer();
        writer.addDouble("rotation", this.rotation.deg, 0.0);
        writer.addString("mirror", this.mirror.save());
        writer.addVec3("offset", this.offset.save());
        writer.addObject("scale", this.scale.save());
        writer.addObject("config", this.config.save());
        return writer;
    }

    public void list(CommandOutput commandOutput) {
        commandOutput.sendSuccess("scenes.element_info.transformations.rotation", this.rotation.deg);
        commandOutput.sendSuccess("scenes.element_info.transformations.mirror." + this.mirror.name().toLowerCase(), new Object[0]);
        if (this.scale.playerScale == 1.0) {
            commandOutput.sendSuccess("scenes.element_info.transformations.player_scale.normal", new Object[0]);
        } else {
            commandOutput.sendSuccess("scenes.element_info.transformations.player_scale.custom", this.scale.playerScale);
        }
        if (this.scale.sceneScale == 1.0) {
            commandOutput.sendSuccess("scenes.element_info.transformations.scene_scale.normal", new Object[0]);
        } else {
            commandOutput.sendSuccess("scenes.element_info.transformations.scene_scale.custom", this.scale.sceneScale);
        }
        commandOutput.sendSuccess("scenes.element_info.transformations.offset", this.offset.x, this.offset.y, this.offset.z);
        this.config.list(commandOutput);
    }

    public boolean modify(CommandInfo commandInfo, String propertyName, int propertyNodePosition) {
        switch (propertyName) {
            case "rotation": {
                this.rotation = new Rotation(commandInfo.getDouble("deg"));
                break;
            }
            case "mirror": {
                Mirror newMirror = Mirror.fromStringOrNull(commandInfo.getNode(propertyNodePosition + 1));
                if (newMirror == null) {
                    return false;
                }
                this.mirror = newMirror;
                break;
            }
            case "scale": {
                String scaleType = commandInfo.getNode(propertyNodePosition + 1);
                if (scaleType == null) {
                    return false;
                }
                double scaleVal = commandInfo.getDouble("scale");
                if (scaleType.equals("of_player")) {
                    this.scale = this.scale.ofPlayer(scaleVal);
                    break;
                }
                if (scaleType.equals("of_scene")) {
                    this.scale = this.scale.ofScene(scaleVal);
                    break;
                }
                return false;
            }
            case "offset": {
                this.offset = new Offset(commandInfo.getDouble("offset_x"), commandInfo.getDouble("offset_y"), commandInfo.getDouble("offset_z"));
                break;
            }
            case "config": {
                String transformationType = commandInfo.getNode(propertyNodePosition + 1);
                if (transformationType == null) {
                    return false;
                }
                TransformationsConfig newConfig = this.config.modify(commandInfo, transformationType, propertyNodePosition + 1);
                if (newConfig != null) {
                    this.config = newConfig;
                    break;
                }
                return false;
            }
            default: {
                return false;
            }
        }
        this.refreshIgnorable();
        return true;
    }

    public Vec3 apply(Vec3 point, Vec3 center) {
        if (this.ignorable) {
            return point;
        }
        point = this.rotation.apply(point, center);
        point = this.mirror.apply(point, center);
        point = this.scale.applyToPoint(point, center);
        point = this.offset.apply(point);
        return point;
    }

    public List<BlockPos> applyToBlockPos(List<BlockPos> inputList, Vec3 center) {
        if (this.ignorable) {
            return inputList;
        }
        if (inputList.size() == 1) {
            return this.applyToBlockPos(inputList.get(0), center);
        }
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(inputList.size());
        inputList.forEach(b -> list.addAll(this.applyToBlockPos((BlockPos)b, center)));
        return list;
    }

    private List<BlockPos> applyToBlockPos(BlockPos blockPos, Vec3 center) {
        if (!(this.config.roundBlockPos || Transformations.isIntVec(center.multiply(2.0, 2.0, 2.0)) && this.rotation.canRotateInt && this.scale.canScaleInt(center) && this.offset.isInt)) {
            return List.of();
        }
        Vec3 point1 = Vec3.atLowerCornerOf((Vec3i)blockPos);
        Vec3 point2 = point1.add(1.0, 1.0, 1.0);
        point1 = this.apply(point1, center);
        point2 = this.apply(point2, center);
        return this.voxelizeCube(point1, point2);
    }

    private List<BlockPos> voxelizeCube(Vec3 pos1, Vec3 pos2) {
        if (Transformations.isIntVec(pos1) && pos1.x + 1.0 == pos2.x && pos1.y + 1.0 == pos2.y && pos1.z + 1.0 == pos2.z) {
            return List.of(new BlockPos((int)pos1.x, (int)pos1.y, (int)pos1.z));
        }
        int startY = (int)Math.round(pos1.y);
        int stopY = (int)Math.round(pos2.y);
        if (Math.abs(pos1.x - pos2.x) == Math.abs(pos1.z - pos2.z)) {
            int startX = (int)Math.round(Math.min(pos1.x, pos2.x));
            int stopX = (int)Math.round(Math.max(pos1.x, pos2.x));
            int startZ = (int)Math.round(Math.min(pos1.z, pos2.z));
            int stopZ = (int)Math.round(Math.max(pos1.z, pos2.z));
            ArrayList<BlockPos> list = new ArrayList<BlockPos>((stopX - startX) * (stopZ - startZ) * (stopY - startY));
            for (int y = startY; y < stopY; ++y) {
                for (int z = startZ; z < stopZ; ++z) {
                    for (int x = startX; x < stopX; ++x) {
                        list.add(new BlockPos(x, y, z));
                    }
                }
            }
            return list;
        }
        double bottomY = pos1.y;
        double sqCenterX = (pos1.x + pos2.x) / 2.0;
        double sqCenterZ = (pos1.z + pos2.z) / 2.0;
        Vec3 pos3 = new Vec3(sqCenterX + (pos1.z - sqCenterZ), bottomY, sqCenterZ - (pos1.x - sqCenterX));
        Vec3 pos4 = new Vec3(sqCenterX + (pos2.z - sqCenterZ), bottomY, sqCenterZ - (pos2.x - sqCenterX));
        int minZ = (int)Math.round(Math.min(Math.min(pos1.z, pos2.z), Math.min(pos3.z, pos4.z)));
        int maxZ = (int)Math.round(Math.max(Math.max(pos1.z, pos2.z), Math.max(pos3.z, pos4.z)));
        Vec3[] vertices = new Vec3[]{pos1, pos3, pos2, pos4};
        ArrayList<Integer> nodesX = new ArrayList<Integer>(4);
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int z = minZ; z <= maxZ; ++z) {
            nodesX.clear();
            int j = vertices.length - 1;
            int i = 0;
            while (i < vertices.length) {
                Vec3 v1 = vertices[i];
                Vec3 v2 = vertices[j];
                if ((double)z > v1.z && (double)z < v2.z || (double)z > v2.z && (double)z < v1.z) {
                    double x = v1.x + (v2.x - v1.x) * (((double)z - v1.z) / (v2.z - v1.z));
                    nodesX.add((int)Math.round(x));
                }
                j = i++;
            }
            if (nodesX.isEmpty()) continue;
            int startX = (Integer)Collections.min(nodesX);
            int stopX = (Integer)Collections.max(nodesX);
            for (int x = startX; x < stopX; ++x) {
                for (int y = startY; y < stopY; ++y) {
                    list.add(new BlockPos(x, y, z));
                }
            }
        }
        return list;
    }

    private static boolean isIntVec(Vec3 vec) {
        return vec.x == (double)((int)vec.x) && vec.y == (double)((int)vec.y) && vec.z == (double)((int)vec.z);
    }

    public BlockState applyToBlockState(BlockState blockState) {
        if (this.ignorable) {
            return blockState;
        }
        if (this.rotation.deg != 0.0) {
            blockState = blockState.rotate(this.rotation.blockRotation);
        }
        if (this.mirror.mirrorX) {
            blockState = blockState.mirror(net.minecraft.world.level.block.Mirror.FRONT_BACK);
        }
        if (this.mirror.mirrorZ) {
            blockState = blockState.mirror(net.minecraft.world.level.block.Mirror.LEFT_RIGHT);
        }
        return blockState;
    }

    public double applyToRotation(double rot) {
        if (this.ignorable) {
            return rot;
        }
        rot += this.rotation.deg;
        if (this.mirror.mirrorX) {
            rot = -rot;
        }
        if (this.mirror.mirrorZ) {
            rot = -(rot + 90.0) - 90.0;
        }
        return Rotation.clampRot(rot);
    }
}

