/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.modifiers;

import net.mt1006.mocap.command.io.CommandInfo;
import net.mt1006.mocap.command.io.CommandOutput;
import net.mt1006.mocap.mocap.files.SceneFiles;
import net.mt1006.mocap.mocap.playing.modifiers.Offset;
import org.jetbrains.annotations.Nullable;

public class TransformationsConfig {
    public static final TransformationsConfig DEFAULT = new TransformationsConfig(false, RecordingCenter.AUTO, SceneCenter.DEFAULT, Offset.ZERO);
    public static final TransformationsConfig LEGACY = new TransformationsConfig(true, RecordingCenter.AUTO, SceneCenter.DEFAULT, Offset.ZERO);
    public final boolean roundBlockPos;
    public final RecordingCenter recordingCenter;
    public final SceneCenter sceneCenter;
    public final Offset centerOffset;

    public TransformationsConfig(boolean roundBlockPos, RecordingCenter recordingCenter, SceneCenter sceneCenter, Offset centerOffset) {
        this.roundBlockPos = roundBlockPos;
        this.recordingCenter = recordingCenter;
        this.sceneCenter = sceneCenter;
        this.centerOffset = centerOffset;
    }

    public TransformationsConfig(SceneFiles.Reader reader) {
        this.roundBlockPos = reader.readBoolean("round_block_pos", false);
        this.recordingCenter = reader.readEnum("recording_center", RecordingCenter.AUTO);
        this.sceneCenter = SceneCenter.fromObject(reader.readObject("scene_center"));
        this.centerOffset = Offset.fromVec3(reader.readVec3("center_offset"));
    }

    public static TransformationsConfig fromObject(@Nullable SceneFiles.Reader reader) {
        return reader != null ? new TransformationsConfig(reader) : DEFAULT;
    }

    public boolean isDefault() {
        return !this.roundBlockPos && this.recordingCenter == RecordingCenter.AUTO && this.centerOffset.isZero && this.sceneCenter.type == SceneCenterType.COMMON_FIRST;
    }

    @Nullable
    public SceneFiles.Writer save() {
        if (this.isDefault()) {
            return null;
        }
        SceneFiles.Writer writer = new SceneFiles.Writer();
        writer.addBoolean("round_block_pos", this.roundBlockPos, false);
        writer.addEnum("recording_center", this.recordingCenter, RecordingCenter.AUTO);
        writer.addObject("scene_center", this.sceneCenter.save());
        writer.addVec3("center_offset", this.centerOffset.save());
        return writer;
    }

    public void list(CommandOutput commandOutput) {
        if (this.isDefault()) {
            commandOutput.sendSuccess("scenes.element_info.transformations.default_config", new Object[0]);
            return;
        }
        commandOutput.sendSuccess("scenes.element_info.transformations.round_block_pos." + this.roundBlockPos, new Object[0]);
        commandOutput.sendSuccess("scenes.element_info.transformations.recording_center", this.recordingCenter.name());
        commandOutput.sendSuccess("scenes.element_info.transformations.scene_center", this.sceneCenter.toString());
        commandOutput.sendSuccess("scenes.element_info.transformations.center_offset", this.centerOffset.x, this.centerOffset.y, this.centerOffset.z);
    }

    @Nullable
    public TransformationsConfig modify(CommandInfo commandInfo, String propertyName, int propertyNodePosition) {
        switch (propertyName) {
            case "round_block_pos": {
                return new TransformationsConfig(commandInfo.getBool("round"), this.recordingCenter, this.sceneCenter, this.centerOffset);
            }
            case "recording_center": {
                String centerPointStr = commandInfo.getNode(propertyNodePosition + 1);
                if (centerPointStr == null) break;
                return new TransformationsConfig(this.roundBlockPos, RecordingCenter.valueOf(centerPointStr.toUpperCase()), this.sceneCenter, this.centerOffset);
            }
            case "scene_center": {
                String sceneCenterStr = commandInfo.getNode(propertyNodePosition + 1);
                if (sceneCenterStr == null) break;
                SceneCenterType centerType = SceneCenterType.valueOf(sceneCenterStr.toUpperCase());
                SceneCenter center = centerType == SceneCenterType.COMMON_SPECIFIC ? new SceneCenter(centerType, commandInfo.getString("specific_scene_element")) : new SceneCenter(centerType, null);
                return new TransformationsConfig(this.roundBlockPos, this.recordingCenter, center, this.centerOffset);
            }
            case "center_offset": {
                return new TransformationsConfig(this.roundBlockPos, this.recordingCenter, this.sceneCenter, new Offset(commandInfo.getDouble("offset_x"), commandInfo.getDouble("offset_y"), commandInfo.getDouble("offset_z")));
            }
        }
        return null;
    }

    public static enum RecordingCenter {
        AUTO,
        BLOCK_CENTER,
        BLOCK_CORNER,
        ACTUAL;

    }

    public static class SceneCenter {
        public static final SceneCenter DEFAULT = new SceneCenter(SceneCenterType.COMMON_FIRST, null);
        public final SceneCenterType type;
        @Nullable
        public final String specificStr;

        public SceneCenter(SceneCenterType type, @Nullable String specificStr) {
            this.type = type;
            this.specificStr = specificStr;
        }

        public SceneCenter(SceneFiles.Reader reader) {
            this.type = reader.readEnum("type", SceneCenterType.COMMON_FIRST);
            this.specificStr = this.type == SceneCenterType.COMMON_SPECIFIC ? reader.readString("specific_str") : null;
        }

        public static SceneCenter fromObject(@Nullable SceneFiles.Reader reader) {
            return reader != null ? new SceneCenter(reader) : DEFAULT;
        }

        @Nullable
        public SceneFiles.Writer save() {
            if (this.type == SceneCenterType.COMMON_FIRST) {
                return null;
            }
            SceneFiles.Writer writer = new SceneFiles.Writer();
            writer.addEnum("type", this.type, SceneCenterType.COMMON_FIRST);
            if (this.type == SceneCenterType.COMMON_SPECIFIC) {
                writer.addString("specific_str", this.specificStr);
            }
            return writer;
        }

        public String toString() {
            return this.type == SceneCenterType.COMMON_SPECIFIC ? String.format("%s [%s]", this.type.name(), this.specificStr) : this.type.name();
        }
    }

    public static enum SceneCenterType {
        COMMON_FIRST,
        COMMON_LAST,
        COMMON_SPECIFIC,
        INDIVIDUAL;

    }
}

