/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.playback;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.events.PlayerConnectionEvent;
import net.mt1006.mocap.mocap.playing.modifiers.PlaybackModifiers;
import net.mt1006.mocap.mocap.playing.playback.PositionTransformer;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.network.MocapPacketS2C;
import net.mt1006.mocap.utils.FakePlayer;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
public class ActionContext {
    private final ServerPlayer owner;
    private final PlayerList packetTargets;
    private final EntityData mainEntityData;
    public final Map<Integer, EntityData> entityDataMap = new HashMap<Integer, EntityData>();
    public final ServerLevel level;
    public final PlaybackModifiers modifiers;
    @Nullable
    public final FakePlayer ghostPlayer;
    public final PositionTransformer transformer;
    private boolean mainEntityRemoved = false;
    @Nullable
    private EntityData currentEntityData = null;
    public Entity entity;
    private Vec3 position;
    public int skippingTicks = 0;

    public ActionContext(ServerPlayer owner, PlayerList packetTargets, Entity entity, Vec3 startPos, PlaybackModifiers modifiers, @Nullable FakePlayer ghostPlayer, PositionTransformer transformer) {
        if (!(entity.level() instanceof ServerLevel)) {
            throw new RuntimeException("Failed to get ServerLevel for ActionContext!");
        }
        this.owner = owner;
        this.packetTargets = packetTargets;
        this.mainEntityData = new EntityData(entity, startPos);
        this.level = (ServerLevel)entity.level();
        this.modifiers = modifiers;
        this.ghostPlayer = ghostPlayer;
        this.transformer = transformer;
        this.setMainContextEntity();
    }

    public void setMainContextEntity() {
        this.setContextEntity(this.mainEntityData);
    }

    public boolean setContextEntity(int id) {
        EntityData data = this.entityDataMap.get(id);
        if (data == null) {
            return false;
        }
        this.setContextEntity(data);
        return true;
    }

    private void setContextEntity(EntityData data) {
        if (this.currentEntityData != null) {
            this.currentEntityData.lastPosition = this.position;
        }
        this.currentEntityData = data;
        this.entity = data.entity;
        this.position = data.lastPosition;
    }

    public void broadcast(Packet<?> packet) {
        this.packetTargets.broadcastAll(packet);
    }

    public void fluentMovement(Supplier<Packet<?>> packetSupplier) {
        double fluentMovements = (Double)Settings.FLUENT_MOVEMENTS.val;
        if (fluentMovements == 0.0) {
            return;
        }
        Packet<?> packet = packetSupplier.get();
        if (fluentMovements > 0.0) {
            Vec3 pos = this.entity.position();
            double maxDistSqr = fluentMovements * fluentMovements;
            for (ServerPlayer player : this.packetTargets.getPlayers()) {
                if (player.distanceToSqr(pos) > maxDistSqr) continue;
                player.connection.send(packet);
            }
        } else {
            this.packetTargets.broadcastAll(packet);
        }
    }

    public void removeEntities() {
        this.removeMainEntity();
        this.entityDataMap.values().forEach(data -> ActionContext.removeEntity(data.entity));
        this.entityDataMap.clear();
    }

    public void removeMainEntity() {
        FakePlayer playerToRemove;
        if (this.mainEntityRemoved) {
            return;
        }
        this.mainEntityRemoved = true;
        if (this.entity instanceof Player) {
            if (!(this.entity instanceof FakePlayer)) {
                Utils.sendMessage((Player)this.owner, "error.failed_to_remove_fake_player", new Object[0]);
                MocapMod.LOGGER.error("Failed to remove fake player!");
                return;
            }
            playerToRemove = (FakePlayer)this.entity;
        } else {
            ActionContext.removeEntity(this.entity);
            if (this.ghostPlayer == null) {
                return;
            }
            playerToRemove = this.ghostPlayer;
        }
        UUID uuid = playerToRemove.getUUID();
        if (PlayerConnectionEvent.nocolPlayers.contains(uuid)) {
            for (ServerPlayer player : PlayerConnectionEvent.players) {
                MocapPacketS2C.sendNocolPlayerRemove(player, uuid);
                PlayerConnectionEvent.removeNocolPlayer(uuid);
            }
        }
        if (playerToRemove != this.ghostPlayer) {
            this.broadcast((Packet<?>)new ClientboundPlayerInfoRemovePacket(List.of(uuid)));
        }
        playerToRemove.remove(Entity.RemovalReason.KILLED);
        playerToRemove.getAdvancements().stopListening();
    }

    public void changePosition(Vec3 newPos, float rotY, float rotX, boolean shiftXZ, boolean shiftY, boolean transformRot) {
        double x = shiftXZ ? this.position.x + newPos.x : newPos.x;
        double y = shiftY ? this.position.y + newPos.y : newPos.y;
        double z = shiftXZ ? this.position.z + newPos.z : newPos.z;
        this.position = new Vec3(x, y, z);
        Vec3 finPos = this.transformer.transformPos(this.position);
        float finRotY = transformRot ? this.transformer.transformRotation(rotY) : rotY;
        this.entity.moveTo(finPos, finRotY, rotX);
        if (this.ghostPlayer != null && this.entity == this.mainEntityData.entity) {
            this.ghostPlayer.moveTo(finPos, finRotY, rotX);
        }
    }

    /*
     * Exception decompiling
     */
    private static void removeEntity(Entity entity) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't turn ConstantPoolEntry into Literal - got DynamicInfo value=3,436
         *     at org.benf.cfr.reader.bytecode.analysis.parse.literal.TypedLiteral.getConstantPoolEntry(TypedLiteral.java:340)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getBootstrapArg(Op02WithProcessedDataAndRefs.java:538)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.getVarArgs(Op02WithProcessedDataAndRefs.java:671)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeBootstrapArgs(Op02WithProcessedDataAndRefs.java:630)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:411)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvokeDynamic(Op02WithProcessedDataAndRefs.java:392)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1215)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
         *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class EntityData {
        public final Entity entity;
        public Vec3 lastPosition;

        public EntityData(Entity entity, Vec3 startPos) {
            this.entity = entity;
            this.lastPosition = startPos;
        }
    }
}

