/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.playback;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.mt1006.mocap.command.CommandsContext;
import net.mt1006.mocap.command.io.CommandInfo;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.files.SceneData;
import net.mt1006.mocap.mocap.playing.DataManager;
import net.mt1006.mocap.mocap.playing.modifiers.PlaybackModifiers;
import net.mt1006.mocap.mocap.playing.playback.PositionTransformer;
import net.mt1006.mocap.mocap.playing.playback.RecordingPlayback;
import net.mt1006.mocap.mocap.playing.playback.ScenePlayback;
import net.mt1006.mocap.mocap.recording.Recording;
import net.mt1006.mocap.mocap.recording.RecordingContext;
import org.jetbrains.annotations.Nullable;

public abstract class Playback {
    protected final boolean root;
    protected final ServerLevel level;
    @Nullable
    public final ServerPlayer owner;
    protected boolean finished = false;
    protected final PlaybackModifiers modifiers;
    protected int tickCounter = 0;

    @Nullable
    public static Root start(CommandInfo commandInfo, String name, PlaybackModifiers modifiers, int id) {
        DataManager dataManager = new DataManager();
        if (!dataManager.load(commandInfo, name)) {
            if (!dataManager.knownError) {
                commandInfo.sendFailure("playback.start.error.load", new Object[0]);
            }
            commandInfo.sendFailure("playback.start.error.load.path", dataManager.getResourcePath());
            return null;
        }
        Playback playback = switch (SceneType.fromName(name).ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> RecordingPlayback.startRoot(commandInfo, dataManager.getRecording(name), modifiers);
            case 0 -> ScenePlayback.startRoot(commandInfo, dataManager, name, modifiers);
        };
        return playback != null ? new Root(playback, id, name) : null;
    }

    @Nullable
    public static Root start(CommandInfo commandInfo, RecordingData recordingData, String name, PlaybackModifiers modifiers, int id) {
        RecordingPlayback playback = RecordingPlayback.startRoot(commandInfo, recordingData, modifiers);
        return playback != null ? new Root(playback, id, name) : null;
    }

    @Nullable
    protected static Playback start(CommandInfo commandInfo, DataManager dataManager, Playback parent, SceneData.Subscene info) {
        String name = info.name;
        return switch (SceneType.fromName(name).ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> RecordingPlayback.startSubscene(commandInfo, dataManager, parent, info);
            case 0 -> ScenePlayback.startSubscene(commandInfo, dataManager, parent, info);
        };
    }

    protected Playback(boolean root, ServerLevel level, @Nullable ServerPlayer owner, PlaybackModifiers parentModifiers, @Nullable SceneData.Subscene subscene) {
        this.root = root;
        this.level = level;
        this.owner = owner;
        if (root) {
            if (subscene != null) {
                throw new RuntimeException();
            }
            this.modifiers = parentModifiers;
        } else {
            if (subscene == null) {
                throw new RuntimeException();
            }
            this.modifiers = subscene.modifiers.mergeWithParent(parentModifiers);
        }
    }

    public abstract boolean tick();

    public abstract void stop();

    public abstract boolean isFinished();

    protected abstract PositionTransformer getPosTransformer();

    protected boolean shouldExecuteTick() {
        if (this.tickCounter == 0) {
            return true;
        }
        if (this.modifiers.startDelay.ticks <= this.tickCounter) {
            if (CommandsContext.haveSyncEnabled == 0 || this.owner == null) {
                return true;
            }
            CommandsContext commandsContext = CommandsContext.get(this.owner);
            if (!commandsContext.getSync()) {
                return true;
            }
            for (RecordingContext ctx : Recording.bySourcePlayer(this.owner)) {
                if (ctx.state != RecordingContext.State.RECORDING) continue;
                return true;
            }
        }
        return false;
    }

    private static enum SceneType {
        SCENE,
        RECORDING;


        public static SceneType fromName(String name) {
            return name.charAt(0) == '.' ? SCENE : RECORDING;
        }
    }

    public static class Root {
        public final Playback instance;
        public final int id;
        public final String name;
        public final String suggestionStr;

        public Root(Playback instance, int id, String name) {
            this.instance = instance;
            this.id = id;
            this.name = name;
            this.suggestionStr = String.format("%03d-%s", id, name);
        }
    }

    public static class StartException
    extends Exception {
    }
}

