/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.playback;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.mocap.playing.modifiers.Transformations;
import net.mt1006.mocap.mocap.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class PositionTransformer {
    private final Transformations transformations;
    @Nullable
    private final PositionTransformer parent;
    @Nullable
    private final Vec3 center;

    public PositionTransformer(Transformations transformations, @Nullable PositionTransformer parent, @Nullable Vec3 center) {
        this.parent = PositionTransformer.getProperParent(parent, transformations);
        this.transformations = transformations;
        this.center = center;
    }

    @Nullable
    private static PositionTransformer getProperParent(@Nullable PositionTransformer parent, Transformations transformations) {
        if (parent != null && transformations.parent != parent.transformations) {
            throw new RuntimeException();
        }
        return parent == null && transformations.parent != null ? new PositionTransformer(transformations.parent, null, null) : parent;
    }

    public Vec3 transformPos(Vec3 point) {
        return this.transformPos(point, null);
    }

    private Vec3 transformPos(Vec3 point, @Nullable Vec3 childCenter) {
        if (childCenter == null && this.center == null) {
            throw new RuntimeException("Both childCenter and center are null!");
        }
        Vec3 centerToUse = this.center != null ? this.center : childCenter;
        point = this.transformations.apply(point, centerToUse);
        return this.parent != null ? this.parent.transformPos(point, centerToUse) : point;
    }

    public List<BlockPos> transformBlockPos(BlockPos blockPos) {
        return this.transformBlockPos(List.of(blockPos), null);
    }

    public List<BlockPos> transformBlockPos(List<BlockPos> blockPos, @Nullable Vec3 childCenter) {
        if (childCenter == null && this.center == null) {
            throw new RuntimeException("Both childCenter and center are null!");
        }
        Vec3 centerToUse = this.center != null ? this.center : childCenter;
        List<BlockPos> list = this.transformations.applyToBlockPos(blockPos, centerToUse);
        if (list.size() > 1 && !((Boolean)Settings.BLOCK_ALLOW_SCALED.val).booleanValue()) {
            return List.of();
        }
        return this.parent != null ? this.parent.transformBlockPos(list, centerToUse) : list;
    }

    public BlockState transformBlockState(BlockState blockState) {
        blockState = this.transformations.applyToBlockState(blockState);
        return this.parent != null ? this.parent.transformBlockState(blockState) : blockState;
    }

    public float transformRotation(float rot) {
        rot = (float)this.transformations.applyToRotation(rot);
        return this.parent != null ? this.parent.transformRotation(rot) : rot;
    }
}

