/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.playback;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.command.io.CommandInfo;
import net.mt1006.mocap.events.PlayerConnectionEvent;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.files.SceneData;
import net.mt1006.mocap.mocap.playing.DataManager;
import net.mt1006.mocap.mocap.playing.modifiers.PlaybackModifiers;
import net.mt1006.mocap.mocap.playing.playback.ActionContext;
import net.mt1006.mocap.mocap.playing.playback.Playback;
import net.mt1006.mocap.mocap.playing.playback.PositionTransformer;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.network.MocapPacketS2C;
import net.mt1006.mocap.utils.EntityData;
import net.mt1006.mocap.utils.FakePlayer;
import net.mt1006.mocap.utils.Fields;
import net.mt1006.mocap.utils.ProfileUtils;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class RecordingPlayback
extends Playback {
    private final RecordingData recording;
    private final ActionContext ctx;
    private int pos = 0;
    private int dyingTicks = 0;

    private RecordingPlayback(CommandInfo commandInfo, @Nullable RecordingData recording, PlaybackModifiers parentModifiers, @Nullable SceneData.Subscene subscene, @Nullable PositionTransformer parentTransformer) throws Playback.StartException {
        super(subscene == null, commandInfo.level, commandInfo.sourcePlayer, parentModifiers, subscene);
        Object entity;
        if (recording == null) {
            throw new Playback.StartException();
        }
        this.recording = recording;
        GameProfile profile = this.getGameProfile(commandInfo);
        if (profile == null) {
            commandInfo.sendFailure("playback.start.error", new Object[0]);
            commandInfo.sendFailure("playback.start.error.profile", new Object[0]);
            throw new Playback.StartException();
        }
        GameProfile newProfile = new GameProfile(UUID.randomUUID(), profile.getName());
        try {
            PropertyMap oldPropertyMap = (PropertyMap)Fields.gameProfileProperties.get(profile);
            PropertyMap newPropertyMap = (PropertyMap)Fields.gameProfileProperties.get(newProfile);
            newPropertyMap.putAll((Multimap)oldPropertyMap);
            this.modifiers.playerSkin.addSkinToPropertyMap(commandInfo, newPropertyMap);
        }
        catch (Exception oldPropertyMap) {
            // empty catch block
        }
        PlayerList packetTargets = this.level.getServer().getPlayerList();
        FakePlayer ghost = null;
        Vec3 center = this.modifiers.transformations.calculateCenter(recording.startPos);
        PositionTransformer transformer = new PositionTransformer(this.modifiers.transformations, parentTransformer, center);
        if (!this.modifiers.playerAsEntity.isEnabled()) {
            FakePlayer fakePlayer = new FakePlayer(this.level, newProfile, this);
            entity = fakePlayer;
            EntityData.PLAYER_SKIN_PARTS.set((Entity)fakePlayer, (byte)127);
            fakePlayer.gameMode.changeGameModeForPlayer((Boolean)Settings.USE_CREATIVE_GAME_MODE.val != false ? GameType.CREATIVE : GameType.SURVIVAL);
            recording.initEntityPosition((Entity)fakePlayer, transformer);
            recording.preExecute((Entity)fakePlayer, transformer);
            this.modifiers.transformations.scale.applyToPlayer((Entity)fakePlayer);
            packetTargets.broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.Action.ADD_PLAYER, (ServerPlayer)fakePlayer));
            this.level.addNewPlayer((ServerPlayer)fakePlayer);
            if (!((Boolean)Settings.CAN_PUSH_ENTITIES.val).booleanValue()) {
                for (ServerPlayer player : PlayerConnectionEvent.players) {
                    MocapPacketS2C.sendNocolPlayerAdd(player, fakePlayer.getUUID());
                    PlayerConnectionEvent.addNocolPlayer(fakePlayer.getUUID());
                }
            }
            EntityData.PLAYER_SKIN_PARTS.set((Entity)fakePlayer, (byte)127);
        } else {
            entity = this.modifiers.playerAsEntity.createEntity((Level)this.level);
            if (entity == null) {
                commandInfo.sendFailure("playback.start.warning.unknown_entity", this.modifiers.playerAsEntity.entityId);
                throw new Playback.StartException();
            }
            recording.initEntityPosition((Entity)entity, transformer);
            entity.setDeltaMovement(0.0, 0.0, 0.0);
            entity.setInvulnerable(((Boolean)Settings.INVULNERABLE_PLAYBACK.val).booleanValue());
            entity.setNoGravity(true);
            if (entity instanceof Mob) {
                ((Mob)entity).setNoAi(true);
            }
            this.modifiers.transformations.scale.applyToPlayer((Entity)entity);
            this.level.addFreshEntity(entity);
            recording.preExecute((Entity)entity, transformer);
            if (((Boolean)Settings.ALLOW_GHOSTS.val).booleanValue()) {
                ghost = new FakePlayer(this.level, newProfile, this);
                ghost.gameMode.changeGameModeForPlayer((Boolean)Settings.USE_CREATIVE_GAME_MODE.val != false ? GameType.CREATIVE : GameType.SURVIVAL);
                recording.initEntityPosition((Entity)ghost, transformer);
                this.level.addNewPlayer((ServerPlayer)ghost);
            }
        }
        this.ctx = new ActionContext(this.owner, packetTargets, (Entity)entity, recording.startPos, this.modifiers, ghost, transformer);
    }

    @Nullable
    protected static RecordingPlayback startRoot(CommandInfo commandInfo, @Nullable RecordingData recording, PlaybackModifiers modifiers) {
        try {
            return new RecordingPlayback(commandInfo, recording, modifiers, null, null);
        }
        catch (Playback.StartException e) {
            return null;
        }
    }

    @Nullable
    protected static RecordingPlayback startSubscene(CommandInfo commandInfo, DataManager dataManager, Playback parent, SceneData.Subscene info) {
        try {
            return new RecordingPlayback(commandInfo, dataManager.getRecording(info.name), parent.modifiers, info, parent.getPosTransformer());
        }
        catch (Playback.StartException e) {
            return null;
        }
    }

    @Override
    public boolean tick() {
        if (this.dyingTicks > 0) {
            --this.dyingTicks;
            if (this.dyingTicks == 0) {
                this.ctx.removeMainEntity();
                this.stop();
                return true;
            }
            return false;
        }
        if (this.finished) {
            return true;
        }
        if (this.shouldExecuteTick()) {
            Action.Result result;
            do {
                result = this.recording.executeNext(this.ctx, this.pos++);
                if (result.endsPlayback) {
                    if (result == Action.Result.ERROR) {
                        Utils.sendMessage((Player)this.owner, "error.playback_error", new Object[0]);
                        MocapMod.LOGGER.error("Something went wrong during playback!");
                    } else if (this.recording.endsWithDeath) {
                        if (this.ctx.entity instanceof FakePlayer) {
                            ((FakePlayer)this.ctx.entity).fakeKill();
                        } else {
                            this.ctx.entity.kill();
                        }
                        if (this.ctx.entity instanceof LivingEntity) {
                            this.dyingTicks = 20;
                        }
                    }
                    this.finished = true;
                }
                if (result != Action.Result.REPEAT) continue;
                --this.pos;
            } while (!result.endsTick);
        }
        if (this.root && this.finished && this.dyingTicks == 0) {
            this.stop();
        }
        ++this.tickCounter;
        return this.finished && this.dyingTicks == 0;
    }

    @Override
    public void stop() {
        this.ctx.removeEntities();
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished && this.dyingTicks == 0;
    }

    @Override
    protected PositionTransformer getPosTransformer() {
        return this.ctx.transformer;
    }

    @Nullable
    private GameProfile getGameProfile(CommandInfo commandInfo) {
        String profileName = this.modifiers.playerName;
        Entity entity = commandInfo.sourceEntity;
        ServerLevel level = commandInfo.level;
        if (profileName == null) {
            profileName = (Boolean)Settings.START_AS_RECORDED.val != false && this.recording.playerName != null ? this.recording.playerName : (entity instanceof ServerPlayer ? ((ServerPlayer)entity).getGameProfile().getName() : (!level.players().isEmpty() ? ((Player)level.players().get(0)).getGameProfile().getName() : "Player"));
        }
        return ProfileUtils.getGameProfile(commandInfo.server, profileName);
    }
}

