/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.playback;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.command.CommandUtils;
import net.mt1006.mocap.command.io.CommandInfo;
import net.mt1006.mocap.command.io.CommandOutput;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.files.SceneData;
import net.mt1006.mocap.mocap.playing.DataManager;
import net.mt1006.mocap.mocap.playing.modifiers.PlaybackModifiers;
import net.mt1006.mocap.mocap.playing.modifiers.TransformationsConfig;
import net.mt1006.mocap.mocap.playing.playback.Playback;
import net.mt1006.mocap.mocap.playing.playback.PositionTransformer;
import org.jetbrains.annotations.Nullable;

public class ScenePlayback
extends Playback {
    private final List<Playback> subscenes = new ArrayList<Playback>();
    private final PositionTransformer transformer;

    private ScenePlayback(CommandInfo commandInfo, DataManager dataManager, String name, PlaybackModifiers parentModifiers, @Nullable SceneData.Subscene info, @Nullable PositionTransformer parentTransformer) throws Playback.StartException {
        super(info == null, commandInfo.level, commandInfo.sourcePlayer, parentModifiers, info);
        SceneData sceneData = dataManager.getScene(name);
        if (sceneData == null) {
            throw new Playback.StartException();
        }
        if (sceneData.subscenes.isEmpty() && this.root) {
            commandInfo.sendFailureWithTip("playback.start.error.empty_scene", new Object[0]);
            throw new Playback.StartException();
        }
        this.transformer = this.createPosTransformer(commandInfo, parentTransformer, sceneData, dataManager);
        for (SceneData.Subscene subscene : sceneData.subscenes) {
            Playback playback = Playback.start(commandInfo, dataManager, this, subscene);
            if (playback == null) {
                return;
            }
            this.subscenes.add(playback);
        }
    }

    @Nullable
    protected static ScenePlayback startRoot(CommandInfo commandInfo, DataManager dataManager, String name, PlaybackModifiers modifiers) {
        try {
            return new ScenePlayback(commandInfo, dataManager, name, modifiers, null, null);
        }
        catch (Playback.StartException e) {
            return null;
        }
    }

    @Nullable
    protected static ScenePlayback startSubscene(CommandInfo commandInfo, DataManager dataManager, Playback parent, SceneData.Subscene info) {
        try {
            return new ScenePlayback(commandInfo, dataManager, info.name, parent.modifiers, info, parent.getPosTransformer());
        }
        catch (Playback.StartException e) {
            return null;
        }
    }

    @Override
    public boolean tick() {
        if (this.finished) {
            return true;
        }
        if (this.shouldExecuteTick()) {
            this.finished = true;
            for (Playback scene : this.subscenes) {
                if (scene.tick()) continue;
                this.finished = false;
            }
        }
        if (this.root && this.finished) {
            this.stop();
        }
        ++this.tickCounter;
        return this.finished;
    }

    @Override
    public void stop() {
        this.subscenes.forEach(Playback::stop);
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    protected PositionTransformer getPosTransformer() {
        return this.transformer;
    }

    private PositionTransformer createPosTransformer(CommandOutput commandOutput, @Nullable PositionTransformer parent, SceneData sceneData, DataManager dataManager) throws Playback.StartException {
        if (this.modifiers.transformations.areDefault()) {
            return parent;
        }
        TransformationsConfig.SceneCenter center = this.modifiers.transformations.config.sceneCenter;
        if (center.type == TransformationsConfig.SceneCenterType.INDIVIDUAL || sceneData.subscenes.isEmpty()) {
            return new PositionTransformer(this.modifiers.transformations, parent, null);
        }
        Vec3 sceneStartPos = ScenePlayback.getSceneStartPos(commandOutput, center, sceneData, dataManager);
        return new PositionTransformer(this.modifiers.transformations, parent, sceneStartPos);
    }

    private static Vec3 getSceneStartPos(CommandOutput commandOutput, TransformationsConfig.SceneCenter centers, SceneData sceneData, DataManager dataManager) throws Playback.StartException {
        Vec3 subsceneStartPos;
        SceneData.Subscene subscene;
        TransformationsConfig.SceneCenterType centerType = centers.type;
        if (centerType == TransformationsConfig.SceneCenterType.COMMON_SPECIFIC && centers.specificStr == null) {
            centerType = TransformationsConfig.SceneCenterType.COMMON_FIRST;
        }
        switch (centerType) {
            case COMMON_FIRST: {
                SceneData.Subscene subscene2 = sceneData.subscenes.get(0);
                break;
            }
            case COMMON_LAST: {
                SceneData.Subscene subscene2 = sceneData.subscenes.get(sceneData.subscenes.size() - 1);
                break;
            }
            case COMMON_SPECIFIC: {
                SceneData.Subscene subscene2 = SceneData.loadSubscene(commandOutput, sceneData, CommandUtils.splitIdStr(centers.specificStr));
                break;
            }
            default: {
                SceneData.Subscene subscene2 = subscene = null;
            }
        }
        if (subscene == null) {
            throw new Playback.StartException();
        }
        if (subscene.name.startsWith(".")) {
            SceneData subsceneData = dataManager.getScene(subscene.name);
            subsceneStartPos = ScenePlayback.getSceneStartPos(commandOutput, subscene.modifiers.transformations.config.sceneCenter, subsceneData, dataManager);
        } else {
            RecordingData recording = dataManager.getRecording(subscene.name);
            if (recording == null) {
                throw new Playback.StartException();
            }
            subsceneStartPos = recording.startPos;
        }
        return subscene.modifiers.transformations.calculateCenter(subsceneStartPos);
    }
}

