/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.playing.skins;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.network.MocapPacketC2S;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class CustomClientSkinManager {
    private static final int MAX_CLIENT_CACHE_SIZE = 4096;
    private static final String SKIN_RES_PREFIX = "custom_skin/";
    private static final String SLIM_SKIN_RES_PREFIX = "custom_skin/slim/";
    private static final ConcurrentMap<String, Boolean> skinCache = new ConcurrentHashMap<String, Boolean>();
    private static boolean clientWarned = false;

    @Nullable
    public static ResourceLocation get(@Nullable String name) {
        if (name == null) {
            return null;
        }
        Boolean accessible = (Boolean)skinCache.get(name);
        if (accessible == null) {
            CustomClientSkinManager.loadClientSkin(name);
            return null;
        }
        return accessible != false ? CustomClientSkinManager.resFromName(name) : null;
    }

    public static void loadClientSkin(String name) {
        if (skinCache.size() > 4096) {
            if (clientWarned) {
                return;
            }
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            Utils.sendMessage((Player)player, "warning.custom_skin_cache_limit", new Object[0]);
            if (((Boolean)Settings.SHOW_TIPS.val).booleanValue()) {
                Utils.sendMessage((Player)player, "warning.custom_skin_cache_limit.tip", new Object[0]);
            }
            clientWarned = true;
            return;
        }
        skinCache.put(name, false);
        MocapPacketC2S.sendRequestCustomSkin(name);
    }

    public static void register(Pair<String, byte[]> customSkinData) {
        String name = (String)customSkinData.getFirst();
        byte[] array = (byte[])customSkinData.getSecond();
        Boolean accessible = (Boolean)skinCache.get(name);
        if (accessible == null || accessible.booleanValue()) {
            return;
        }
        try {
            NativeImage nativeImage;
            try {
                nativeImage = NativeImage.read((byte[])array);
            }
            catch (IOException e) {
                Utils.exception(e, "Failed to load skin texture into buffer!");
                return;
            }
            if (nativeImage.getWidth() > 4096 || nativeImage.getHeight() > 4096) {
                MocapMod.LOGGER.error("Skin texture too big!");
                return;
            }
            Minecraft.getInstance().getTextureManager().register(CustomClientSkinManager.resFromName(name), (AbstractTexture)new DynamicTexture(nativeImage));
            skinCache.put(name, true);
        }
        catch (Exception e) {
            Utils.exception(e, "Failed to read skin texture!");
        }
    }

    public static void clearCache() {
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        for (Map.Entry entry : skinCache.entrySet()) {
            Boolean val = (Boolean)entry.getValue();
            if (val == null || !val.booleanValue()) continue;
            textureManager.release(CustomClientSkinManager.resFromName((String)entry.getKey()));
        }
        skinCache.clear();
        clientWarned = false;
    }

    public static boolean isSlimSkin(ResourceLocation res) {
        return res.getPath().startsWith(SLIM_SKIN_RES_PREFIX);
    }

    private static ResourceLocation resFromName(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"mocap", (String)(SKIN_RES_PREFIX + name));
    }
}

