/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.recording;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.mt1006.mocap.mixin.fields.LevelFields;
import net.mt1006.mocap.mocap.actions.EntityUpdate;
import net.mt1006.mocap.mocap.recording.PositionTracker;
import net.mt1006.mocap.mocap.recording.RecordedEntityState;
import net.mt1006.mocap.mocap.recording.RecordingContext;
import net.mt1006.mocap.mocap.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class EntityTracker {
    private final RecordingContext ctx;
    private final Map<Entity, TrackedEntity> map = new HashMap<Entity, TrackedEntity>();
    private int counter = 0;
    private Entity playerVehicle = null;

    public EntityTracker(RecordingContext ctx) {
        this.ctx = ctx;
    }

    public TrackedEntity get(Entity entity) {
        return this.map.get(entity);
    }

    public void onTick() {
        if ((Double)Settings.ENTITY_TRACKING_DISTANCE.val != 0.0) {
            this.updateTracked();
            this.updateVehicle();
        }
        this.removeOld();
    }

    private void updateTracked() {
        double entityTrackingDist = (Double)Settings.ENTITY_TRACKING_DISTANCE.val;
        boolean limitDistance = entityTrackingDist >= 0.0;
        double maxDistanceSqr = entityTrackingDist * entityTrackingDist;
        for (Entity entity : ((LevelFields)this.ctx.recordedPlayer.level()).callGetEntities().getAll()) {
            if (limitDistance && this.ctx.recordedPlayer.distanceToSqr(entity) > maxDistanceSqr || entity instanceof Player || ((Boolean)Settings.PREVENT_TRACKING_PLAYED_ENTITIES.val).booleanValue() && entity.getTags().contains("mocap_entity") || !this.ctx.entityFilter.isAllowed(entity)) continue;
            TrackedEntity trackedEntity = this.map.get(entity);
            if (trackedEntity == null) {
                trackedEntity = new TrackedEntity(this.ctx, this.counter++, entity);
                this.map.put(entity, trackedEntity);
                this.ctx.addAction(EntityUpdate.addEntity(trackedEntity.id, entity));
            }
            trackedEntity.onTick();
        }
    }

    private void updateVehicle() {
        TrackedEntity trackedEntity;
        Entity newPlayerVehicle = this.ctx.recordedPlayer.getVehicle();
        if (newPlayerVehicle == null) {
            if (this.playerVehicle != null) {
                this.ctx.addAction(EntityUpdate.playerDismount());
                this.playerVehicle = null;
            }
            return;
        }
        if (newPlayerVehicle.equals((Object)this.playerVehicle)) {
            return;
        }
        if (this.playerVehicle != null) {
            this.ctx.addAction(EntityUpdate.playerDismount());
            this.playerVehicle = null;
        }
        if ((trackedEntity = this.map.get(newPlayerVehicle)) != null) {
            this.ctx.addAction(EntityUpdate.playerMount(trackedEntity.id));
            this.playerVehicle = newPlayerVehicle;
        }
    }

    private void removeOld() {
        int tick = this.ctx.getTick();
        ArrayList<Entity> toRemove = new ArrayList<Entity>();
        for (Map.Entry<Entity, TrackedEntity> entry : this.map.entrySet()) {
            if (entry.getValue().lastTick == tick) continue;
            if (!entry.getValue().dying) {
                int entityId = entry.getValue().id;
                EntityUpdate entityUpdate = entry.getKey().getRemovalReason() == Entity.RemovalReason.KILLED ? EntityUpdate.kill(entityId) : EntityUpdate.removeEntity(entityId);
                this.ctx.addAction(entityUpdate);
            }
            toRemove.add(entry.getKey());
        }
        toRemove.forEach(this.map::remove);
    }

    public static class TrackedEntity {
        private final RecordingContext ctx;
        private final int id;
        private final Entity entity;
        private final PositionTracker positionTracker;
        @Nullable
        private RecordedEntityState previousState = null;
        private boolean dying;
        private int lastTick;

        public TrackedEntity(RecordingContext ctx, int id, Entity entity) {
            this.ctx = ctx;
            this.id = id;
            this.entity = entity;
            this.positionTracker = new PositionTracker(entity, true);
        }

        public void onTick() {
            RecordedEntityState state = new RecordedEntityState(this.entity);
            state.saveTrackedEntityDifference(this.ctx.data.actions, this.id, this.previousState);
            this.previousState = state;
            this.positionTracker.onTick(this.ctx.data.actions, this.id);
            this.lastTick = this.ctx.getTick();
            if (this.entity instanceof LivingEntity && ((LivingEntity)this.entity).isDeadOrDying() && !this.dying) {
                this.ctx.addAction(EntityUpdate.kill(this.id));
                this.dying = true;
            }
        }

        public void onHurt() {
            this.ctx.addAction(EntityUpdate.hurt(this.id));
        }
    }
}

