/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.recording;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.EntityAction;
import net.mt1006.mocap.mocap.actions.Movement;
import net.mt1006.mocap.mocap.files.RecordingData;
import org.jetbrains.annotations.Nullable;

public class PositionTracker {
    private final Vec3 FAR_AWAY = new Vec3(0.0, 1000000.0, 0.0);
    private Entity entity;
    private final double[] position = new double[3];
    private final float[] rotation = new float[2];
    private float headRot;
    private boolean isOnGround;
    private boolean forceNonPosDataFlag;

    public PositionTracker(Entity entity, boolean initRotAndGround) {
        this.entity = entity;
        Vec3 posVec = entity.position();
        this.position[0] = posVec.x;
        this.position[1] = posVec.y;
        this.position[2] = posVec.z;
        this.rotation[0] = entity.getXRot();
        this.rotation[1] = entity.getYRot();
        this.headRot = entity.getYHeadRot();
        this.isOnGround = entity.onGround();
        this.forceNonPosDataFlag = initRotAndGround;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public void onTick(List<Action> actionList, @Nullable Integer entityId) {
        Movement movement = this.getDelta(true, this.forceNonPosDataFlag);
        this.forceNonPosDataFlag = false;
        if (movement == null) {
            return;
        }
        actionList.add(entityId != null ? new EntityAction(entityId, movement) : movement);
    }

    public void teleportFarAway(List<Action> actionList) {
        Movement movement = Movement.teleportToPos(this.FAR_AWAY, false);
        actionList.add(movement);
        movement.applyToPosition(this.position);
        this.rotation[0] = 0.0f;
        this.rotation[1] = 0.0f;
        this.headRot = 0.0f;
        this.isOnGround = false;
    }

    @Nullable
    public Movement getDelta() {
        return this.getDelta(false, false);
    }

    @Nullable
    private Movement getDelta(boolean applyChanges, boolean forceNonPosData) {
        float newXRot = this.entity.getXRot();
        float newYRot = this.entity.getYRot();
        float newHeadRot = this.entity.getYHeadRot();
        boolean newIsOnGround = this.entity.onGround();
        Movement movement = Movement.delta(this.position, this.entity.position(), this.rotation, newXRot, newYRot, this.headRot, newHeadRot, this.isOnGround, newIsOnGround, forceNonPosData);
        if (applyChanges) {
            this.rotation[0] = newXRot;
            this.rotation[1] = newYRot;
            this.headRot = newHeadRot;
            this.isOnGround = newIsOnGround;
            if (movement != null) {
                movement.applyToPosition(this.position);
            }
        }
        return movement;
    }

    public void writeToRecordingData(RecordingData data) {
        data.startPos = new Vec3(this.position[0], this.position[1], this.position[2]);
        data.startRot[0] = this.rotation[1];
        data.startRot[1] = this.rotation[0];
    }
}

