/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.recording;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.ComparableAction;
import net.mt1006.mocap.mocap.actions.EntityAction;
import org.jetbrains.annotations.Nullable;

public class RecordedEntityState {
    public final List<ComparableAction> actions = new ArrayList<ComparableAction>(ComparableAction.REGISTERED.size());

    public RecordedEntityState(Entity entity) {
        ComparableAction.REGISTERED.forEach(constructor -> this.actions.add((ComparableAction)constructor.apply(entity)));
    }

    public boolean differs(@Nullable RecordedEntityState previousActions) {
        if (previousActions == null) {
            return false;
        }
        for (int i = 0; i < this.actions.size(); ++i) {
            if (!this.actions.get(i).differs(previousActions.actions.get(i))) continue;
            return true;
        }
        return false;
    }

    public void saveDifference(List<Action> actionList, @Nullable RecordedEntityState previousActions) {
        if (previousActions == null) {
            for (ComparableAction action : this.actions) {
                if (!action.shouldBeInitialized()) continue;
                actionList.add(action);
            }
            return;
        }
        for (int i = 0; i < this.actions.size(); ++i) {
            ComparableAction previousAction;
            ComparableAction action = this.actions.get(i);
            if (!action.differs(previousAction = previousActions.actions.get(i))) continue;
            actionList.add(action);
        }
    }

    public void saveTrackedEntityDifference(List<Action> actionList, int id, @Nullable RecordedEntityState previousActions) {
        if (previousActions == null) {
            for (ComparableAction action : this.actions) {
                if (!action.shouldBeInitialized()) continue;
                actionList.add(new EntityAction(id, action));
            }
            return;
        }
        for (int i = 0; i < ComparableAction.REGISTERED.size(); ++i) {
            ComparableAction previousAction;
            ComparableAction action = this.actions.get(i);
            if (!action.differs(previousAction = previousActions.actions.get(i))) continue;
            actionList.add(new EntityAction(id, action));
        }
    }
}

