/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.recording;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.command.CommandSuggestions;
import net.mt1006.mocap.command.CommandsContext;
import net.mt1006.mocap.command.io.CommandInfo;
import net.mt1006.mocap.command.io.CommandOutput;
import net.mt1006.mocap.mocap.files.Files;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.Playing;
import net.mt1006.mocap.mocap.recording.EntityTracker;
import net.mt1006.mocap.mocap.recording.RecordingContext;
import net.mt1006.mocap.mocap.recording.RecordingId;
import net.mt1006.mocap.mocap.settings.Settings;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class Recording {
    private static final QuickDiscard quickDiscard = QuickDiscard.SAFE;
    private static final Multimap<String, RecordingContext> contextsBySource = HashMultimap.create();
    private static final Collection<RecordingContext> contexts = contextsBySource.values();
    public static final BiMultimap<ServerPlayer, RecordingContext> waitingForRespawn = new BiMultimap();

    public static boolean start(CommandInfo commandInfo, ServerPlayer recordedPlayer, @Nullable String instantSave) {
        if (!Recording.checkDoubleStart(commandInfo, recordedPlayer)) {
            return false;
        }
        boolean startInstantly = (Boolean)Settings.START_INSTANTLY.val;
        boolean success = Recording.start(recordedPlayer, commandInfo.sourcePlayer, instantSave, startInstantly, true);
        if (success && !startInstantly) {
            commandInfo.sendSuccess(recordedPlayer.equals((Object)commandInfo.sourcePlayer) ? "recording.start.waiting_for_action.self" : "recording.start.waiting_for_action.another_player", new Object[0]);
        }
        if (!success) {
            commandInfo.sendFailure("recording.start.error", new Object[0]);
        }
        return success;
    }

    public static boolean start(ServerPlayer recordedPlayer, @Nullable ServerPlayer sourcePlayer, @Nullable String instantSave, boolean startNow, boolean sendMessage) {
        RecordingId id = new RecordingId(contexts, recordedPlayer, sourcePlayer);
        if (!id.isProper()) {
            return false;
        }
        RecordingContext ctx = new RecordingContext(id, recordedPlayer, sourcePlayer, instantSave);
        contextsBySource.put((Object)(sourcePlayer != null ? sourcePlayer.getName().getString() : ""), (Object)ctx);
        CommandSuggestions.inputSet.add(id.str);
        if (startNow) {
            ctx.start(sendMessage);
        }
        return true;
    }

    private static boolean checkDoubleStart(CommandInfo commandInfo, ServerPlayer recordedPlayer) {
        ServerPlayer sourcePlayer = commandInfo.sourcePlayer;
        if (sourcePlayer == null) {
            return true;
        }
        String recordedPlayerName = recordedPlayer.getName().getString();
        if (!recordedPlayerName.equals(CommandsContext.get((ServerPlayer)sourcePlayer).doubleStart)) {
            for (RecordingContext ctx : contexts) {
                if (ctx.sourcePlayer != sourcePlayer || ctx.recordedPlayer != recordedPlayer) continue;
                Recording.handleDoubleStart(commandInfo, ctx);
                return false;
            }
        }
        CommandsContext.get((ServerPlayer)sourcePlayer).doubleStart = null;
        return true;
    }

    private static void handleDoubleStart(CommandOutput commandOutput, RecordingContext ctx) {
        boolean addToDoubleStart = false;
        switch (ctx.state) {
            case WAITING_FOR_ACTION: {
                ctx.start(true);
                break;
            }
            case RECORDING: {
                commandOutput.sendFailureWithTip("recording.start.already_recording", new Object[0]);
                addToDoubleStart = true;
                break;
            }
            case WAITING_FOR_DECISION: {
                commandOutput.sendFailureWithTip("recording.start.waiting_for_decision", new Object[0]);
                addToDoubleStart = true;
                break;
            }
            default: {
                MocapMod.LOGGER.error("Undefined recording context state supplied to double start handler!");
                commandOutput.sendFailureWithTip("recording.start.error", new Object[0]);
            }
        }
        if (addToDoubleStart && ctx.sourcePlayer != null) {
            CommandsContext.get((ServerPlayer)ctx.sourcePlayer).doubleStart = ctx.recordedPlayer.getName().getString();
        }
    }

    public static boolean startMultiple(CommandInfo commandInfo, String str) {
        return true;
    }

    public static boolean stop(CommandInfo commandInfo, @Nullable String id) {
        boolean success;
        ResolvedContexts resolvedContexts = ResolvedContexts.resolve(commandInfo, id, false);
        if (resolvedContexts == null) {
            return false;
        }
        boolean bl = success = resolvedContexts.isSingle ? Recording.stopSingle(commandInfo, resolvedContexts.list.iterator().next()) : Recording.stopMultiple(commandInfo, resolvedContexts.list);
        if (CommandsContext.haveSyncEnabled != 0) {
            Recording.refreshSyncOnStop(resolvedContexts);
        }
        return success;
    }

    private static boolean stopSingle(CommandInfo commandInfo, RecordingContext ctx) {
        if (ctx.state == RecordingContext.State.WAITING_FOR_DECISION) {
            if (!quickDiscard.allowsSingle(ctx)) {
                commandInfo.sendFailureWithTip("recording.stop.quick_discard.disabled", new Object[0]);
                return false;
            }
            return Recording.discardSingle(commandInfo, ctx);
        }
        ctx.stop(commandInfo);
        switch (ctx.state) {
            case WAITING_FOR_DECISION: {
                commandInfo.sendSuccess("recording.stop.stopped", new Object[0]);
                if (((Boolean)Settings.SHOW_TIPS.val).booleanValue()) {
                    commandInfo.sendSuccess(quickDiscard.canBeUsed(ctx, commandInfo.sourcePlayer) ? "recording.stop.stopped.stop_tip" : "recording.stop.stopped.discard_tip", new Object[0]);
                }
                return true;
            }
            case CANCELED: {
                commandInfo.sendSuccess("recording.stop.canceled", new Object[0]);
                return true;
            }
            case SAVED: {
                commandInfo.sendSuccess("recording.stop.instant_save", ctx.instantSave != null ? ctx.instantSave : "[error]");
                return true;
            }
        }
        commandInfo.sendFailure("recording.undefined_state", ctx.state.name());
        return false;
    }

    private static boolean stopMultiple(CommandOutput commandOutput, Collection<RecordingContext> contexts) {
        int stopped = 0;
        int cancelled = 0;
        int saved = 0;
        int stillWaiting = 0;
        int unknownState = 0;
        block5: for (RecordingContext ctx : contexts) {
            if (ctx.state == RecordingContext.State.WAITING_FOR_DECISION) {
                ++stillWaiting;
                continue;
            }
            ctx.stop(commandOutput);
            switch (ctx.state) {
                case WAITING_FOR_DECISION: {
                    ++stopped;
                    continue block5;
                }
                case CANCELED: {
                    ++cancelled;
                    continue block5;
                }
                case SAVED: {
                    ++saved;
                    continue block5;
                }
            }
            ++unknownState;
        }
        if (stopped == 0 && cancelled == 0 && saved == 0 && stillWaiting == 0 && unknownState == 0) {
            commandOutput.sendSuccess("recording.multiple.results.none", new Object[0]);
            return true;
        }
        commandOutput.sendSuccess("recording.multiple.results", new Object[0]);
        if (stopped != 0) {
            commandOutput.sendSuccess("recording.multiple.results.stopped", stopped);
        }
        if (cancelled != 0) {
            commandOutput.sendSuccess("recording.multiple.results.cancelled", cancelled);
        }
        if (saved != 0) {
            commandOutput.sendSuccess("recording.multiple.results.saved", saved);
        }
        if (stillWaiting != 0) {
            commandOutput.sendSuccess("recording.multiple.results.still_waiting", stillWaiting);
        }
        if (unknownState != 0) {
            commandOutput.sendSuccess("recording.multiple.results.error", unknownState);
            commandOutput.sendFailure("recording.multiple.undefined_state", new Object[0]);
            return false;
        }
        return true;
    }

    private static void refreshSyncOnStop(ResolvedContexts resolvedContexts) {
        HashSet<ServerPlayer> players = new HashSet<ServerPlayer>();
        for (RecordingContext ctx : resolvedContexts.list) {
            if (ctx.sourcePlayer == null) continue;
            players.add(ctx.sourcePlayer);
        }
        for (ServerPlayer player : players) {
            boolean stillRecording = false;
            for (RecordingContext ctx : Recording.bySourcePlayer(player)) {
                if (ctx.state != RecordingContext.State.RECORDING) continue;
                stillRecording = true;
                break;
            }
            if (stillRecording) continue;
            Playing.stopAll(CommandOutput.DUMMY, player);
        }
    }

    public static boolean discard(CommandInfo commandInfo, @Nullable String id) {
        ResolvedContexts resolvedContexts = ResolvedContexts.resolve(commandInfo, id, false);
        if (resolvedContexts == null) {
            return false;
        }
        if (resolvedContexts.isSingle) {
            RecordingContext ctx = resolvedContexts.list.iterator().next();
            boolean showQuickDiscardTip = quickDiscard.canBeUsed(ctx, commandInfo.sourcePlayer) && (Boolean)Settings.SHOW_TIPS.val != false;
            boolean success = Recording.discardSingle(commandInfo, ctx);
            if (success && ctx.state == RecordingContext.State.DISCARDED && showQuickDiscardTip) {
                commandInfo.sendSuccess("recording.discard.quick_discard_tip", new Object[0]);
            }
            return success;
        }
        return Recording.discardMultiple(commandInfo, resolvedContexts.list);
    }

    private static boolean discardSingle(CommandOutput commandOutput, RecordingContext ctx) {
        if (ctx.state == RecordingContext.State.RECORDING) {
            commandOutput.sendFailure("recording.discard.not_stopped", new Object[0]);
            return false;
        }
        ctx.discard();
        switch (ctx.state) {
            case DISCARDED: {
                commandOutput.sendSuccess("recording.discard.discarded", new Object[0]);
                return true;
            }
            case CANCELED: {
                commandOutput.sendSuccess("recording.stop.canceled", new Object[0]);
                return true;
            }
        }
        commandOutput.sendFailure("recording.undefined_state", ctx.state.name());
        return false;
    }

    private static boolean discardMultiple(CommandOutput commandOutput, Collection<RecordingContext> contexts) {
        int discarded = 0;
        int cancelled = 0;
        int stillRecording = 0;
        int unknownState = 0;
        block4: for (RecordingContext ctx : contexts) {
            if (ctx.state == RecordingContext.State.RECORDING) {
                ++stillRecording;
                continue;
            }
            ctx.discard();
            switch (ctx.state) {
                case DISCARDED: {
                    ++discarded;
                    continue block4;
                }
                case CANCELED: {
                    ++cancelled;
                    continue block4;
                }
            }
            ++unknownState;
        }
        if (discarded == 0 && cancelled == 0 && stillRecording == 0 && unknownState == 0) {
            commandOutput.sendSuccess("recording.multiple.results.none", new Object[0]);
            return true;
        }
        commandOutput.sendSuccess("recording.multiple.results", new Object[0]);
        if (discarded != 0) {
            commandOutput.sendSuccess("recording.multiple.results.discarded", discarded);
        }
        if (cancelled != 0) {
            commandOutput.sendSuccess("recording.multiple.results.cancelled", cancelled);
        }
        if (stillRecording != 0) {
            commandOutput.sendSuccess("recording.multiple.results.still_recording", stillRecording);
        }
        if (unknownState != 0) {
            commandOutput.sendSuccess("recording.multiple.results.error", unknownState);
            commandOutput.sendFailure("recording.multiple.undefined_state", new Object[0]);
            return false;
        }
        return true;
    }

    public static boolean save(CommandInfo commandInfo, @Nullable String id, String name) {
        ResolvedContexts resolvedContexts = ResolvedContexts.resolve(commandInfo, id, false);
        if (resolvedContexts == null) {
            return false;
        }
        return resolvedContexts.isSingle ? Recording.saveSingle(commandInfo, resolvedContexts.list.iterator().next(), name, true) : Recording.saveMultiple(commandInfo, resolvedContexts.list, name);
    }

    public static boolean saveSingle(CommandOutput commandOutput, RecordingContext ctx, String name, boolean sendSavedMessage) {
        if (ctx.state == RecordingContext.State.RECORDING) {
            commandOutput.sendFailure("recording.save.not_stopped", new Object[0]);
            return false;
        }
        File recordingFile = Files.getRecordingFile(commandOutput, name);
        if (recordingFile == null) {
            return false;
        }
        if (recordingFile.exists()) {
            commandOutput.sendFailure("recording.save.already_exists", new Object[0]);
            String alternativeName = RecordingFiles.findAlternativeName(name);
            if (alternativeName != null) {
                commandOutput.sendFailure("recording.save.already_exists.alternative", alternativeName);
            }
            return false;
        }
        ctx.save(recordingFile, name);
        switch (ctx.state) {
            case SAVED: {
                if (sendSavedMessage) {
                    commandOutput.sendSuccess("recording.save.saved", new Object[0]);
                }
                return true;
            }
            case WAITING_FOR_DECISION: {
                commandOutput.sendFailure("recording.save.error", new Object[0]);
                return false;
            }
        }
        commandOutput.sendFailure("recording.undefined_state", ctx.state.name());
        return false;
    }

    private static boolean saveMultiple(CommandOutput commandOutput, Collection<RecordingContext> contexts, String namePrefix) {
        ArrayList<RecordingContext> stopped = new ArrayList<RecordingContext>();
        for (RecordingContext ctx : contexts) {
            if (ctx.state != RecordingContext.State.WAITING_FOR_DECISION) continue;
            stopped.add(ctx);
        }
        if (stopped.isEmpty()) {
            commandOutput.sendFailure("recording.save.multiple.nothing_to_save", new Object[0]);
            return false;
        }
        ArrayList<String> filenames = new ArrayList<String>();
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 1; i <= stopped.size(); ++i) {
            String filename = String.format("%s%d", namePrefix, i);
            File recordingFile = Files.getRecordingFile(commandOutput, filename);
            if (recordingFile == null) {
                return false;
            }
            if (recordingFile.exists()) {
                commandOutput.sendFailure("recording.save.multiple.already_exists", filename);
                return false;
            }
            filenames.add(filename);
            files.add(recordingFile);
        }
        boolean somethingFailed = false;
        for (int i = 0; i < stopped.size(); ++i) {
            RecordingContext ctx = (RecordingContext)stopped.get(i);
            ctx.save((File)files.get(i), (String)filenames.get(i));
            switch (ctx.state) {
                case SAVED: {
                    commandOutput.sendSuccess("recording.save.multiple.saved", ctx.id.str, filenames.get(i));
                    break;
                }
                case WAITING_FOR_DECISION: {
                    commandOutput.sendFailure("recording.save.multiple.failed", ctx.id.str, filenames.get(i));
                    break;
                }
                default: {
                    commandOutput.sendFailure("recording.save.multiple.unknown_state", ctx.id.str, filenames.get(i), ctx.state.name());
                }
            }
            if (ctx.state == RecordingContext.State.SAVED) continue;
            somethingFailed = true;
        }
        if (somethingFailed) {
            commandOutput.sendFailure("recording.save.multiple.error", new Object[0]);
        }
        return !somethingFailed;
    }

    public static boolean list(CommandInfo commandInfo, @Nullable String id) {
        ResolvedContexts resolvedContexts = ResolvedContexts.resolve(commandInfo, id, true);
        if (resolvedContexts == null) {
            return false;
        }
        if (resolvedContexts.isSingle) {
            RecordingContext ctx = resolvedContexts.list.iterator().next();
            commandInfo.sendSuccess("recording.list.state", resolvedContexts.fullId.str, ctx.state.name());
            return true;
        }
        ArrayList<String> waitingForAction = new ArrayList<String>();
        ArrayList recording = new ArrayList();
        ArrayList waitingForDecision = new ArrayList();
        ArrayList error = new ArrayList();
        for (RecordingContext ctx : resolvedContexts.list) {
            ArrayList<String> list = switch (ctx.state) {
                case RecordingContext.State.WAITING_FOR_ACTION -> waitingForAction;
                case RecordingContext.State.RECORDING -> recording;
                case RecordingContext.State.WAITING_FOR_DECISION -> waitingForDecision;
                default -> error;
            };
            list.add(ctx.id.str);
        }
        Collections.sort(waitingForAction);
        Collections.sort(recording);
        Collections.sort(waitingForDecision);
        Collections.sort(error);
        commandInfo.sendSuccess("recording.list.list", resolvedContexts.fullId.str);
        if (waitingForAction.isEmpty()) {
            commandInfo.sendSuccess("recording.list.waiting_for_action.none", new Object[0]);
        } else {
            commandInfo.sendSuccess("recording.list.waiting_for_action", StringUtils.join(waitingForAction, (String)" "));
        }
        if (recording.isEmpty()) {
            commandInfo.sendSuccess("recording.list.recording.none", new Object[0]);
        } else {
            commandInfo.sendSuccess("recording.list.recording", StringUtils.join(recording, (String)" "));
        }
        if (waitingForDecision.isEmpty()) {
            commandInfo.sendSuccess("recording.list.waiting_for_decision.none", new Object[0]);
        } else {
            commandInfo.sendSuccess("recording.list.waiting_for_decision", StringUtils.join(waitingForDecision, (String)" "));
        }
        if (!error.isEmpty()) {
            commandInfo.sendSuccess("recording.list.unknown_state", StringUtils.join(error, (String)" "));
            commandInfo.sendSuccess("recording.list.unknown_state.error", new Object[0]);
        }
        return true;
    }

    public static void onTick() {
        contexts.forEach(RecordingContext::onTick);
    }

    public static boolean isRecordedPlayer(@Nullable Entity entity) {
        if (contexts.isEmpty() || !(entity instanceof ServerPlayer)) {
            return false;
        }
        for (RecordingContext ctx : contexts) {
            if (!entity.equals((Object)ctx.recordedPlayer)) continue;
            return true;
        }
        return false;
    }

    public static boolean isActive() {
        return !contexts.isEmpty();
    }

    public static List<RecordingContext> byRecordedPlayer(int id) {
        ArrayList<RecordingContext> list = new ArrayList<RecordingContext>(1);
        for (RecordingContext ctx : contexts) {
            if (ctx.recordedPlayer.getId() != id) continue;
            list.add(ctx);
        }
        return list;
    }

    public static List<RecordingContext> byRecordedPlayer(Entity entity) {
        if (!(entity instanceof Player)) {
            return List.of();
        }
        ArrayList<RecordingContext> list = new ArrayList<RecordingContext>(1);
        for (RecordingContext ctx : contexts) {
            if (ctx.recordedPlayer != entity) continue;
            list.add(ctx);
        }
        return list;
    }

    @Nullable
    public static Collection<RecordingContext> resolveContexts(CommandInfo commandInfo, String id) {
        ResolvedContexts resolvedContexts = ResolvedContexts.resolve(commandInfo, id, false);
        return resolvedContexts != null ? resolvedContexts.list : null;
    }

    public static List<EntityTracker.TrackedEntity> listTrackedEntities(Entity entity) {
        ArrayList<EntityTracker.TrackedEntity> list = new ArrayList<EntityTracker.TrackedEntity>(1);
        for (RecordingContext ctx : contexts) {
            EntityTracker.TrackedEntity trackedEntity = ctx.getTrackedEntity(entity);
            if (trackedEntity == null) continue;
            list.add(trackedEntity);
        }
        return list;
    }

    public static Collection<RecordingContext> bySourcePlayer(ServerPlayer player) {
        return contextsBySource.get((Object)player.getName().getString());
    }

    public static void removeContext(RecordingContext ctx) {
        waitingForRespawn.removeByValue(ctx);
        contextsBySource.remove((Object)(ctx.sourcePlayer != null ? ctx.sourcePlayer.getName().getString() : ""), (Object)ctx);
        CommandSuggestions.inputSet.remove(ctx.id.str);
    }

    public static void onServerStop() {
        waitingForRespawn.clear();
        contextsBySource.clear();
    }

    private record ResolvedContexts(Collection<RecordingContext> list, boolean isSingle, RecordingId fullId) {
        @Nullable
        public static ResolvedContexts resolve(CommandInfo commandInfo, @Nullable String idStr, boolean listMode) {
            if (idStr == null) {
                if (listMode) {
                    return new ResolvedContexts(contexts, false, RecordingId.ALL);
                }
                RecordingContext ctx = ResolvedContexts.resolveEmpty(commandInfo);
                return ctx != null ? new ResolvedContexts(List.of(ctx), true, ctx.id) : null;
            }
            RecordingId id = new RecordingId(idStr, commandInfo.sourcePlayer);
            if (!id.isProper()) {
                if (idStr.contains("_")) {
                    commandInfo.sendFailureWithTip("recording.resolve.improper_group_structure", new Object[0]);
                } else {
                    commandInfo.sendFailure("recording.resolve.improper_structure", new Object[0]);
                    if (!listMode && ((Boolean)Settings.SHOW_TIPS.val).booleanValue()) {
                        commandInfo.sendFailure("recording.resolve.list_tip", new Object[0]);
                    }
                }
                return null;
            }
            ArrayList<RecordingContext> matchingContexts = new ArrayList<RecordingContext>();
            for (RecordingContext ctx : contexts) {
                if (!ctx.id.matches(id)) continue;
                matchingContexts.add(ctx);
            }
            boolean isSingle = id.isSingle();
            if (isSingle) {
                if (matchingContexts.size() > 1) {
                    MocapMod.LOGGER.error("Multiple recording contexts are matching single id!");
                }
                if (matchingContexts.isEmpty()) {
                    commandInfo.sendFailure("recording.resolve.not_found", new Object[0]);
                    if (!listMode && ((Boolean)Settings.SHOW_TIPS.val).booleanValue()) {
                        commandInfo.sendFailure("recording.resolve.list_tip", new Object[0]);
                    }
                    return null;
                }
            }
            return new ResolvedContexts(matchingContexts, isSingle, id);
        }

        @Nullable
        private static RecordingContext resolveEmpty(CommandInfo commandInfo) {
            ServerPlayer source = commandInfo.sourcePlayer;
            if (source == null) {
                commandInfo.sendFailure("failure.resolve_player", new Object[0]);
                return null;
            }
            Collection<RecordingContext> sourceContexts = Recording.bySourcePlayer(source);
            if (sourceContexts.size() > 1) {
                commandInfo.sendFailureWithTip("recording.resolve.multiple_recordings", new Object[0]);
                return null;
            }
            if (sourceContexts.isEmpty()) {
                if (contexts.isEmpty()) {
                    commandInfo.sendFailure("recording.resolve.server_not_recording", new Object[0]);
                } else {
                    commandInfo.sendFailureWithTip("recording.resolve.player_not_recording", new Object[0]);
                }
                return null;
            }
            return sourceContexts.iterator().next();
        }
    }

    private static enum QuickDiscard {
        ALLOW,
        DISALLOW,
        SAFE;


        public boolean allowsSingle(RecordingContext ctx) {
            return this == SAFE || this == ALLOW;
        }

        public boolean canBeUsed(RecordingContext ctx, @Nullable ServerPlayer source) {
            return this.allowsSingle(ctx) && source != null && Recording.bySourcePlayer(source).size() == 1;
        }
    }

    public static class BiMultimap<A, B> {
        public final Multimap<A, B> byKey = HashMultimap.create();
        public final Multimap<B, A> byValue = HashMultimap.create();

        public void put(A key, B val) {
            this.byKey.put(key, val);
            this.byValue.put(val, key);
        }

        public void removeByKey(A key) {
            Collection values = this.byKey.removeAll(key);
            values.forEach(v -> this.byValue.remove(v, key));
        }

        public void removeByValue(B val) {
            Collection keys = this.byValue.removeAll(val);
            keys.forEach(k -> this.byKey.remove(k, val));
        }

        public void clear() {
            this.byKey.clear();
            this.byValue.clear();
        }

        public boolean isEmpty() {
            return this.byKey.isEmpty() && this.byValue.isEmpty();
        }
    }
}

