/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.recording;

import java.io.File;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.mt1006.mocap.command.io.CommandOutput;
import net.mt1006.mocap.mocap.actions.Action;
import net.mt1006.mocap.mocap.actions.BlockAction;
import net.mt1006.mocap.mocap.actions.Die;
import net.mt1006.mocap.mocap.actions.NextTick;
import net.mt1006.mocap.mocap.actions.Respawn;
import net.mt1006.mocap.mocap.actions.SkipTicks;
import net.mt1006.mocap.mocap.files.RecordingData;
import net.mt1006.mocap.mocap.files.RecordingFiles;
import net.mt1006.mocap.mocap.playing.modifiers.EntityFilter;
import net.mt1006.mocap.mocap.recording.EntityTracker;
import net.mt1006.mocap.mocap.recording.PositionTracker;
import net.mt1006.mocap.mocap.recording.RecordedEntityState;
import net.mt1006.mocap.mocap.recording.Recording;
import net.mt1006.mocap.mocap.recording.RecordingId;
import net.mt1006.mocap.mocap.settings.Settings;
import net.mt1006.mocap.mocap.settings.enums.OnDeath;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class RecordingContext {
    public final RecordingId id;
    public ServerPlayer recordedPlayer;
    @Nullable
    public final ServerPlayer sourcePlayer;
    public final RecordingData data = RecordingData.forWriting();
    public State state = State.WAITING_FOR_ACTION;
    @Nullable
    private RecordedEntityState entityState = null;
    private final PositionTracker positionTracker;
    private final EntityTracker entityTracker = new EntityTracker(this);
    public final EntityFilter entityFilter;
    @Nullable
    public final String instantSave;
    private int tick = 0;
    private int diedOnTick = 0;
    private boolean died = false;

    public RecordingContext(RecordingId id, ServerPlayer recordedPlayer, @Nullable ServerPlayer sourcePlayer, @Nullable String instantSave) {
        this.id = id;
        this.recordedPlayer = recordedPlayer;
        this.sourcePlayer = sourcePlayer;
        this.positionTracker = new PositionTracker((Entity)recordedPlayer, false);
        this.entityFilter = EntityFilter.FOR_RECORDING;
        this.instantSave = instantSave;
        this.positionTracker.writeToRecordingData(this.data);
        if (((Boolean)Settings.ASSIGN_PLAYER_NAME.val).booleanValue()) {
            this.data.playerName = recordedPlayer.getName().getString();
        }
    }

    public void start(boolean sendMessage) {
        this.entityState = null;
        this.state = State.RECORDING;
        if (sendMessage) {
            Utils.sendMessage((Player)this.sourcePlayer, "recording.start.recording_started", new Object[0]);
        }
    }

    public void stop(CommandOutput commandOutput) {
        switch (this.state.ordinal()) {
            case 0: {
                State state = State.CANCELED;
                break;
            }
            case 1: {
                State state = State.WAITING_FOR_DECISION;
                break;
            }
            default: {
                State state = this.state = State.UNDEFINED;
            }
        }
        if (this.state == State.WAITING_FOR_DECISION && this.instantSave != null) {
            Recording.saveSingle(commandOutput, this, this.instantSave, false);
        }
        if (this.state.removed) {
            Recording.removeContext(this);
        }
    }

    public void discard() {
        switch (this.state.ordinal()) {
            case 0: {
                State state = State.CANCELED;
                break;
            }
            case 2: {
                State state = State.DISCARDED;
                break;
            }
            default: {
                State state = this.state = State.UNDEFINED;
            }
        }
        if (this.state.removed) {
            Recording.removeContext(this);
        }
    }

    public void save(File recordingFile, String name) {
        if (this.state == State.WAITING_FOR_DECISION) {
            if (!RecordingFiles.save(CommandOutput.LOGS, recordingFile, name, this.data)) {
                return;
            }
            this.state = State.SAVED;
        } else {
            this.state = State.UNDEFINED;
        }
        if (this.state.removed) {
            Recording.removeContext(this);
        }
    }

    public void onTick() {
        switch (this.state.ordinal()) {
            case 0: {
                this.onTickWaiting();
                break;
            }
            case 1: {
                this.onTickRecording();
            }
        }
    }

    private void onTickWaiting() {
        RecordedEntityState newEntityState = new RecordedEntityState((Entity)this.recordedPlayer);
        if (newEntityState.differs(this.entityState) || this.positionTracker.getDelta() != null) {
            this.start(true);
        } else {
            this.entityState = newEntityState;
        }
    }

    private void onTickRecording() {
        ++this.tick;
        if (this.died) {
            int tickDiff = this.tick - this.diedOnTick;
            if (Settings.ON_DEATH.val == OnDeath.CONTINUE_SYNCED || tickDiff < 20) {
                this.entityTracker.onTick();
                this.addTickAction();
            }
            if (tickDiff == 20) {
                if (Settings.ON_DEATH.val == OnDeath.END_RECORDING) {
                    this.stopRecording("recording.stop.stopped");
                } else if (Settings.ON_DEATH.val != OnDeath.SPLIT_RECORDING) {
                    this.positionTracker.teleportFarAway(this.data.actions);
                }
            }
            return;
        }
        RecordedEntityState newEntityState = new RecordedEntityState((Entity)this.recordedPlayer);
        newEntityState.saveDifference(this.data.actions, this.entityState);
        this.entityState = newEntityState;
        this.positionTracker.onTick(this.data.actions, null);
        this.entityTracker.onTick();
        if (this.recordedPlayer.isDeadOrDying()) {
            this.addAction(new Die());
            this.died = true;
            this.diedOnTick = this.tick;
            if (Settings.ON_DEATH.val != OnDeath.END_RECORDING) {
                Recording.waitingForRespawn.put(this.recordedPlayer, this);
            }
        } else if (this.recordedPlayer.isRemoved()) {
            this.stopRecording("recording.stop.stopped");
        }
        this.addTickAction();
    }

    public void onRespawn(ServerPlayer newPlayer) {
        if (Settings.ON_DEATH.val == OnDeath.SPLIT_RECORDING) {
            this.splitRecording(newPlayer);
            return;
        }
        this.died = false;
        this.recordedPlayer = newPlayer;
        this.positionTracker.setEntity((Entity)newPlayer);
        this.addAction(new Respawn());
    }

    public void stopRecording(String message) {
        this.state = State.WAITING_FOR_DECISION;
        Utils.sendMessage((Player)this.sourcePlayer, message, new Object[0]);
    }

    public void splitRecording(ServerPlayer newPlayer) {
        this.stopRecording("recording.stop.split");
        boolean success = Recording.start(newPlayer, this.sourcePlayer, null, true, false);
        if (!success) {
            Utils.sendMessage((Player)this.sourcePlayer, "recording.stop.split.error", new Object[0]);
        }
    }

    public void addAction(Action action) {
        if (this.state != State.RECORDING) {
            if (this.state == State.WAITING_FOR_ACTION) {
                this.start(true);
            } else {
                return;
            }
        }
        this.data.actions.add(action);
        if (action instanceof BlockAction) {
            this.data.blockActions.add((BlockAction)action);
        }
    }

    public void addTickAction() {
        int lastElementPos = this.data.actions.size() - 1;
        if (lastElementPos < 0) {
            this.addAction(new NextTick());
            return;
        }
        Action lastElement = this.data.actions.get(lastElementPos);
        if (lastElement instanceof NextTick) {
            this.data.actions.set(lastElementPos, new SkipTicks(2));
        } else if (lastElement instanceof SkipTicks && ((SkipTicks)lastElement).canBeModified()) {
            this.data.actions.set(lastElementPos, new SkipTicks(((SkipTicks)lastElement).number + 1));
        } else {
            this.addAction(new NextTick());
        }
    }

    @Nullable
    public EntityTracker.TrackedEntity getTrackedEntity(Entity entity) {
        return this.entityTracker.get(entity);
    }

    public int getTick() {
        return this.tick;
    }

    public static enum State {
        WAITING_FOR_ACTION(false),
        RECORDING(false),
        WAITING_FOR_DECISION(false),
        CANCELED(true),
        DISCARDED(true),
        SAVED(true),
        UNDEFINED(true);

        public final boolean removed;

        private State(boolean removed) {
            this.removed = removed;
        }
    }
}

