/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.mocap.settings;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.mt1006.mocap.command.io.CommandInfo;
import net.mt1006.mocap.mocap.files.Files;
import net.mt1006.mocap.utils.Utils;
import org.jetbrains.annotations.Nullable;

public class SettingFields {
    final Map<String, Field<?>> fieldMap = new HashMap();

    public BooleanField add(String name, boolean val) {
        BooleanField field = new BooleanField(name, val);
        this.addField(field, name);
        return field;
    }

    public DoubleField add(String name, double val) {
        DoubleField field = new DoubleField(name, val);
        this.addField(field, name);
        return field;
    }

    public StringField add(String name, String val, @Nullable Consumer<String> onSet, @Nullable Function<String, Boolean> testCommandInput) {
        StringField field = new StringField(name, val, onSet, testCommandInput);
        this.addField(field, name);
        return field;
    }

    public <T extends Enum<T>> EnumField<T> add(String name, Enum<T> val) {
        EnumField<T> field = new EnumField<T>(name, val);
        this.addField(field, name);
        return field;
    }

    private void addField(Field<?> field, String name) {
        if (this.fieldMap.put(name, field) != null) {
            throw new RuntimeException("Duplicate field names!");
        }
    }

    public void save() {
        try {
            File settingsFile = Files.getSettingsFile();
            if (settingsFile == null) {
                return;
            }
            PrintWriter printWriter = new PrintWriter(settingsFile);
            for (Field<?> setting : this.fieldMap.values()) {
                printWriter.print(setting.toFileLine());
            }
            printWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void load() {
        try {
            File settingsFile = Files.getSettingsFile();
            if (settingsFile == null) {
                return;
            }
            Scanner fileScanner = new Scanner(settingsFile);
            while (fileScanner.hasNextLine()) {
                String line = fileScanner.nextLine();
                if (line.isEmpty()) continue;
                String[] parts = line.split("=");
                if (parts.length != 2) {
                    fileScanner.close();
                    return;
                }
                Field<?> field = this.fieldMap.get(parts[0]);
                if (field == null) continue;
                field.fromString(parts[1]);
            }
            fileScanner.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unload() {
        this.fieldMap.values().forEach(Field::reset);
    }

    public static class BooleanField
    extends Field<Boolean> {
        public BooleanField(String name, Boolean val) {
            super(name, val, null);
        }

        @Override
        public Boolean parseFromString(String str) {
            return Boolean.valueOf(str);
        }

        @Override
        public Boolean parseFromCommand(CommandInfo commandInfo) {
            return commandInfo.getBool("new_value");
        }

        @Override
        public ArgumentType<?> getArgumentType() {
            return BoolArgumentType.bool();
        }
    }

    public static abstract class Field<T> {
        public final String name;
        @Nullable
        private final Consumer<T> onSet;
        protected final T defVal;
        public T val;

        public Field(String name, T defVal, @Nullable Consumer<T> onSet) {
            this.name = name;
            this.defVal = defVal;
            this.val = defVal;
            this.onSet = onSet;
            if (onSet != null) {
                onSet.accept(this.val);
            }
        }

        public void set(T val) {
            this.val = val;
            if (this.onSet != null) {
                this.onSet.accept(val);
            }
        }

        private void reset() {
            this.set(this.defVal);
        }

        public Component getInfo(CommandInfo commandInfo) {
            String key = this.val.equals(this.defVal) ? "settings.list.info_def" : "settings.list.info";
            return commandInfo.getTranslatableComponent(key, this.name, this.valToString());
        }

        public void printValues(CommandInfo commandInfo) {
            commandInfo.sendSuccess("settings.info.current_value", this.valToString());
            commandInfo.sendSuccess("settings.info.default_value", this.valToString(this.defVal));
        }

        public final String toFileLine() {
            return this.name + "=" + this.valToString() + "\n";
        }

        public final void fromString(String str) {
            try {
                this.set(this.parseFromString(str));
            }
            catch (Exception e) {
                Utils.exception(e, "Failed to load settings from string");
                this.reset();
            }
        }

        public final boolean fromCommand(CommandInfo commandInfo) {
            try {
                T newVal = this.parseFromCommand(commandInfo);
                if (newVal == null) {
                    commandInfo.sendFailure("settings.set.invalid_value", new Object[0]);
                    return false;
                }
                this.set(newVal);
                return true;
            }
            catch (Exception e) {
                commandInfo.sendException(e, "settings.set.error", new Object[0]);
                this.reset();
                return false;
            }
        }

        public final String valToString() {
            return this.valToString(this.val);
        }

        protected String valToString(T val) {
            return val.toString();
        }

        @Nullable
        public SuggestionProvider<CommandSourceStack> getSuggestionProvider() {
            return null;
        }

        public abstract T parseFromString(String var1);

        @Nullable
        public abstract T parseFromCommand(CommandInfo var1);

        public abstract ArgumentType<?> getArgumentType();
    }

    public static class DoubleField
    extends Field<Double> {
        public DoubleField(String name, Double val) {
            super(name, val, null);
        }

        @Override
        public Double parseFromString(String str) {
            return Double.valueOf(str);
        }

        @Override
        public Double parseFromCommand(CommandInfo commandInfo) {
            return commandInfo.getDouble("new_value");
        }

        @Override
        public ArgumentType<?> getArgumentType() {
            return DoubleArgumentType.doubleArg();
        }
    }

    public static class StringField
    extends Field<String> {
        @Nullable
        private final Function<String, Boolean> testCommandInput;

        public StringField(String name, String val, @Nullable Consumer<String> onSet, @Nullable Function<String, Boolean> testCommandInput) {
            super(name, val, onSet);
            this.testCommandInput = testCommandInput;
        }

        @Override
        public String parseFromString(String str) {
            return this.testCommandInput == null || this.testCommandInput.apply(str) != false ? str : (String)this.defVal;
        }

        @Override
        @Nullable
        public String parseFromCommand(CommandInfo commandInfo) {
            String newValue = commandInfo.getString("new_value");
            return this.testCommandInput == null || this.testCommandInput.apply(newValue) != false ? newValue : null;
        }

        @Override
        public ArgumentType<?> getArgumentType() {
            return StringArgumentType.greedyString();
        }

        @Override
        public void printValues(CommandInfo commandInfo) {
            String valStr = (String)this.val;
            String defValStr = (String)this.defVal;
            commandInfo.sendSuccess("settings.info.string_value", commandInfo.getTranslatableComponent("settings.info.current_value", valStr), StringField.createButton(commandInfo, valStr));
            commandInfo.sendSuccess("settings.info.string_value", commandInfo.getTranslatableComponent("settings.info.default_value", defValStr), StringField.createButton(commandInfo, defValStr));
        }

        private static Component createButton(CommandInfo commandInfo, String textToCopy) {
            ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, textToCopy);
            HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)commandInfo.getTranslatableComponent("settings.info.copy_button_info", new Object[0]));
            return commandInfo.getTranslatableComponent("settings.info.copy_button", new Object[0]).setStyle(Style.EMPTY.withClickEvent(clickEvent).withHoverEvent(hoverEvent));
        }
    }

    public static class EnumField<T extends Enum<T>>
    extends Field<Enum<T>> {
        private final Class<T> enumClass;
        private final T[] constants;

        public EnumField(String name, Enum<T> val) {
            super(name, val, null);
            this.enumClass = val.getClass();
            this.constants = (Enum[])this.enumClass.getEnumConstants();
        }

        @Override
        public Enum<T> parseFromString(String str) {
            return Enum.valueOf(this.enumClass, str.toUpperCase());
        }

        @Override
        @Nullable
        public Enum<T> parseFromCommand(CommandInfo commandInfo) {
            String newValue = commandInfo.getString("new_value");
            try {
                return Enum.valueOf(this.enumClass, newValue.toUpperCase());
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public ArgumentType<?> getArgumentType() {
            return StringArgumentType.word();
        }

        @Override
        protected String valToString(Enum<T> val) {
            return val.toString().toLowerCase();
        }

        @Override
        public SuggestionProvider<CommandSourceStack> getSuggestionProvider() {
            return this::suggestionProvider;
        }

        private CompletableFuture<Suggestions> suggestionProvider(CommandContext<?> ctx, SuggestionsBuilder builder) {
            String remaining = builder.getRemaining();
            for (T e : this.constants) {
                String str = ((Enum)e).name().toLowerCase();
                if (!str.startsWith(remaining)) continue;
                builder.suggest(str);
            }
            return builder.buildFuture();
        }
    }
}

