/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.events.PlayerConnectionEvent;
import net.mt1006.mocap.mocap.playing.skins.CustomServerSkinManager;
import net.mt1006.mocap.network.MocapPacketS2C;
import net.mt1006.mocap.network.NetworkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MocapPacketC2S
implements CustomPacketPayload {
    private static final String TYPE_ID = MocapMod.loaderInterface.getLoaderName().toLowerCase() + "_c2s";
    public static final CustomPacketPayload.Type<MocapPacketC2S> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mocap", (String)TYPE_ID));
    public static final StreamCodec<FriendlyByteBuf, MocapPacketC2S> CODEC = StreamCodec.of((b, p) -> p.encode((FriendlyByteBuf)b), MocapPacketC2S::new);
    public static final int ACCEPT_SERVER = 0;
    public static final int REQUEST_CUSTOM_SKIN = 1;
    private final int version;
    private final int op;
    private final Object object;

    public MocapPacketC2S(int op, Object object) {
        this.version = 5;
        this.op = op;
        this.object = object;
    }

    public MocapPacketC2S(FriendlyByteBuf buf) {
        this.version = buf.readInt();
        this.op = buf.readInt();
        switch (this.op) {
            case 1: {
                this.object = NetworkUtils.readString(buf);
                break;
            }
            default: {
                this.object = null;
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public FriendlyByteBuf encode(FriendlyByteBuf buf) {
        buf.writeInt(this.version);
        buf.writeInt(this.op);
        if (this.op == 1 && this.object instanceof String) {
            NetworkUtils.writeString(buf, (String)this.object);
        }
        return buf;
    }

    public void handle(Client client) {
        if (this.version != 5) {
            return;
        }
        ServerPlayer player = client.getPlayer();
        switch (this.op) {
            case 0: {
                PlayerConnectionEvent.addPlayer(player);
                PlayerConnectionEvent.experimentalReleaseWarning(player);
                break;
            }
            case 1: {
                if (!(this.object instanceof String)) break;
                CustomServerSkinManager.sendSkinToClient(player, (String)this.object);
            }
        }
    }

    public static void sendAcceptServer(MocapPacketS2C.Server server) {
        server.respond(new MocapPacketC2S(0, null));
    }

    public static void sendRequestCustomSkin(String name) {
        MocapPacketC2S.send(1, name);
    }

    private static void send(int op, Object object) {
        MocapMod.loaderInterface.sendPacketToServer(new MocapPacketC2S(op, object));
    }

    public static interface Client {
        @Nullable
        public ServerPlayer getPlayer();

        public void respond(MocapPacketS2C var1);
    }
}

