/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.utils;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.Entity;
import net.mt1006.mocap.MocapMod;
import net.mt1006.mocap.mixin.fields.AbstractHorseFields;
import net.mt1006.mocap.mixin.fields.EntityFields;
import net.mt1006.mocap.mixin.fields.LivingEntityFields;
import net.mt1006.mocap.mixin.fields.PlayerFields;
import org.jetbrains.annotations.Nullable;

public class EntityData {
    public static final DataIndex<Byte> ENTITY_FLAGS = new DataIndex<Byte>(EntityFields.getDATA_SHARED_FLAGS_ID());
    public static final DataIndex<Byte> LIVING_ENTITY_FLAGS = new DataIndex<Byte>(LivingEntityFields.getDATA_LIVING_ENTITY_FLAGS());
    public static final DataIndex<List<ParticleOptions>> LIVING_ENTITY_EFFECT_PARTICLES = new DataIndex<List<ParticleOptions>>(LivingEntityFields.getDATA_EFFECT_PARTICLES());
    public static final DataIndex<Boolean> LIVING_ENTITY_EFFECT_AMBIENCE = new DataIndex<Boolean>(LivingEntityFields.getDATA_EFFECT_AMBIENCE_ID());
    public static final DataIndex<Byte> PLAYER_SKIN_PARTS = new DataIndex<Byte>(PlayerFields.getDATA_PLAYER_MODE_CUSTOMISATION());
    public static final DataIndex<Byte> ABSTRACT_HORSE_FLAGS = new DataIndex<Byte>(AbstractHorseFields.getDATA_ID_FLAGS());

    public static class DataIndex<T> {
        @Nullable
        private final EntityDataAccessor<T> accessor;

        public DataIndex(@Nullable EntityDataAccessor<T> accessor) {
            this.accessor = accessor;
            if (accessor == null) {
                MocapMod.LOGGER.error("Failed to initialize one of the data indexes!");
            }
        }

        public void set(Entity entity, T val) {
            if (this.accessor != null) {
                entity.getEntityData().set(this.accessor, val);
            }
        }

        public T valOrDef(Entity entity, T defVal) {
            return (T)(this.accessor != null ? entity.getEntityData().get(this.accessor) : defVal);
        }
    }
}

