/*
 * Decompiled with CFR 0.152.
 */
package net.mt1006.mocap.utils;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.GameProfileCache;
import net.mt1006.mocap.MocapMod;

public class ProfileUtils {
    public static final String USERID_CACHE_FILE = "usercache.json";
    public static final Map<String, GameProfile> gameProfileCache = Collections.synchronizedMap(new HashMap());
    public static GameProfileCache profileCache = null;
    public static MinecraftSessionService sessionService = null;

    public static GameProfile getGameProfile(MinecraftServer server, String playerName) {
        ProfileResult profileResult;
        UUID offlineUUID;
        Optional optional;
        GameProfile gameProfile;
        Property property;
        if (gameProfileCache.containsKey(playerName)) {
            return gameProfileCache.get(playerName);
        }
        if (profileCache == null || sessionService == null) {
            if (MocapMod.isDedicatedServer) {
                sessionService = server.getSessionService();
                profileCache = server.getProfileCache();
            } else {
                ProfileUtils.setClientProfileLookupObjects();
            }
        }
        if ((property = (Property)Iterables.getFirst((Iterable)(gameProfile = (optional = profileCache != null ? profileCache.get(playerName) : Optional.empty()).orElse(new GameProfile(offlineUUID = UUIDUtil.createOfflinePlayerUUID((String)playerName), playerName))).getProperties().get((Object)"textures"), null)) == null && !gameProfile.getId().equals(offlineUUID) && (profileResult = sessionService.fetchProfile(gameProfile.getId(), true)) != null) {
            gameProfile = profileResult.profile();
        }
        gameProfileCache.put(gameProfile.getName(), gameProfile);
        return gameProfile;
    }

    private static void setClientProfileLookupObjects() {
        YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(Minecraft.getInstance().getProxy());
        sessionService = yggdrasilauthenticationservice.createMinecraftSessionService();
        GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
        profileCache = new GameProfileCache(gameprofilerepository, new File(Minecraft.getInstance().gameDirectory, USERID_CACHE_FILE));
    }
}

