/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.spout;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;

public class FillingBySpout {
    public static boolean canItemBeFilled(Level world, ItemStack stack) {
        SingleRecipeInput input = new SingleRecipeInput(stack);
        Optional<RecipeHolder<FillingRecipe>> assemblyRecipe = SequencedAssemblyRecipe.getRecipe(world, input, AllRecipeTypes.FILLING.getType(), FillingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return true;
        }
        if (AllRecipeTypes.FILLING.find(input, world).isPresent()) {
            return true;
        }
        return GenericItemFilling.canItemBeFilled(world, stack);
    }

    public static int getRequiredAmountForItem(Level world, ItemStack stack, FluidStack availableFluid) {
        FluidIngredient requiredFluid;
        SingleRecipeInput input = new SingleRecipeInput(stack);
        Optional<RecipeHolder<FillingRecipe>> assemblyRecipe = SequencedAssemblyRecipe.getRecipe(world, input, AllRecipeTypes.FILLING.getType(), FillingRecipe.class, FillingBySpout.matchItemAndFluid(world, availableFluid, input));
        if (assemblyRecipe.isPresent() && (requiredFluid = ((FillingRecipe)assemblyRecipe.get().value()).getRequiredFluid()).test(availableFluid)) {
            return requiredFluid.getRequiredAmount();
        }
        for (RecipeHolder recipe : world.getRecipeManager().getRecipesFor(AllRecipeTypes.FILLING.getType(), (RecipeInput)input, world)) {
            FillingRecipe fillingRecipe = (FillingRecipe)recipe.value();
            FluidIngredient requiredFluid2 = fillingRecipe.getRequiredFluid();
            if (!requiredFluid2.test(availableFluid)) continue;
            return requiredFluid2.getRequiredAmount();
        }
        return GenericItemFilling.getRequiredAmountForItem(world, stack, availableFluid);
    }

    public static ItemStack fillItem(Level world, int requiredAmount, ItemStack stack, FluidStack availableFluid) {
        FluidStack toFill = availableFluid.copy();
        toFill.setAmount(requiredAmount);
        SingleRecipeInput input = new SingleRecipeInput(stack);
        RecipeHolder fillingRecipe = SequencedAssemblyRecipe.getRecipe(world, input, AllRecipeTypes.FILLING.getType(), FillingRecipe.class, FillingBySpout.matchItemAndFluid(world, availableFluid, input)).filter(fr -> ((FillingRecipe)fr.value()).getRequiredFluid().test(toFill)).orElseGet(() -> {
            for (RecipeHolder recipe : world.getRecipeManager().getRecipesFor(AllRecipeTypes.FILLING.getType(), (RecipeInput)input, world)) {
                FillingRecipe fr = (FillingRecipe)recipe.value();
                FluidIngredient requiredFluid = fr.getRequiredFluid();
                if (!requiredFluid.test(toFill)) continue;
                return new RecipeHolder(recipe.id(), (Recipe)fr);
            }
            return null;
        });
        if (fillingRecipe != null) {
            List<ItemStack> results = ((FillingRecipe)fillingRecipe.value()).rollResults();
            availableFluid.shrink(requiredAmount);
            stack.shrink(1);
            return results.isEmpty() ? ItemStack.EMPTY : results.get(0);
        }
        return GenericItemFilling.fillItem(world, requiredAmount, stack, availableFluid);
    }

    private static Predicate<RecipeHolder<FillingRecipe>> matchItemAndFluid(Level world, FluidStack availableFluid, SingleRecipeInput input) {
        return r -> ((FillingRecipe)r.value()).matches(input, world) && ((FillingRecipe)r.value()).getRequiredFluid().test(availableFluid);
    }
}

