/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block.render;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import org.apache.commons.lang3.mutable.MutableInt;

public class ReducedDestroyEffects
implements IClientBlockExtensions {
    public boolean addDestroyEffects(BlockState state, Level worldIn, BlockPos pos, ParticleEngine manager) {
        if (!(worldIn instanceof ClientLevel)) {
            return true;
        }
        ClientLevel world = (ClientLevel)worldIn;
        VoxelShape voxelshape = state.getShape((BlockGetter)world, pos);
        MutableInt amtBoxes = new MutableInt(0);
        voxelshape.forAllBoxes((x1, y1, z1, x2, y2, z2) -> amtBoxes.increment());
        double chance = 1.0 / (double)amtBoxes.getValue().intValue();
        if (state.isAir()) {
            return true;
        }
        voxelshape.forAllBoxes((x1, y1, z1, x2, y2, z2) -> {
            double w = x2 - x1;
            double h = y2 - y1;
            double l = z2 - z1;
            int xParts = Math.max(2, Mth.ceil((double)(Math.min(1.0, w) * 4.0)));
            int yParts = Math.max(2, Mth.ceil((double)(Math.min(1.0, h) * 4.0)));
            int zParts = Math.max(2, Mth.ceil((double)(Math.min(1.0, l) * 4.0)));
            for (int xIndex = 0; xIndex < xParts; ++xIndex) {
                for (int yIndex = 0; yIndex < yParts; ++yIndex) {
                    for (int zIndex = 0; zIndex < zParts; ++zIndex) {
                        if (world.random.nextDouble() > chance) continue;
                        double d4 = ((double)xIndex + 0.5) / (double)xParts;
                        double d5 = ((double)yIndex + 0.5) / (double)yParts;
                        double d6 = ((double)zIndex + 0.5) / (double)zParts;
                        double x = (double)pos.getX() + d4 * w + x1;
                        double y = (double)pos.getY() + d5 * h + y1;
                        double z = (double)pos.getZ() + d6 * l + z1;
                        manager.add((Particle)new TerrainParticle(world, x, y, z, d4 - 0.5, d5 - 0.5, d6 - 0.5, state, pos).updateSprite(state, pos));
                    }
                }
            }
        });
        return true;
    }
}

