/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.fakes.ServerPlayerInterface;
import carpet.helpers.EntityPlayerActionPack;
import carpet.patches.EntityPlayerMPFake;
import carpet.utils.CommandHelper;
import carpet.utils.Messenger;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.GameModeArgument;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class PlayerCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"player").requires(player -> CommandHelper.canUseCommand(player, CarpetSettings.commandPlayer))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.suggest(PlayerCommand.getPlayerSuggestions((CommandSourceStack)c.getSource()), (SuggestionsBuilder)b)).then(Commands.literal((String)"stop").executes(PlayerCommand.manipulation(EntityPlayerActionPack::stopAll)))).then(PlayerCommand.makeActionCommand("use", EntityPlayerActionPack.ActionType.USE))).then(PlayerCommand.makeActionCommand("jump", EntityPlayerActionPack.ActionType.JUMP))).then(PlayerCommand.makeActionCommand("attack", EntityPlayerActionPack.ActionType.ATTACK))).then(PlayerCommand.makeActionCommand("drop", EntityPlayerActionPack.ActionType.DROP_ITEM))).then(PlayerCommand.makeDropCommand("drop", false))).then(PlayerCommand.makeActionCommand("dropStack", EntityPlayerActionPack.ActionType.DROP_STACK))).then(PlayerCommand.makeDropCommand("dropStack", true))).then(PlayerCommand.makeActionCommand("swapHands", EntityPlayerActionPack.ActionType.SWAP_HANDS))).then(Commands.literal((String)"hotbar").then(Commands.argument((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1, (int)9)).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.setSlot(IntegerArgumentType.getInteger((CommandContext)c, (String)"slot"))))))).then(Commands.literal((String)"kill").executes(PlayerCommand::kill))).then(Commands.literal((String)"shadow").executes(PlayerCommand::shadow))).then(((LiteralArgumentBuilder)Commands.literal((String)"mount").executes(PlayerCommand.manipulation(ap -> ap.mount(true)))).then(Commands.literal((String)"anything").executes(PlayerCommand.manipulation(ap -> ap.mount(false)))))).then(Commands.literal((String)"dismount").executes(PlayerCommand.manipulation(EntityPlayerActionPack::dismount)))).then(Commands.literal((String)"sneak").executes(PlayerCommand.manipulation(ap -> ap.setSneaking(true))))).then(Commands.literal((String)"unsneak").executes(PlayerCommand.manipulation(ap -> ap.setSneaking(false))))).then(Commands.literal((String)"sprint").executes(PlayerCommand.manipulation(ap -> ap.setSprinting(true))))).then(Commands.literal((String)"unsprint").executes(PlayerCommand.manipulation(ap -> ap.setSprinting(false))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"look").then(Commands.literal((String)"north").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.NORTH))))).then(Commands.literal((String)"south").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.SOUTH))))).then(Commands.literal((String)"east").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.EAST))))).then(Commands.literal((String)"west").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.WEST))))).then(Commands.literal((String)"up").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.UP))))).then(Commands.literal((String)"down").executes(PlayerCommand.manipulation(ap -> ap.look(Direction.DOWN))))).then(Commands.literal((String)"at").then(Commands.argument((String)"position", (ArgumentType)Vec3Argument.vec3()).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.lookAt(Vec3Argument.getVec3((CommandContext)c, (String)"position"))))))).then(Commands.argument((String)"direction", (ArgumentType)RotationArgument.rotation()).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.look(RotationArgument.getRotation((CommandContext)c, (String)"direction").getRotation((CommandSourceStack)c.getSource()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"turn").then(Commands.literal((String)"left").executes(PlayerCommand.manipulation(ap -> ap.turn(-90.0f, 0.0f))))).then(Commands.literal((String)"right").executes(PlayerCommand.manipulation(ap -> ap.turn(90.0f, 0.0f))))).then(Commands.literal((String)"back").executes(PlayerCommand.manipulation(ap -> ap.turn(180.0f, 0.0f))))).then(Commands.argument((String)"rotation", (ArgumentType)RotationArgument.rotation()).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.turn(RotationArgument.getRotation((CommandContext)c, (String)"rotation").getRotation((CommandSourceStack)c.getSource()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"move").executes(PlayerCommand.manipulation(EntityPlayerActionPack::stopMovement))).then(Commands.literal((String)"forward").executes(PlayerCommand.manipulation(ap -> ap.setForward(1.0f))))).then(Commands.literal((String)"backward").executes(PlayerCommand.manipulation(ap -> ap.setForward(-1.0f))))).then(Commands.literal((String)"left").executes(PlayerCommand.manipulation(ap -> ap.setStrafing(1.0f))))).then(Commands.literal((String)"right").executes(PlayerCommand.manipulation(ap -> ap.setStrafing(-1.0f)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spawn").executes(PlayerCommand::spawn)).then(((LiteralArgumentBuilder)Commands.literal((String)"in").requires(player -> player.hasPermission(2))).then(Commands.argument((String)"gamemode", (ArgumentType)GameModeArgument.gameMode()).executes(PlayerCommand::spawn)))).then(Commands.literal((String)"at").then(((RequiredArgumentBuilder)Commands.argument((String)"position", (ArgumentType)Vec3Argument.vec3()).executes(PlayerCommand::spawn)).then(Commands.literal((String)"facing").then(((RequiredArgumentBuilder)Commands.argument((String)"direction", (ArgumentType)RotationArgument.rotation()).executes(PlayerCommand::spawn)).then(Commands.literal((String)"in").then(((RequiredArgumentBuilder)Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(PlayerCommand::spawn)).then(((LiteralArgumentBuilder)Commands.literal((String)"in").requires(player -> player.hasPermission(2))).then(Commands.argument((String)"gamemode", (ArgumentType)GameModeArgument.gameMode()).executes(PlayerCommand::spawn)))))))))));
        dispatcher.register(command);
    }

    private static LiteralArgumentBuilder<CommandSourceStack> makeActionCommand(String actionName, EntityPlayerActionPack.ActionType type) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)actionName).executes(PlayerCommand.manipulation(ap -> ap.start(type, EntityPlayerActionPack.Action.once())))).then(Commands.literal((String)"once").executes(PlayerCommand.manipulation(ap -> ap.start(type, EntityPlayerActionPack.Action.once()))))).then(Commands.literal((String)"continuous").executes(PlayerCommand.manipulation(ap -> ap.start(type, EntityPlayerActionPack.Action.continuous()))))).then(Commands.literal((String)"interval").then(Commands.argument((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.start(type, EntityPlayerActionPack.Action.interval(IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks")))))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> makeDropCommand(String actionName, boolean dropAll) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)actionName).then(Commands.literal((String)"all").executes(PlayerCommand.manipulation(ap -> ap.drop(-2, dropAll))))).then(Commands.literal((String)"mainhand").executes(PlayerCommand.manipulation(ap -> ap.drop(-1, dropAll))))).then(Commands.literal((String)"offhand").executes(PlayerCommand.manipulation(ap -> ap.drop(40, dropAll))))).then(Commands.argument((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)0, (int)40)).executes(c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, ap -> ap.drop(IntegerArgumentType.getInteger((CommandContext)c, (String)"slot"), dropAll))));
    }

    private static Collection<String> getPlayerSuggestions(CommandSourceStack source) {
        LinkedHashSet<String> players = new LinkedHashSet<String>(List.of("Steve", "Alex"));
        players.addAll(source.getOnlinePlayerNames());
        return players;
    }

    private static ServerPlayer getPlayer(CommandContext<CommandSourceStack> context) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        return server.getPlayerList().getPlayerByName(playerName);
    }

    private static boolean cantManipulate(CommandContext<CommandSourceStack> context) {
        ServerPlayer player = PlayerCommand.getPlayer(context);
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (player == null) {
            Messenger.m(source, "r Can only manipulate existing players");
            return true;
        }
        ServerPlayer sender = source.getPlayer();
        if (sender == null) {
            return false;
        }
        if (!source.getServer().getPlayerList().isOp(sender.getGameProfile()) && sender != player && !(player instanceof EntityPlayerMPFake)) {
            Messenger.m(source, "r Non OP players can't control other real players");
            return true;
        }
        return false;
    }

    private static boolean cantReMove(CommandContext<CommandSourceStack> context) {
        if (PlayerCommand.cantManipulate(context)) {
            return true;
        }
        ServerPlayer player = PlayerCommand.getPlayer(context);
        if (player instanceof EntityPlayerMPFake) {
            return false;
        }
        Messenger.m((CommandSourceStack)context.getSource(), "r Only fake players can be moved or killed");
        return true;
    }

    private static boolean cantSpawn(CommandContext<CommandSourceStack> context) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        PlayerList manager = server.getPlayerList();
        if (manager.getPlayerByName(playerName) != null) {
            Messenger.m((CommandSourceStack)context.getSource(), "r Player ", "rb " + playerName, "r  is already logged on");
            return true;
        }
        GameProfile profile = server.getProfileCache().get(playerName).orElse(null);
        if (profile == null) {
            if (!CarpetSettings.allowSpawningOfflinePlayers) {
                Messenger.m((CommandSourceStack)context.getSource(), "r Player " + playerName + " is either banned by Mojang, or auth servers are down. Banned players can only be summoned in Singleplayer and in servers in off-line mode.");
                return true;
            }
            profile = new GameProfile(UUIDUtil.createOfflinePlayerUUID((String)playerName), playerName);
        }
        if (manager.getBans().isBanned(profile)) {
            Messenger.m((CommandSourceStack)context.getSource(), "r Player ", "rb " + playerName, "r  is banned on this server");
            return true;
        }
        if (manager.isUsingWhitelist() && manager.isWhiteListed(profile) && !((CommandSourceStack)context.getSource()).hasPermission(2)) {
            Messenger.m((CommandSourceStack)context.getSource(), "r Whitelisted players can only be spawned by operators");
            return true;
        }
        return false;
    }

    private static int kill(CommandContext<CommandSourceStack> context) {
        if (PlayerCommand.cantReMove(context)) {
            return 0;
        }
        PlayerCommand.getPlayer(context).kill();
        return 1;
    }

    private static <T> T getArgOrDefault(SupplierWithCSE<T> getter, T defaultValue) throws CommandSyntaxException {
        try {
            return getter.get();
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    private static int spawn(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (PlayerCommand.cantSpawn(context)) {
            return 0;
        }
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Vec3 pos = PlayerCommand.getArgOrDefault(() -> Vec3Argument.getVec3((CommandContext)context, (String)"position"), source.getPosition());
        Vec2 facing = PlayerCommand.getArgOrDefault(() -> RotationArgument.getRotation((CommandContext)context, (String)"direction").getRotation(source), source.getRotation());
        ResourceKey dimType = PlayerCommand.getArgOrDefault(() -> DimensionArgument.getDimension((CommandContext)context, (String)"dimension").dimension(), source.getLevel().dimension());
        GameType mode = GameType.CREATIVE;
        boolean flying = false;
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer sender = (ServerPlayer)entity;
            mode = sender.gameMode.getGameModeForPlayer();
            flying = sender.getAbilities().flying;
        }
        try {
            mode = GameModeArgument.getGameMode(context, (String)"gamemode");
        }
        catch (IllegalArgumentException sender) {
            // empty catch block
        }
        if (mode == GameType.SPECTATOR) {
            flying = true;
        } else if (mode.isSurvival()) {
            flying = false;
        }
        String playerName = StringArgumentType.getString(context, (String)"player");
        if (playerName.length() > PlayerCommand.maxNameLength(source.getServer())) {
            Messenger.m(source, "rb Player name: " + playerName + " is too long");
            return 0;
        }
        if (!Level.isInSpawnableBounds((BlockPos)BlockPos.containing((Position)pos))) {
            Messenger.m(source, "rb Player " + playerName + " cannot be placed outside of the world");
            return 0;
        }
        boolean success = EntityPlayerMPFake.createFake(playerName, source.getServer(), pos, facing.y, facing.x, (ResourceKey<Level>)dimType, mode, flying);
        if (!success) {
            Messenger.m(source, "rb Player " + playerName + " doesn't exist and cannot spawn in online mode. Turn the server offline or the allowSpawningOfflinePlayers on to spawn non-existing players");
            return 0;
        }
        return 1;
    }

    private static int maxNameLength(MinecraftServer server) {
        return server.getPort() >= 0 ? 16 : 40;
    }

    private static int manipulate(CommandContext<CommandSourceStack> context, Consumer<EntityPlayerActionPack> action) {
        if (PlayerCommand.cantManipulate(context)) {
            return 0;
        }
        ServerPlayer player = PlayerCommand.getPlayer(context);
        action.accept(((ServerPlayerInterface)player).getActionPack());
        return 1;
    }

    private static Command<CommandSourceStack> manipulation(Consumer<EntityPlayerActionPack> action) {
        return c -> PlayerCommand.manipulate((CommandContext<CommandSourceStack>)c, action);
    }

    private static int shadow(CommandContext<CommandSourceStack> context) {
        if (PlayerCommand.cantManipulate(context)) {
            return 0;
        }
        ServerPlayer player = PlayerCommand.getPlayer(context);
        if (player instanceof EntityPlayerMPFake) {
            Messenger.m((CommandSourceStack)context.getSource(), "r Cannot shadow fake players");
            return 0;
        }
        if (player.getServer().isSingleplayerOwner(player.getGameProfile())) {
            Messenger.m((CommandSourceStack)context.getSource(), "r Cannot shadow single-player server owner");
            return 0;
        }
        EntityPlayerMPFake.createShadow(player.server, player);
        return 1;
    }

    @FunctionalInterface
    static interface SupplierWithCSE<T> {
        public T get() throws CommandSyntaxException;
    }
}

