/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.fakes.SpawnGroupInterface;
import carpet.helpers.HopperCounter;
import carpet.utils.CommandHelper;
import carpet.utils.Messenger;
import carpet.utils.SpawnReporter;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class SpawnCommand {
    private static final Map<String, MobCategory> MOB_CATEGORY_MAP = Arrays.stream(SpawnReporter.cachedMobCategories()).collect(Collectors.toMap(MobCategory::getName, Function.identity()));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)Commands.literal((String)"spawn").requires(player -> CommandHelper.canUseCommand(player, CarpetSettings.commandSpawn));
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalargumentbuilder.then(Commands.literal((String)"list").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(c -> SpawnCommand.listSpawns((CommandSourceStack)c.getSource(), BlockPosArgument.getSpawnablePos((CommandContext)c, (String)"pos")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tracking").executes(c -> SpawnCommand.printTrackingReport((CommandSourceStack)c.getSource()))).then(((LiteralArgumentBuilder)Commands.literal((String)"start").executes(c -> SpawnCommand.startTracking((CommandSourceStack)c.getSource(), null))).then(Commands.argument((String)"from", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"to", (ArgumentType)BlockPosArgument.blockPos()).executes(c -> SpawnCommand.startTracking((CommandSourceStack)c.getSource(), BoundingBox.fromCorners((Vec3i)BlockPosArgument.getSpawnablePos((CommandContext)c, (String)"from"), (Vec3i)BlockPosArgument.getSpawnablePos((CommandContext)c, (String)"to")))))))).then(Commands.literal((String)"stop").executes(c -> SpawnCommand.stopTracking((CommandSourceStack)c.getSource())))).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.suggest(Arrays.stream(SpawnReporter.cachedMobCategories()).map(MobCategory::getName), (SuggestionsBuilder)b)).executes(c -> SpawnCommand.recentSpawnsForType((CommandSourceStack)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"type")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"test").executes(c -> SpawnCommand.runTest((CommandSourceStack)c.getSource(), 72000, null))).then(((RequiredArgumentBuilder)Commands.argument((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)10)).executes(c -> SpawnCommand.runTest((CommandSourceStack)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks"), null))).then(Commands.argument((String)"counter", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.suggest(Arrays.stream(DyeColor.values()).map(DyeColor::toString), (SuggestionsBuilder)b)).executes(c -> SpawnCommand.runTest((CommandSourceStack)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks"), StringArgumentType.getString((CommandContext)c, (String)"counter"))))))).then(Commands.literal((String)"mocking").then(Commands.argument((String)"to do or not to do?", (ArgumentType)BoolArgumentType.bool()).executes(c -> SpawnCommand.toggleMocking((CommandSourceStack)c.getSource(), BoolArgumentType.getBool((CommandContext)c, (String)"to do or not to do?")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"rates").executes(c -> SpawnCommand.generalMobcaps((CommandSourceStack)c.getSource()))).then(Commands.literal((String)"reset").executes(c -> SpawnCommand.resetSpawnRates((CommandSourceStack)c.getSource())))).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.suggest(Arrays.stream(SpawnReporter.cachedMobCategories()).map(MobCategory::getName), (SuggestionsBuilder)b)).then(Commands.argument((String)"rounds", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests((c, b) -> SharedSuggestionProvider.suggest((String[])new String[]{"1"}, (SuggestionsBuilder)b)).executes(c -> SpawnCommand.setSpawnRates((CommandSourceStack)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"type"), IntegerArgumentType.getInteger((CommandContext)c, (String)"rounds"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mobcaps").executes(c -> SpawnCommand.generalMobcaps((CommandSourceStack)c.getSource()))).then(Commands.literal((String)"set").then(Commands.argument((String)"cap (hostile)", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1400)).executes(c -> SpawnCommand.setMobcaps((CommandSourceStack)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"cap (hostile)")))))).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).executes(c -> SpawnCommand.mobcapsForDimension((CommandSourceStack)c.getSource(), DimensionArgument.getDimension((CommandContext)c, (String)"dimension")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"entities").executes(c -> SpawnCommand.generalMobcaps((CommandSourceStack)c.getSource()))).then(((RequiredArgumentBuilder)Commands.argument((String)"type", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> SharedSuggestionProvider.suggest(Arrays.stream(SpawnReporter.cachedMobCategories()).map(MobCategory::getName), (SuggestionsBuilder)b)).executes(c -> SpawnCommand.listEntitiesOfType((CommandSourceStack)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"type"), false))).then(Commands.literal((String)"all").executes(c -> SpawnCommand.listEntitiesOfType((CommandSourceStack)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"type"), true)))));
        dispatcher.register(literalargumentbuilder);
    }

    private static MobCategory getCategory(String string) throws CommandSyntaxException {
        if (!Arrays.stream(SpawnReporter.cachedMobCategories()).map(MobCategory::getName).collect(Collectors.toSet()).contains(string)) {
            throw new SimpleCommandExceptionType((Message)Messenger.c("r Wrong mob type: " + string + " should be " + Arrays.stream(SpawnReporter.cachedMobCategories()).map(MobCategory::getName).collect(Collectors.joining(", ")))).create();
        }
        return MOB_CATEGORY_MAP.get(string.toLowerCase(Locale.ROOT));
    }

    private static int listSpawns(CommandSourceStack source, BlockPos pos) {
        Messenger.send(source, SpawnReporter.report(pos, source.getLevel()));
        return 1;
    }

    private static int printTrackingReport(CommandSourceStack source) {
        Messenger.send(source, SpawnReporter.makeTrackingReport((Level)source.getLevel()));
        return 1;
    }

    private static int startTracking(CommandSourceStack source, BoundingBox filter) {
        if (SpawnReporter.trackingSpawns()) {
            Messenger.m(source, "r You are already tracking spawning.");
            return 0;
        }
        SpawnReporter.startTracking(source.getServer(), filter);
        Messenger.m(source, "gi Spawning tracking started.");
        return 1;
    }

    private static int stopTracking(CommandSourceStack source) {
        Messenger.send(source, SpawnReporter.makeTrackingReport((Level)source.getLevel()));
        SpawnReporter.stopTracking(source.getServer());
        Messenger.m(source, "gi Spawning tracking stopped.");
        return 1;
    }

    private static int recentSpawnsForType(CommandSourceStack source, String mob_type) throws CommandSyntaxException {
        MobCategory cat = SpawnCommand.getCategory(mob_type);
        Messenger.send(source, SpawnReporter.getRecentSpawns((Level)source.getLevel(), cat));
        return 1;
    }

    private static int runTest(CommandSourceStack source, int ticks, String counter) {
        SpawnReporter.startTracking(source.getServer(), null);
        if (counter == null) {
            HopperCounter.resetAll(source.getServer(), false);
        } else {
            HopperCounter hCounter = HopperCounter.getCounter(counter);
            if (hCounter != null) {
                hCounter.reset(source.getServer());
            }
        }
        ServerTickRateManager trm = source.getServer().tickRateManager();
        trm.requestGameToSprint(ticks);
        Messenger.m(source, String.format("gi Started spawn test for %d ticks", ticks));
        return 1;
    }

    private static int toggleMocking(CommandSourceStack source, boolean domock) {
        if (domock) {
            SpawnReporter.initializeMocking();
            Messenger.m(source, "gi Mob spawns will now be mocked.");
        } else {
            SpawnReporter.stopMocking();
            Messenger.m(source, "gi Normal mob spawning.");
        }
        return 1;
    }

    private static int generalMobcaps(CommandSourceStack source) {
        Messenger.send(source, SpawnReporter.printMobcapsForDimension(source.getLevel(), true));
        return 1;
    }

    private static int resetSpawnRates(CommandSourceStack source) {
        for (MobCategory s : SpawnReporter.spawn_tries.keySet()) {
            SpawnReporter.spawn_tries.put(s, 1);
        }
        Messenger.m(source, "gi Spawn rates brought to 1 round per tick for all groups.");
        return 1;
    }

    private static int setSpawnRates(CommandSourceStack source, String mobtype, int rounds) throws CommandSyntaxException {
        MobCategory cat = SpawnCommand.getCategory(mobtype);
        SpawnReporter.spawn_tries.put(cat, rounds);
        Messenger.m(source, "gi " + mobtype + " mobs will now spawn " + rounds + " times per tick");
        return 1;
    }

    private static int setMobcaps(CommandSourceStack source, int hostile_cap) {
        double desired_ratio = (double)hostile_cap / (double)((SpawnGroupInterface)MobCategory.MONSTER).getInitialSpawnCap();
        SpawnReporter.mobcap_exponent = 4.0 * Math.log(desired_ratio) / Math.log(2.0);
        Messenger.m(source, String.format("gi Mobcaps for hostile mobs changed to %d, other groups will follow", hostile_cap));
        return 1;
    }

    private static int mobcapsForDimension(CommandSourceStack source, ServerLevel world) {
        Messenger.send(source, SpawnReporter.printMobcapsForDimension(world, true));
        return 1;
    }

    private static int listEntitiesOfType(CommandSourceStack source, String mobtype, boolean all) throws CommandSyntaxException {
        MobCategory cat = SpawnCommand.getCategory(mobtype);
        Messenger.send(source, SpawnReporter.printEntitiesByType(cat, source.getLevel(), all));
        return 1;
    }
}

