/*
 * Decompiled with CFR 0.152.
 */
package carpet.helpers;

import carpet.fakes.ServerPlayerInterface;
import carpet.patches.EntityPlayerMPFake;
import carpet.script.utils.Tracer;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class EntityPlayerActionPack {
    private final ServerPlayer player;
    private final Map<ActionType, Action> actions = new EnumMap<ActionType, Action>(ActionType.class);
    private BlockPos currentBlock;
    private int blockHitDelay;
    private boolean isHittingBlock;
    private float curBlockDamageMP;
    private boolean sneaking;
    private boolean sprinting;
    private float forward;
    private float strafing;
    private int itemUseCooldown;

    public EntityPlayerActionPack(ServerPlayer playerIn) {
        this.player = playerIn;
        this.stopAll();
    }

    public void copyFrom(EntityPlayerActionPack other) {
        this.actions.putAll(other.actions);
        this.currentBlock = other.currentBlock;
        this.blockHitDelay = other.blockHitDelay;
        this.isHittingBlock = other.isHittingBlock;
        this.curBlockDamageMP = other.curBlockDamageMP;
        this.sneaking = other.sneaking;
        this.sprinting = other.sprinting;
        this.forward = other.forward;
        this.strafing = other.strafing;
        this.itemUseCooldown = other.itemUseCooldown;
    }

    public EntityPlayerActionPack start(ActionType type, Action action) {
        Action previous = this.actions.remove((Object)type);
        if (previous != null) {
            type.stop(this.player, previous);
        }
        if (action != null) {
            this.actions.put(type, action);
            type.start(this.player, action);
        }
        return this;
    }

    public EntityPlayerActionPack setSneaking(boolean doSneak) {
        this.sneaking = doSneak;
        this.player.setShiftKeyDown(doSneak);
        if (this.sprinting && this.sneaking) {
            this.setSprinting(false);
        }
        return this;
    }

    public EntityPlayerActionPack setSprinting(boolean doSprint) {
        this.sprinting = doSprint;
        this.player.setSprinting(doSprint);
        if (this.sneaking && this.sprinting) {
            this.setSneaking(false);
        }
        return this;
    }

    public EntityPlayerActionPack setForward(float value) {
        this.forward = value;
        return this;
    }

    public EntityPlayerActionPack setStrafing(float value) {
        this.strafing = value;
        return this;
    }

    public EntityPlayerActionPack look(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> this.look(180.0f, 0.0f);
            case Direction.SOUTH -> this.look(0.0f, 0.0f);
            case Direction.EAST -> this.look(-90.0f, 0.0f);
            case Direction.WEST -> this.look(90.0f, 0.0f);
            case Direction.UP -> this.look(this.player.getYRot(), -90.0f);
            case Direction.DOWN -> this.look(this.player.getYRot(), 90.0f);
        };
    }

    public EntityPlayerActionPack look(Vec2 rotation) {
        return this.look(rotation.x, rotation.y);
    }

    public EntityPlayerActionPack look(float yaw, float pitch) {
        this.player.setYRot(yaw % 360.0f);
        this.player.setXRot(Mth.clamp((float)pitch, (float)-90.0f, (float)90.0f));
        return this;
    }

    public EntityPlayerActionPack lookAt(Vec3 position) {
        this.player.lookAt(EntityAnchorArgument.Anchor.EYES, position);
        return this;
    }

    public EntityPlayerActionPack turn(float yaw, float pitch) {
        return this.look(this.player.getYRot() + yaw, this.player.getXRot() + pitch);
    }

    public EntityPlayerActionPack turn(Vec2 rotation) {
        return this.turn(rotation.x, rotation.y);
    }

    public EntityPlayerActionPack stopMovement() {
        this.setSneaking(false);
        this.setSprinting(false);
        this.forward = 0.0f;
        this.strafing = 0.0f;
        return this;
    }

    public EntityPlayerActionPack stopAll() {
        for (ActionType type : this.actions.keySet()) {
            type.stop(this.player, this.actions.get((Object)type));
        }
        this.actions.clear();
        return this.stopMovement();
    }

    public EntityPlayerActionPack mount(boolean onlyRideables) {
        List entities = onlyRideables ? this.player.level().getEntities((Entity)this.player, this.player.getBoundingBox().inflate(3.0, 1.0, 3.0), e -> e instanceof Minecart || e instanceof Boat || e instanceof AbstractHorse) : this.player.level().getEntities((Entity)this.player, this.player.getBoundingBox().inflate(3.0, 1.0, 3.0));
        if (entities.size() == 0) {
            return this;
        }
        Entity closest = null;
        double distance = Double.POSITIVE_INFINITY;
        Entity currentVehicle = this.player.getVehicle();
        for (Entity e2 : entities) {
            double dd;
            if (e2 == this.player || currentVehicle == e2 || !((dd = this.player.distanceToSqr(e2)) < distance)) continue;
            distance = dd;
            closest = e2;
        }
        if (closest == null) {
            return this;
        }
        if (closest instanceof AbstractHorse && onlyRideables) {
            ((AbstractHorse)closest).mobInteract((Player)this.player, InteractionHand.MAIN_HAND);
        } else {
            this.player.startRiding(closest, true);
        }
        return this;
    }

    public EntityPlayerActionPack dismount() {
        this.player.stopRiding();
        return this;
    }

    public void onUpdate() {
        float vel;
        HashMap<ActionType, Boolean> actionAttempts = new HashMap<ActionType, Boolean>();
        this.actions.values().removeIf(e -> e.done);
        for (Map.Entry<ActionType, Action> e2 : this.actions.entrySet()) {
            Action using;
            Boolean actionStatus;
            ActionType type = e2.getKey();
            Action action = e2.getValue();
            if (!(actionAttempts.getOrDefault((Object)ActionType.USE, false).booleanValue() && type == ActionType.ATTACK || (actionStatus = action.tick(this, type)) == null)) {
                actionAttempts.put(type, actionStatus);
            }
            if (type != ActionType.ATTACK || !actionAttempts.getOrDefault((Object)ActionType.ATTACK, false).booleanValue() || actionAttempts.getOrDefault((Object)ActionType.USE, true).booleanValue() || (using = this.actions.get((Object)ActionType.USE)) == null) continue;
            using.retry(this, ActionType.USE);
        }
        float f = vel = this.sneaking ? 0.3f : 1.0f;
        if (this.forward != 0.0f || this.player instanceof EntityPlayerMPFake) {
            this.player.zza = this.forward * vel;
        }
        if (this.strafing != 0.0f || this.player instanceof EntityPlayerMPFake) {
            this.player.xxa = this.strafing * vel;
        }
    }

    static HitResult getTarget(ServerPlayer player) {
        double reach = player.gameMode.isCreative() ? 5.0 : 4.5;
        return Tracer.rayTrace((Entity)player, 1.0f, reach, false);
    }

    private void dropItemFromSlot(int slot, boolean dropAll) {
        Inventory inv = this.player.getInventory();
        if (!inv.getItem(slot).isEmpty()) {
            this.player.drop(inv.removeItem(slot, dropAll ? inv.getItem(slot).getCount() : 1), false, true);
        }
    }

    public void drop(int selectedSlot, boolean dropAll) {
        Inventory inv = this.player.getInventory();
        if (selectedSlot == -2) {
            for (int i = inv.getContainerSize(); i >= 0; --i) {
                this.dropItemFromSlot(i, dropAll);
            }
        } else {
            if (selectedSlot == -1) {
                selectedSlot = inv.selected;
            }
            this.dropItemFromSlot(selectedSlot, dropAll);
        }
    }

    public void setSlot(int slot) {
        this.player.getInventory().selected = slot - 1;
        this.player.connection.send((Packet)new ClientboundSetCarriedItemPacket(slot - 1));
    }

    public static enum ActionType {
        USE(true){

            @Override
            boolean execute(ServerPlayer player, Action action) {
                EntityPlayerActionPack ap = ((ServerPlayerInterface)player).getActionPack();
                if (ap.itemUseCooldown > 0) {
                    --ap.itemUseCooldown;
                    return true;
                }
                if (player.isUsingItem()) {
                    return true;
                }
                HitResult hit = EntityPlayerActionPack.getTarget(player);
                for (InteractionHand hand : InteractionHand.values()) {
                    switch (hit.getType()) {
                        case BLOCK: {
                            InteractionResult result;
                            player.resetLastActionTime();
                            ServerLevel world = player.serverLevel();
                            BlockHitResult blockHit = (BlockHitResult)hit;
                            BlockPos pos = blockHit.getBlockPos();
                            Direction side = blockHit.getDirection();
                            if (pos.getY() >= player.level().getMaxBuildHeight() - (side == Direction.UP ? 1 : 0) || !world.mayInteract((Player)player, pos) || !(result = player.gameMode.useItemOn(player, (Level)world, player.getItemInHand(hand), hand, blockHit)).consumesAction()) break;
                            if (result.shouldSwing()) {
                                player.swing(hand);
                            }
                            ap.itemUseCooldown = 3;
                            return true;
                        }
                        case ENTITY: {
                            player.resetLastActionTime();
                            EntityHitResult entityHit = (EntityHitResult)hit;
                            Entity entity = entityHit.getEntity();
                            boolean handWasEmpty = player.getItemInHand(hand).isEmpty();
                            boolean itemFrameEmpty = entity instanceof ItemFrame && ((ItemFrame)entity).getItem().isEmpty();
                            Vec3 relativeHitPos = entityHit.getLocation().subtract(entity.getX(), entity.getY(), entity.getZ());
                            if (entity.interactAt((Player)player, relativeHitPos, hand).consumesAction()) {
                                ap.itemUseCooldown = 3;
                                return true;
                            }
                            if (!player.interactOn(entity, hand).consumesAction() || handWasEmpty && itemFrameEmpty) break;
                            ap.itemUseCooldown = 3;
                            return true;
                        }
                    }
                    ItemStack handItem = player.getItemInHand(hand);
                    if (!player.gameMode.useItem(player, player.level(), handItem, hand).consumesAction()) continue;
                    ap.itemUseCooldown = 3;
                    return true;
                }
                return false;
            }

            @Override
            void inactiveTick(ServerPlayer player, Action action) {
                EntityPlayerActionPack ap = ((ServerPlayerInterface)player).getActionPack();
                ap.itemUseCooldown = 0;
                player.releaseUsingItem();
            }
        }
        ,
        ATTACK(true){

            @Override
            boolean execute(ServerPlayer player, Action action) {
                HitResult hit = EntityPlayerActionPack.getTarget(player);
                switch (hit.getType()) {
                    case ENTITY: {
                        EntityHitResult entityHit = (EntityHitResult)hit;
                        if (!action.isContinuous) {
                            player.attack(entityHit.getEntity());
                            player.swing(InteractionHand.MAIN_HAND);
                        }
                        player.resetAttackStrengthTicker();
                        player.resetLastActionTime();
                        return true;
                    }
                    case BLOCK: {
                        EntityPlayerActionPack ap = ((ServerPlayerInterface)player).getActionPack();
                        if (ap.blockHitDelay > 0) {
                            --ap.blockHitDelay;
                            return false;
                        }
                        BlockHitResult blockHit = (BlockHitResult)hit;
                        BlockPos pos = blockHit.getBlockPos();
                        Direction side = blockHit.getDirection();
                        if (player.blockActionRestricted(player.level(), pos, player.gameMode.getGameModeForPlayer())) {
                            return false;
                        }
                        if (ap.currentBlock != null && player.level().getBlockState(ap.currentBlock).isAir()) {
                            ap.currentBlock = null;
                            return false;
                        }
                        BlockState state = player.level().getBlockState(pos);
                        boolean blockBroken = false;
                        if (player.gameMode.getGameModeForPlayer().isCreative()) {
                            player.gameMode.handleBlockBreakAction(pos, ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, side, player.level().getMaxBuildHeight(), -1);
                            ap.blockHitDelay = 5;
                            blockBroken = true;
                        } else if (ap.currentBlock == null || !ap.currentBlock.equals((Object)pos)) {
                            boolean notAir;
                            if (ap.currentBlock != null) {
                                player.gameMode.handleBlockBreakAction(ap.currentBlock, ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, side, player.level().getMaxBuildHeight(), -1);
                            }
                            player.gameMode.handleBlockBreakAction(pos, ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, side, player.level().getMaxBuildHeight(), -1);
                            boolean bl = notAir = !state.isAir();
                            if (notAir && ap.curBlockDamageMP == 0.0f) {
                                state.attack(player.level(), pos, (Player)player);
                            }
                            if (notAir && state.getDestroyProgress((Player)player, (BlockGetter)player.level(), pos) >= 1.0f) {
                                ap.currentBlock = null;
                                blockBroken = true;
                            } else {
                                ap.currentBlock = pos;
                                ap.curBlockDamageMP = 0.0f;
                            }
                        } else {
                            ap.curBlockDamageMP += state.getDestroyProgress((Player)player, (BlockGetter)player.level(), pos);
                            if (ap.curBlockDamageMP >= 1.0f) {
                                player.gameMode.handleBlockBreakAction(pos, ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, side, player.level().getMaxBuildHeight(), -1);
                                ap.currentBlock = null;
                                ap.blockHitDelay = 5;
                                blockBroken = true;
                            }
                            player.level().destroyBlockProgress(-1, pos, (int)(ap.curBlockDamageMP * 10.0f));
                        }
                        player.resetLastActionTime();
                        player.swing(InteractionHand.MAIN_HAND);
                        return blockBroken;
                    }
                }
                return false;
            }

            @Override
            void inactiveTick(ServerPlayer player, Action action) {
                EntityPlayerActionPack ap = ((ServerPlayerInterface)player).getActionPack();
                if (ap.currentBlock == null) {
                    return;
                }
                player.level().destroyBlockProgress(-1, ap.currentBlock, -1);
                player.gameMode.handleBlockBreakAction(ap.currentBlock, ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, Direction.DOWN, player.level().getMaxBuildHeight(), -1);
                ap.currentBlock = null;
            }
        }
        ,
        JUMP(true){

            @Override
            boolean execute(ServerPlayer player, Action action) {
                if (action.limit == 1) {
                    if (player.onGround()) {
                        player.jumpFromGround();
                    }
                } else {
                    player.setJumping(true);
                }
                return false;
            }

            @Override
            void inactiveTick(ServerPlayer player, Action action) {
                player.setJumping(false);
            }
        }
        ,
        DROP_ITEM(true){

            @Override
            boolean execute(ServerPlayer player, Action action) {
                player.resetLastActionTime();
                player.drop(false);
                return false;
            }
        }
        ,
        DROP_STACK(true){

            @Override
            boolean execute(ServerPlayer player, Action action) {
                player.resetLastActionTime();
                player.drop(true);
                return false;
            }
        }
        ,
        SWAP_HANDS(true){

            @Override
            boolean execute(ServerPlayer player, Action action) {
                player.resetLastActionTime();
                ItemStack itemStack_1 = player.getItemInHand(InteractionHand.OFF_HAND);
                player.setItemInHand(InteractionHand.OFF_HAND, player.getItemInHand(InteractionHand.MAIN_HAND));
                player.setItemInHand(InteractionHand.MAIN_HAND, itemStack_1);
                return false;
            }
        };

        public final boolean preventSpectator;

        private ActionType(boolean preventSpectator) {
            this.preventSpectator = preventSpectator;
        }

        void start(ServerPlayer player, Action action) {
        }

        abstract boolean execute(ServerPlayer var1, Action var2);

        void inactiveTick(ServerPlayer player, Action action) {
        }

        void stop(ServerPlayer player, Action action) {
            this.inactiveTick(player, action);
        }
    }

    public static class Action {
        public boolean done = false;
        public final int limit;
        public final int interval;
        public final int offset;
        private int count;
        private int next;
        private final boolean isContinuous;

        private Action(int limit, int interval, int offset, boolean continuous) {
            this.limit = limit;
            this.interval = interval;
            this.offset = offset;
            this.next = interval + offset;
            this.isContinuous = continuous;
        }

        public static Action once() {
            return new Action(1, 1, 0, false);
        }

        public static Action continuous() {
            return new Action(-1, 1, 0, true);
        }

        public static Action interval(int interval) {
            return new Action(-1, interval, 0, false);
        }

        public static Action interval(int interval, int offset) {
            return new Action(-1, interval, offset, false);
        }

        Boolean tick(EntityPlayerActionPack actionPack, ActionType type) {
            --this.next;
            Boolean cancel = null;
            if (this.next <= 0) {
                if (!(this.interval != 1 || this.isContinuous || type.preventSpectator && actionPack.player.isSpectator())) {
                    type.inactiveTick(actionPack.player, this);
                }
                if (!type.preventSpectator || !actionPack.player.isSpectator()) {
                    cancel = type.execute(actionPack.player, this);
                }
                ++this.count;
                if (this.count == this.limit) {
                    type.stop(actionPack.player, null);
                    this.done = true;
                    return cancel;
                }
                this.next = this.interval;
            } else if (!type.preventSpectator || !actionPack.player.isSpectator()) {
                type.inactiveTick(actionPack.player, this);
            }
            return cancel;
        }

        void retry(EntityPlayerActionPack actionPack, ActionType type) {
            if (!type.preventSpectator || !actionPack.player.isSpectator()) {
                type.execute(actionPack.player, this);
            }
            ++this.count;
            if (this.count == this.limit) {
                type.stop(actionPack.player, null);
                this.done = true;
            }
        }
    }
}

