/*
 * Decompiled with CFR 0.152.
 */
package carpet.helpers;

import carpet.CarpetSettings;
import carpet.logging.logHelpers.ExplosionLogHelper;
import carpet.mixins.ExplosionAccessor;
import carpet.script.CarpetEventServer;
import carpet.utils.Messenger;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class OptimizedExplosion {
    private static List<Entity> entitylist;
    private static Vec3 vec3dmem;
    private static long tickmem;
    public static int explosionSound;
    private static Object2DoubleOpenHashMap<Pair<Vec3, AABB>> densityCache;
    private static MutablePair<Vec3, AABB> pairMutable;
    private static Object2ObjectOpenHashMap<BlockPos, BlockState> stateCache;
    private static Object2ObjectOpenHashMap<BlockPos, FluidState> fluidCache;
    private static BlockPos.MutableBlockPos posMutable;
    private static ObjectOpenHashSet<BlockPos> affectedBlockPositionsSet;
    private static boolean firstRay;
    private static boolean rayCalcDone;
    private static ArrayList<Float> chances;
    private static BlockPos blastChanceLocation;
    private static List<Entity> entityList;

    public static void doExplosionA(Explosion e, ExplosionLogHelper eLogger) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        entityList.clear();
        boolean eventNeeded = CarpetEventServer.Event.EXPLOSION_OUTCOME.isNeeded() && !eAccess.carpet$getLevel().isClientSide();
        OptimizedExplosion.blastCalc(e);
        if (!CarpetSettings.explosionNoBlockDamage && eAccess.carpet$getDamageSource() != null) {
            rayCalcDone = false;
            firstRay = true;
            OptimizedExplosion.getAffectedPositionsOnPlaneY(e, 0, 0, 15, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneY(e, 15, 0, 15, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneX(e, 0, 1, 14, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneX(e, 15, 1, 14, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneZ(e, 0, 1, 14, 1, 14);
            OptimizedExplosion.getAffectedPositionsOnPlaneZ(e, 15, 1, 14, 1, 14);
            stateCache.clear();
            fluidCache.clear();
            e.getToBlow().addAll(affectedBlockPositionsSet);
            affectedBlockPositionsSet.clear();
        }
        float f3 = eAccess.carpet$getRadius() * 2.0f;
        int k1 = Mth.floor((double)(eAccess.carpet$getX() - (double)f3 - 1.0));
        int l1 = Mth.floor((double)(eAccess.carpet$getX() + (double)f3 + 1.0));
        int i2 = Mth.floor((double)(eAccess.carpet$getY() - (double)f3 - 1.0));
        int i1 = Mth.floor((double)(eAccess.carpet$getY() + (double)f3 + 1.0));
        int j2 = Mth.floor((double)(eAccess.carpet$getZ() - (double)f3 - 1.0));
        int j1 = Mth.floor((double)(eAccess.carpet$getZ() + (double)f3 + 1.0));
        Vec3 vec3d = new Vec3(eAccess.carpet$getX(), eAccess.carpet$getY(), eAccess.carpet$getZ());
        if (vec3dmem == null || !vec3dmem.equals((Object)vec3d) || tickmem != eAccess.carpet$getLevel().getGameTime()) {
            vec3dmem = vec3d;
            tickmem = eAccess.carpet$getLevel().getGameTime();
            entitylist = eAccess.carpet$getLevel().getEntities(null, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
            explosionSound = 0;
        }
        ++explosionSound;
        Entity explodingEntity = eAccess.carpet$getSource();
        for (int k2 = 0; k2 < entitylist.size(); ++k2) {
            Player player;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = entitylist.get(k2);
            if (entity == explodingEntity) {
                OptimizedExplosion.removeFast(entitylist, k2);
                --k2;
                continue;
            }
            if (entity instanceof PrimedTnt && explodingEntity != null && entity.getX() == explodingEntity.getX() && entity.getY() == explodingEntity.getY() && entity.getZ() == explodingEntity.getZ()) {
                if (eLogger == null) continue;
                eLogger.onEntityImpacted(entity, new Vec3(0.0, -0.9923437498509884, 0.0));
                continue;
            }
            if (entity.ignoreExplosion(e) || !((d12 = Math.sqrt(entity.distanceToSqr(eAccess.carpet$getX(), eAccess.carpet$getY(), eAccess.carpet$getZ())) / (double)f3) <= 1.0) || (d13 = Math.sqrt((d5 = entity.getX() - eAccess.carpet$getX()) * d5 + (d7 = (entity instanceof PrimedTnt ? entity.getY() : entity.getEyeY()) - eAccess.carpet$getY()) * d7 + (d9 = entity.getZ() - eAccess.carpet$getZ()) * d9)) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            pairMutable.setLeft((Object)vec3d);
            pairMutable.setRight((Object)entity.getBoundingBox());
            double density = densityCache.getOrDefault(pairMutable, Double.MAX_VALUE);
            if (density == Double.MAX_VALUE) {
                Pair pair = Pair.of((Object)vec3d, (Object)entity.getBoundingBox());
                density = Explosion.getSeenPercent((Vec3)vec3d, (Entity)entity);
                densityCache.put((Object)pair, density);
            }
            if (eventNeeded) {
                entityList.add(entity);
            }
            double d10 = (1.0 - d12) * density;
            if (eAccess.carpet$getDamageSource() != null) {
                entity.hurt(eAccess.carpet$getDamageSource(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0)));
            }
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                LivingEntity lev = (LivingEntity)entity;
                d11 = d10 * Mth.clamp((double)(1.0 - lev.getAttributeValue(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE)), (double)0.0, (double)1.0);
            }
            if (eLogger != null) {
                eLogger.onEntityImpacted(entity, new Vec3(d5 * d11, d7 * d11, d9 * d11));
            }
            entity.setDeltaMovement(entity.getDeltaMovement().add(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof Player) || (player = (Player)entity).isSpectator() || player.isCreative() && player.getAbilities().flying) continue;
            e.getHitPlayers().put(player, new Vec3(d5 * d10, d7 * d10, d9 * d10));
        }
        densityCache.clear();
    }

    public static void doExplosionB(Explosion e, boolean spawnParticles) {
        boolean damagesTerrain;
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        Level world = eAccess.carpet$getLevel();
        double posX = eAccess.carpet$getX();
        double posY = eAccess.carpet$getY();
        double posZ = eAccess.carpet$getZ();
        if (CarpetEventServer.Event.EXPLOSION_OUTCOME.isNeeded() && !world.isClientSide()) {
            CarpetEventServer.Event.EXPLOSION_OUTCOME.onExplosion((ServerLevel)world, eAccess.carpet$getSource(), () -> ((Explosion)e).getIndirectSourceEntity(), eAccess.carpet$getX(), eAccess.carpet$getY(), eAccess.carpet$getZ(), eAccess.carpet$getRadius(), eAccess.carpet$isFire(), e.getToBlow(), entityList, eAccess.carpet$getBlockInteraction());
        }
        boolean bl = damagesTerrain = eAccess.carpet$getBlockInteraction() != Explosion.BlockInteraction.KEEP;
        if (explosionSound < 100 || explosionSound % 100 == 0) {
            world.playSound(null, posX, posY, posZ, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), SoundSource.BLOCKS, 4.0f, (1.0f + (world.random.nextFloat() - world.random.nextFloat()) * 0.2f) * 0.7f);
            if (spawnParticles) {
                if (eAccess.carpet$getRadius() >= 2.0f && damagesTerrain) {
                    world.addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, posX, posY, posZ, 1.0, 0.0, 0.0);
                } else {
                    world.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, posX, posY, posZ, 1.0, 0.0, 0.0);
                }
            }
        }
        if (damagesTerrain) {
            ObjectArrayList objectArrayList = new ObjectArrayList();
            Util.shuffle((List)((ObjectArrayList)e.getToBlow()), (RandomSource)world.random);
            boolean dropFromExplosions = CarpetSettings.xpFromExplosions || e.getIndirectSourceEntity() instanceof Player;
            for (BlockPos blockpos : e.getToBlow()) {
                BlockState state = world.getBlockState(blockpos);
                Block block = state.getBlock();
                if (state.isAir()) continue;
                if (block.dropFromExplosion(e) && world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    BlockEntity blockEntity = state.hasBlockEntity() ? world.getBlockEntity(blockpos) : null;
                    LootParams.Builder lootBuilder = new LootParams.Builder((ServerLevel)eAccess.carpet$getLevel()).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)blockpos)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)blockEntity).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)eAccess.carpet$getSource());
                    if (eAccess.carpet$getBlockInteraction() == Explosion.BlockInteraction.DESTROY_WITH_DECAY) {
                        lootBuilder.withParameter(LootContextParams.EXPLOSION_RADIUS, (Object)Float.valueOf(eAccess.carpet$getRadius()));
                    }
                    state.spawnAfterBreak(serverLevel, blockpos, ItemStack.EMPTY, dropFromExplosions);
                    state.getDrops(lootBuilder).forEach(itemStackx -> OptimizedExplosion.method_24023((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectArrayList, itemStackx, blockpos.immutable()));
                }
                world.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 3);
                block.wasExploded(world, blockpos, e);
            }
            objectArrayList.forEach(p -> Block.popResource((Level)world, (BlockPos)((BlockPos)p.getRight()), (ItemStack)((ItemStack)p.getLeft())));
        }
        if (eAccess.carpet$isFire()) {
            for (BlockPos blockpos1 : e.getToBlow()) {
                LevelChunk chunk = world.getChunk(blockpos1.getX() >> 4, blockpos1.getZ() >> 4);
                BlockPos down = blockpos1.below(1);
                if (eAccess.carpet$getRandom().nextInt(3) != 0 || !chunk.getBlockState(blockpos1).isAir() || !chunk.getBlockState(down).isSolidRender((BlockGetter)world, down)) continue;
                world.setBlockAndUpdate(blockpos1, Blocks.FIRE.defaultBlockState());
            }
        }
    }

    private static void method_24023(ObjectArrayList<Pair<ItemStack, BlockPos>> objectArrayList, ItemStack itemStack, BlockPos blockPos) {
        int i = objectArrayList.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)objectArrayList.get(j);
            ItemStack itemStack2 = (ItemStack)pair.getLeft();
            if (!ItemEntity.areMergable((ItemStack)itemStack2, (ItemStack)itemStack)) continue;
            ItemStack itemStack3 = ItemEntity.merge((ItemStack)itemStack2, (ItemStack)itemStack, (int)16);
            objectArrayList.set(j, (Object)Pair.of((Object)itemStack3, (Object)((BlockPos)pair.getRight())));
            if (!itemStack.isEmpty()) continue;
            return;
        }
        objectArrayList.add((Object)Pair.of((Object)itemStack, (Object)blockPos));
    }

    private static void removeFast(List<Entity> lst, int index) {
        if (index < lst.size() - 1) {
            lst.set(index, lst.get(lst.size() - 1));
        }
        lst.remove(lst.size() - 1);
    }

    private static void rayCalcs(Explosion e) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        boolean first = true;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    float rand = eAccess.carpet$getLevel().random.nextFloat();
                    if (CarpetSettings.tntRandomRange >= 0.0) {
                        rand = (float)CarpetSettings.tntRandomRange;
                    }
                    double d4 = eAccess.carpet$getX();
                    double d6 = eAccess.carpet$getY();
                    double d8 = eAccess.carpet$getZ();
                    float f1 = 0.3f;
                    for (float f = eAccess.carpet$getRadius() * (0.7f + rand * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = BlockPos.containing((double)d4, (double)d6, (double)d8);
                        BlockState state = eAccess.carpet$getLevel().getBlockState(blockpos);
                        FluidState fluidState = eAccess.carpet$getLevel().getFluidState(blockpos);
                        if (!state.isAir()) {
                            float f2 = Math.max(state.getBlock().getExplosionResistance(), fluidState.getExplosionResistance());
                            if (eAccess.carpet$getSource() != null) {
                                f2 = eAccess.carpet$getSource().getBlockExplosionResistance(e, (BlockGetter)eAccess.carpet$getLevel(), blockpos, state, fluidState, f2);
                            }
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (eAccess.carpet$getSource() == null || eAccess.carpet$getSource().shouldBlockExplode(e, (BlockGetter)eAccess.carpet$getLevel(), blockpos, state, f))) {
                            affectedBlockPositionsSet.add((Object)blockpos);
                        } else if (first) {
                            return;
                        }
                        first = false;
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
    }

    private static void getAffectedPositionsOnPlaneX(Explosion e, int x, int yStart, int yEnd, int zStart, int zEnd) {
        if (!rayCalcDone) {
            double xRel = (double)x / 15.0 * 2.0 - 1.0;
            for (int z = zStart; z <= zEnd; ++z) {
                double zRel = (double)z / 15.0 * 2.0 - 1.0;
                for (int y = yStart; y <= yEnd; ++y) {
                    double yRel = (double)y / 15.0 * 2.0 - 1.0;
                    if (!OptimizedExplosion.checkAffectedPosition(e, xRel, yRel, zRel)) continue;
                    return;
                }
            }
        }
    }

    private static void getAffectedPositionsOnPlaneY(Explosion e, int y, int xStart, int xEnd, int zStart, int zEnd) {
        if (!rayCalcDone) {
            double yRel = (double)y / 15.0 * 2.0 - 1.0;
            for (int z = zStart; z <= zEnd; ++z) {
                double zRel = (double)z / 15.0 * 2.0 - 1.0;
                for (int x = xStart; x <= xEnd; ++x) {
                    double xRel = (double)x / 15.0 * 2.0 - 1.0;
                    if (!OptimizedExplosion.checkAffectedPosition(e, xRel, yRel, zRel)) continue;
                    return;
                }
            }
        }
    }

    private static void getAffectedPositionsOnPlaneZ(Explosion e, int z, int xStart, int xEnd, int yStart, int yEnd) {
        if (!rayCalcDone) {
            double zRel = (double)z / 15.0 * 2.0 - 1.0;
            for (int x = xStart; x <= xEnd; ++x) {
                double xRel = (double)x / 15.0 * 2.0 - 1.0;
                for (int y = yStart; y <= yEnd; ++y) {
                    double yRel = (double)y / 15.0 * 2.0 - 1.0;
                    if (!OptimizedExplosion.checkAffectedPosition(e, xRel, yRel, zRel)) continue;
                    return;
                }
            }
        }
    }

    private static boolean checkAffectedPosition(Explosion e, double xRel, double yRel, double zRel) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        double len = Math.sqrt(xRel * xRel + yRel * yRel + zRel * zRel);
        double xInc = xRel / len * 0.3;
        double yInc = yRel / len * 0.3;
        double zInc = zRel / len * 0.3;
        float rand = eAccess.carpet$getLevel().random.nextFloat();
        float sizeRand = CarpetSettings.tntRandomRange >= 0.0 ? (float)CarpetSettings.tntRandomRange : rand;
        double posX = eAccess.carpet$getX();
        double posY = eAccess.carpet$getY();
        double posZ = eAccess.carpet$getZ();
        float f1 = 0.3f;
        for (float size = eAccess.carpet$getRadius() * (0.7f + sizeRand * 0.6f); size > 0.0f; size -= 0.22500001f) {
            posMutable.set(posX, posY, posZ);
            BlockState state = (BlockState)stateCache.get((Object)posMutable);
            FluidState fluid = (FluidState)fluidCache.get((Object)posMutable);
            BlockPos posImmutable = null;
            if (state == null) {
                posImmutable = posMutable.immutable();
                state = eAccess.carpet$getLevel().getBlockState(posImmutable);
                stateCache.put((Object)posImmutable, (Object)state);
                fluid = eAccess.carpet$getLevel().getFluidState(posImmutable);
                fluidCache.put((Object)posImmutable, (Object)fluid);
            }
            if (!state.isAir()) {
                float resistance = Math.max(state.getBlock().getExplosionResistance(), fluid.getExplosionResistance());
                if (eAccess.carpet$getSource() != null) {
                    resistance = eAccess.carpet$getSource().getBlockExplosionResistance(e, (BlockGetter)eAccess.carpet$getLevel(), (BlockPos)posMutable, state, fluid, resistance);
                }
                size -= (resistance + 0.3f) * 0.3f;
            }
            if (size > 0.0f) {
                if (eAccess.carpet$getSource() == null || eAccess.carpet$getSource().shouldBlockExplode(e, (BlockGetter)eAccess.carpet$getLevel(), (BlockPos)posMutable, state, size)) {
                    affectedBlockPositionsSet.add((Object)(posImmutable != null ? posImmutable : posMutable.immutable()));
                }
            } else if (firstRay) {
                rayCalcDone = true;
                return true;
            }
            firstRay = false;
            posX += xInc;
            posY += yInc;
            posZ += zInc;
        }
        return false;
    }

    public static void setBlastChanceLocation(BlockPos p) {
        blastChanceLocation = p;
    }

    private static void blastCalc(Explosion e) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        if (blastChanceLocation == null || blastChanceLocation.distToLowCornerSqr(eAccess.carpet$getX(), eAccess.carpet$getY(), eAccess.carpet$getZ()) > 200.0) {
            return;
        }
        chances.clear();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = eAccess.carpet$getX();
                    double d6 = eAccess.carpet$getY();
                    double d8 = eAccess.carpet$getZ();
                    boolean found = false;
                    float f1 = 0.3f;
                    for (float f = eAccess.carpet$getRadius() * 1.3f; f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = BlockPos.containing((double)d4, (double)d6, (double)d8);
                        BlockState state = eAccess.carpet$getLevel().getBlockState(blockpos);
                        FluidState fluidState = eAccess.carpet$getLevel().getFluidState(blockpos);
                        if (!state.isAir()) {
                            float f2 = Math.max(state.getBlock().getExplosionResistance(), fluidState.getExplosionResistance());
                            if (eAccess.carpet$getSource() != null) {
                                f2 = eAccess.carpet$getSource().getBlockExplosionResistance(e, (BlockGetter)eAccess.carpet$getLevel(), blockpos, state, fluidState, f2);
                            }
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (eAccess.carpet$getSource() == null || eAccess.carpet$getSource().shouldBlockExplode(e, (BlockGetter)eAccess.carpet$getLevel(), blockpos, state, f)) && !found && blockpos.equals((Object)blastChanceLocation)) {
                            chances.add(Float.valueOf(f));
                            found = true;
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
    }

    private static void showTNTblastChance(Explosion e) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        double randMax = 0.6f * eAccess.carpet$getRadius();
        double total = 0.0;
        boolean fullyBlownUp = false;
        boolean first = true;
        int rays = 0;
        for (float f3 : chances) {
            ++rays;
            double calc = (double)f3 - randMax;
            if (calc > 0.0) {
                fullyBlownUp = true;
            }
            double chancePerRay = Math.abs(calc) / randMax;
            if (fullyBlownUp) continue;
            if (first) {
                first = false;
                total = chancePerRay;
                continue;
            }
            total *= chancePerRay;
        }
        if (fullyBlownUp) {
            total = 0.0;
        }
        double chance = 1.0 - total;
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setRoundingMode(RoundingMode.DOWN);
        nf.setMaximumFractionDigits(2);
        for (Player player : eAccess.carpet$getLevel().players()) {
            Messenger.m(player, "w Pop: ", "c " + nf.format(chance) + " ", "^w Chance for the block to be destroyed by the blast: " + chance, "?" + chance, "w Remain: ", String.format("c %.2f ", total), "^w Chance the block survives the blast: " + total, "?" + total, "w Rays: ", String.format("c %d ", rays), "^w TNT blast rays going through the block", "?" + rays, "w Size: ", String.format("c %.1f ", Float.valueOf(eAccess.carpet$getRadius())), "^w TNT blast size", "?" + eAccess.carpet$getRadius(), "w @: ", String.format("c [%.1f %.1f %.1f] ", eAccess.carpet$getX(), eAccess.carpet$getY(), eAccess.carpet$getZ()), "^w TNT blast location X:" + eAccess.carpet$getX() + " Y:" + eAccess.carpet$getY() + " Z:" + eAccess.carpet$getZ(), "?" + eAccess.carpet$getX() + " " + eAccess.carpet$getY() + " " + eAccess.carpet$getZ());
        }
    }

    static {
        explosionSound = 0;
        densityCache = new Object2DoubleOpenHashMap();
        pairMutable = new MutablePair();
        stateCache = new Object2ObjectOpenHashMap();
        fluidCache = new Object2ObjectOpenHashMap();
        posMutable = new BlockPos.MutableBlockPos(0, 0, 0);
        affectedBlockPositionsSet = new ObjectOpenHashSet();
        chances = new ArrayList();
        entityList = new ArrayList<Entity>();
    }
}

