/*
 * Decompiled with CFR 0.152.
 */
package carpet.helpers;

import carpet.script.utils.ParticleParser;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class ParticleDisplay {
    public static void drawParticleLine(ServerPlayer player, Vec3 from, Vec3 to, String main, String accent, int count, double spread) {
        double lineLengthSq;
        ParticleOptions accentParticle = ParticleParser.getEffect(accent, (RegistryAccess)player.server.registryAccess());
        ParticleOptions mainParticle = ParticleParser.getEffect(main, (RegistryAccess)player.server.registryAccess());
        if (accentParticle != null) {
            player.serverLevel().sendParticles(player, accentParticle, true, to.x, to.y, to.z, count, spread, spread, spread, 0.0);
        }
        if ((lineLengthSq = from.distanceToSqr(to)) == 0.0) {
            return;
        }
        Vec3 incvec = to.subtract(from).normalize();
        Vec3 delta = new Vec3(0.0, 0.0, 0.0);
        while (delta.lengthSqr() < lineLengthSq) {
            player.serverLevel().sendParticles(player, mainParticle, true, delta.x + from.x, delta.y + from.y, delta.z + from.z, 1, 0.0, 0.0, 0.0, 0.0);
            delta = delta.add(incvec.scale((double)player.level().random.nextFloat()));
        }
    }
}

