/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.CarpetSettings;
import carpet.fakes.LevelInterface;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntity_maxCollisionsMixin
extends Entity {
    public LivingEntity_maxCollisionsMixin(EntityType<?> entityType_1, Level world_1) {
        super(entityType_1, world_1);
    }

    @Shadow
    protected abstract void doPush(Entity var1);

    @Inject(method={"pushEntities"}, cancellable=true, at={@At(value="HEAD")})
    private void tickPushingReplacement(CallbackInfo ci) {
        List<Entity> entities;
        if (CarpetSettings.maxEntityCollisions == 0) {
            return;
        }
        int maxEntityCramming = -1;
        if (CarpetSettings.maxEntityCollisions > 0) {
            maxEntityCramming = this.level().getGameRules().getInt(GameRules.RULE_MAX_ENTITY_CRAMMING);
            entities = ((LevelInterface)this.level()).getOtherEntitiesLimited(this, this.getBoundingBox(), EntitySelector.pushableBy((Entity)this), Math.max(CarpetSettings.maxEntityCollisions, maxEntityCramming));
        } else {
            entities = this.level().getEntities((Entity)this, this.getBoundingBox(), EntitySelector.pushableBy((Entity)this));
        }
        if (!entities.isEmpty()) {
            if (maxEntityCramming < 0) {
                maxEntityCramming = this.level().getGameRules().getInt(GameRules.RULE_MAX_ENTITY_CRAMMING);
            }
            if (maxEntityCramming > 0 && entities.size() > maxEntityCramming - 1 && this.random.nextInt(4) == 0) {
                int candidates = 0;
                for (Entity entity : entities) {
                    if (entity.isPassenger()) continue;
                    ++candidates;
                }
                if (candidates > maxEntityCramming - 1) {
                    this.hurt(this.damageSources().cramming(), 6.0f);
                }
            }
            if (CarpetSettings.maxEntityCollisions > 0 && entities.size() > CarpetSettings.maxEntityCollisions) {
                for (Entity entity : entities.subList(0, CarpetSettings.maxEntityCollisions)) {
                    this.doPush(entity);
                }
            } else {
                for (Entity entity : entities) {
                    this.doPush(entity);
                }
            }
        }
        ci.cancel();
    }
}

