/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.utils.SpawnReporter;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.HashSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerChunkCache.class})
public abstract class ServerChunkCacheMixin {
    @Shadow
    @Final
    private ServerLevel level;
    @Shadow
    @Final
    private DistanceManager distanceManager;

    @Redirect(method={"tickChunks"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager;getNaturalSpawnChunkCount()I"))
    private int setupTracking(DistanceManager chunkTicketManager) {
        int j = chunkTicketManager.getNaturalSpawnChunkCount();
        ResourceKey dim = this.level.dimension();
        SpawnReporter.chunkCounts.put((ResourceKey<Level>)dim, j);
        if (SpawnReporter.trackingSpawns()) {
            SpawnReporter.local_spawns = new Object2LongOpenHashMap();
            SpawnReporter.first_chunk_marker = new HashSet();
            for (MobCategory cat : SpawnReporter.cachedMobCategories()) {
                Pair key = Pair.of((Object)dim, (Object)cat);
                SpawnReporter.overall_spawn_ticks.addTo((Object)key, (long)SpawnReporter.spawn_tries.get(cat).intValue());
            }
        }
        return j;
    }

    @Inject(method={"tickChunks"}, at={@At(value="RETURN")})
    private void onFinishSpawnWorldCycle(CallbackInfo ci) {
        boolean boolean_3;
        LevelData levelData = this.level.getLevelData();
        boolean bl = boolean_3 = levelData.getGameTime() % 400L == 0L;
        if (SpawnReporter.trackingSpawns() && SpawnReporter.local_spawns != null) {
            for (MobCategory cat : SpawnReporter.cachedMobCategories()) {
                ResourceKey dim = this.level.dimension();
                Pair key = Pair.of((Object)dim, (Object)cat);
                int spawnTries = SpawnReporter.spawn_tries.get(cat);
                if (!SpawnReporter.local_spawns.containsKey((Object)cat)) {
                    if (cat.isPersistent() && !boolean_3) continue;
                    SpawnReporter.spawn_ticks_full.addTo((Object)key, (long)spawnTries);
                    continue;
                }
                if (SpawnReporter.local_spawns.getLong((Object)cat) > 0L) {
                    SpawnReporter.spawn_ticks_succ.addTo((Object)key, (long)spawnTries);
                    SpawnReporter.spawn_ticks_spawns.addTo((Object)key, SpawnReporter.local_spawns.getLong((Object)cat));
                    continue;
                }
                SpawnReporter.spawn_ticks_fail.addTo((Object)key, (long)spawnTries);
            }
        }
        SpawnReporter.local_spawns = null;
    }
}

