/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.Lighting_scarpetChunkCreationInterface;
import carpet.fakes.ServerLightingProviderInterface;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntSupplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Invoker;

@Mixin(value={ThreadedLevelLightEngine.class})
public abstract class ThreadedLevelLightEngine_scarpetChunkCreationMixin
extends LevelLightEngine
implements ServerLightingProviderInterface {
    @Shadow
    @Final
    private ChunkMap chunkMap;

    private ThreadedLevelLightEngine_scarpetChunkCreationMixin(LightChunkGetter chunkProvider, boolean hasBlockLight, boolean hasSkyLight) {
        super(chunkProvider, hasBlockLight, hasSkyLight);
    }

    @Shadow
    protected abstract void addTask(int var1, int var2, IntSupplier var3, ThreadedLevelLightEngine.TaskType var4, Runnable var5);

    @Override
    @Invoker(value="updateChunkStatus")
    public abstract void invokeUpdateChunkStatus(ChunkPos var1);

    @Override
    public void removeLightData(ChunkAccess chunk) {
        ChunkPos pos = chunk.getPos();
        chunk.setLightCorrect(false);
        this.addTask(pos.x, pos.z, () -> 0, ThreadedLevelLightEngine.TaskType.PRE_UPDATE, Util.name(() -> {
            super.setLightEnabled(pos, false);
            ((Lighting_scarpetChunkCreationInterface)((Object)this)).removeLightData(SectionPos.getZeroNode((long)SectionPos.asLong((int)pos.x, (int)0, (int)pos.z)));
        }, () -> "Remove light data " + String.valueOf(pos)));
    }

    @Override
    public CompletableFuture<Void> relight(ChunkAccess chunk) {
        ChunkPos pos = chunk.getPos();
        this.addTask(pos.x, pos.z, () -> 0, ThreadedLevelLightEngine.TaskType.PRE_UPDATE, Util.name(() -> {
            super.propagateLightSources(pos);
            int minY = chunk.getMinBuildHeight();
            int maxY = chunk.getMaxBuildHeight();
            int minX = pos.getMinBlockX();
            int minZ = pos.getMinBlockZ();
            BlockPos.MutableBlockPos poss = new BlockPos.MutableBlockPos();
            for (int x = -1; x < 17; ++x) {
                for (int z = -1; z < 17; ++z) {
                    if (x > 0 && x < 16 && z > 0 && z < 16) continue;
                    for (int y = minY; y < maxY; ++y) {
                        poss.set(x + minX, y, z + minZ);
                        super.checkBlock((BlockPos)poss);
                    }
                }
            }
        }, () -> "Relight chunk " + String.valueOf(pos)));
        return CompletableFuture.runAsync(Util.name(() -> chunk.setLightCorrect(true), () -> "Release relight ticket " + String.valueOf(pos)), runnable -> this.addTask(pos.x, pos.z, () -> 0, ThreadedLevelLightEngine.TaskType.POST_UPDATE, runnable));
    }
}

