/*
 * Decompiled with CFR 0.152.
 */
package carpet.network;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.InvalidRuleValueException;
import carpet.api.settings.SettingsManager;
import carpet.network.CarpetClient;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientNetworkHandler {
    private static final Map<String, BiConsumer<LocalPlayer, Tag>> dataHandlers = new HashMap<String, BiConsumer<LocalPlayer, Tag>>();

    private static void onHi(String version) {
        CarpetClient.setCarpet();
        CarpetClient.serverCarpetVersion = version;
        if (CarpetSettings.carpetVersion.equals(CarpetClient.serverCarpetVersion)) {
            CarpetSettings.LOG.info("Joined carpet server with matching carpet version");
        } else {
            CarpetSettings.LOG.warn("Joined carpet server with another carpet version: " + CarpetClient.serverCarpetVersion);
        }
        ClientNetworkHandler.respondHello();
    }

    public static void respondHello() {
        CompoundTag data = new CompoundTag();
        data.putString("420", CarpetSettings.carpetVersion);
        CarpetClient.getPlayer().connection.send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new CarpetClient.CarpetPayload(data)));
        PacketDistributor.sendToServer((CustomPacketPayload)new CarpetClient.CarpetPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void onServerData(CarpetClient.CarpetPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            CompoundTag compound = payload.data();
            LocalPlayer player = (LocalPlayer)context.player();
            for (String key : compound.getAllKeys()) {
                if (dataHandlers.containsKey(key)) {
                    try {
                        dataHandlers.get(key).accept(player, compound.get(key));
                    }
                    catch (Exception exc) {
                        CarpetSettings.LOG.info("Corrupt carpet data for " + key);
                    }
                    continue;
                }
                CarpetSettings.LOG.error("Unknown carpet data: " + key);
            }
        });
    }

    public static void clientCommand(String command) {
        CompoundTag tag = new CompoundTag();
        tag.putString("id", command);
        tag.putString("command", command);
        CompoundTag outer = new CompoundTag();
        outer.put("clientCommand", (Tag)tag);
        CarpetClient.getPlayer().connection.send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new CarpetClient.CarpetPayload(outer)));
    }

    static {
        dataHandlers.put("69", (p, t) -> ClientNetworkHandler.onHi(t.getAsString()));
        dataHandlers.put("Rules", (p, t) -> {
            CompoundTag ruleset = (CompoundTag)t;
            for (String ruleKey : ruleset.getAllKeys()) {
                CarpetRule<?> rule;
                String ruleName;
                CompoundTag ruleNBT = (CompoundTag)ruleset.get(ruleKey);
                SettingsManager manager = null;
                if (ruleNBT.contains("Manager")) {
                    ruleName = ruleNBT.getString("Rule");
                    String managerName = ruleNBT.getString("Manager");
                    if (managerName.equals("carpet")) {
                        manager = CarpetServer.settingsManager;
                    } else {
                        for (CarpetExtension extension : CarpetServer.extensions) {
                            SettingsManager eManager = extension.extensionSettingsManager();
                            if (eManager == null || !managerName.equals(eManager.identifier())) continue;
                            manager = eManager;
                            break;
                        }
                    }
                } else {
                    manager = CarpetServer.settingsManager;
                    ruleName = ruleKey;
                }
                if ((rule = manager != null ? manager.getCarpetRule(ruleName) : null) == null) continue;
                String value = ruleNBT.getString("Value");
                try {
                    rule.set((CommandSourceStack)null, value);
                }
                catch (InvalidRuleValueException invalidRuleValueException) {}
            }
        });
        dataHandlers.put("scShape", (p, t) -> {
            if (CarpetClient.shapes != null) {
                CarpetClient.shapes.addShape((CompoundTag)t);
            }
        });
        dataHandlers.put("scShapes", (p, t) -> {
            if (CarpetClient.shapes != null) {
                CarpetClient.shapes.addShapes((ListTag)t);
            }
        });
        dataHandlers.put("clientCommand", (p, t) -> CarpetClient.onClientCommand(t));
    }
}

