/*
 * Decompiled with CFR 0.152.
 */
package carpet.network;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.RuleHelper;
import carpet.fakes.ServerGamePacketListenerImplInterface;
import carpet.network.CarpetClient;
import carpet.script.utils.SnoopyCommandSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerNetworkHandler {
    private static final Map<ServerPlayer, String> remoteCarpetPlayers = new HashMap<ServerPlayer, String>();
    private static final Set<ServerPlayer> validCarpetPlayers = new HashSet<ServerPlayer>();
    private static final Map<String, BiConsumer<ServerPlayer, Tag>> dataHandlers = Map.of("420", (p, t) -> ServerNetworkHandler.onHello(p, t.getAsString()), "clientCommand", (p, t) -> ServerNetworkHandler.handleClientCommand(p, (CompoundTag)t));

    public static void onPlayerJoin(ServerPlayer playerEntity) {
        if (!((ServerGamePacketListenerImplInterface)playerEntity.connection).getConnection().isMemoryConnection()) {
            if (playerEntity.connection.hasChannel(CarpetClient.CARPET_CHANNEL)) {
                CompoundTag data = new CompoundTag();
                data.putString("69", CarpetSettings.carpetVersion);
                PacketDistributor.sendToPlayer((ServerPlayer)playerEntity, (CustomPacketPayload)new CarpetClient.CarpetPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        } else {
            validCarpetPlayers.add(playerEntity);
        }
    }

    public static void onHello(ServerPlayer playerEntity, String version) {
        validCarpetPlayers.add(playerEntity);
        remoteCarpetPlayers.put(playerEntity, version);
        if (version.equals(CarpetSettings.carpetVersion)) {
            CarpetSettings.LOG.info("Player " + playerEntity.getName().getString() + " joined with a matching carpet client");
        } else {
            CarpetSettings.LOG.warn("Player " + playerEntity.getName().getString() + " joined with another carpet version: " + version);
        }
        DataBuilder data = DataBuilder.create(playerEntity.server);
        CarpetServer.forEachManager(sm -> sm.getCarpetRules().forEach(data::withRule));
        PacketDistributor.sendToPlayer((ServerPlayer)playerEntity, (CustomPacketPayload)data.build(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendPlayerLevelData(ServerPlayer player, ServerLevel level) {
        if (CarpetSettings.superSecretSetting || !validCarpetPlayers.contains(player)) {
            // empty if block
        }
    }

    private static void handleClientCommand(ServerPlayer player, CompoundTag commandData) {
        String command = commandData.getString("command");
        String id = commandData.getString("id");
        ArrayList<Component> output = new ArrayList<Component>();
        Component[] error = new Component[]{null};
        if (player.getServer() == null) {
            error[0] = Component.literal((String)"No Server");
        } else {
            player.getServer().getCommands().performPrefixedCommand((CommandSourceStack)new SnoopyCommandSource(player, error, output), command);
        }
        CompoundTag result = new CompoundTag();
        result.putString("id", id);
        if (error[0] != null) {
            result.putString("error", error[0].getContents().toString());
        }
        ListTag outputResult = new ListTag();
        for (Component line : output) {
            outputResult.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)line, (HolderLookup.Provider)player.registryAccess())));
        }
        if (!output.isEmpty()) {
            result.put("output", (Tag)outputResult);
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)DataBuilder.create(player.server).withCustomNbt("clientCommand", (Tag)result).build(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void onClientData(CarpetClient.CarpetPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            CompoundTag compound = payload.data();
            ServerPlayer player = (ServerPlayer)context.player();
            for (String key : compound.getAllKeys()) {
                if (dataHandlers.containsKey(key)) {
                    dataHandlers.get(key).accept(player, compound.get(key));
                    continue;
                }
                CarpetSettings.LOG.warn("Unknown carpet client data: " + key);
            }
        });
    }

    public static void updateRuleWithConnectedClients(CarpetRule<?> rule) {
        if (CarpetSettings.superSecretSetting) {
            return;
        }
        for (ServerPlayer player : remoteCarpetPlayers.keySet()) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)DataBuilder.create(player.server).withRule(rule).build(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void broadcastCustomCommand(String command, Tag data) {
        if (CarpetSettings.superSecretSetting) {
            return;
        }
        for (ServerPlayer player : validCarpetPlayers) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)DataBuilder.create(player.server).withCustomNbt(command, data).build(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendCustomCommand(ServerPlayer player, String command, Tag data) {
        if (ServerNetworkHandler.isValidCarpetPlayer(player)) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)DataBuilder.create(player.server).withCustomNbt(command, data).build(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void onPlayerLoggedOut(ServerPlayer player) {
        validCarpetPlayers.remove(player);
        if (!((ServerGamePacketListenerImplInterface)player.connection).getConnection().isMemoryConnection()) {
            remoteCarpetPlayers.remove(player);
        }
    }

    public static void close() {
        remoteCarpetPlayers.clear();
        validCarpetPlayers.clear();
    }

    public static boolean isValidCarpetPlayer(ServerPlayer player) {
        if (CarpetSettings.superSecretSetting) {
            return false;
        }
        return validCarpetPlayers.contains(player);
    }

    public static String getPlayerStatus(ServerPlayer player) {
        if (remoteCarpetPlayers.containsKey(player)) {
            return "carpet " + remoteCarpetPlayers.get(player);
        }
        if (validCarpetPlayers.contains(player)) {
            return "carpet " + CarpetSettings.carpetVersion;
        }
        return "vanilla";
    }

    private static class DataBuilder {
        private CompoundTag tag = new CompoundTag();
        private MinecraftServer server;

        private static DataBuilder create(MinecraftServer server) {
            return new DataBuilder(server);
        }

        private DataBuilder(MinecraftServer server) {
            this.server = server;
        }

        private DataBuilder withRule(CarpetRule<?> rule) {
            CompoundTag rules = (CompoundTag)this.tag.get("Rules");
            if (rules == null) {
                rules = new CompoundTag();
                this.tag.put("Rules", (Tag)rules);
            }
            String identifier = rule.settingsManager().identifier();
            Object key = rule.name();
            while (rules.contains((String)key)) {
                key = (String)key + "2";
            }
            CompoundTag ruleNBT = new CompoundTag();
            ruleNBT.putString("Value", RuleHelper.toRuleString(rule.value()));
            ruleNBT.putString("Manager", identifier);
            ruleNBT.putString("Rule", rule.name());
            rules.put((String)key, (Tag)ruleNBT);
            return this;
        }

        public DataBuilder withCustomNbt(String key, Tag value) {
            this.tag.put(key, value);
            return this;
        }

        private CarpetClient.CarpetPayload build() {
            return new CarpetClient.CarpetPayload(this.tag);
        }
    }
}

