/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.annotation;

import carpet.script.CarpetContext;
import carpet.script.Context;
import carpet.script.Module;
import carpet.script.annotation.ValueConverter;
import carpet.script.argument.BlockArgument;
import carpet.script.argument.FunctionArgument;
import carpet.script.argument.Vector3Argument;
import carpet.script.value.BlockValue;
import carpet.script.value.FunctionValue;
import carpet.script.value.Value;
import com.google.common.collect.Lists;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedType;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public interface Locator {

    public static final class Locators {
        private Locators() {
        }

        static <R> ValueConverter<R> fromAnnotatedType(AnnotatedType annoType, Class<R> type) {
            if (annoType.isAnnotationPresent(Block.class)) {
                return new BlockLocator<R>(annoType.getAnnotation(Block.class), type);
            }
            if (annoType.isAnnotationPresent(Function.class)) {
                return new FunctionLocator<R>(annoType.getAnnotation(Function.class), type);
            }
            if (annoType.isAnnotationPresent(Vec3d.class)) {
                return new Vec3dLocator<R>(annoType.getAnnotation(Vec3d.class), type);
            }
            throw new IllegalStateException("Locator#fromAnnotatedType got called with an incompatible AnnotatedType");
        }

        private static class BlockLocator<R>
        extends AbstractLocator<R> {
            private final java.util.function.Function<BlockArgument, R> returnFunction;
            private final boolean acceptString;
            private final boolean anyString;
            private final boolean optional;

            public BlockLocator(Block annotation, Class<R> type) {
                this.acceptString = annotation.acceptString();
                this.anyString = annotation.anyString();
                this.optional = annotation.optional();
                if (type != BlockArgument.class && (this.anyString || this.optional)) {
                    throw new IllegalArgumentException("Can only use anyString or optional parameters of Locator.Block if targeting a BlockArgument");
                }
                this.returnFunction = BlockLocator.getReturnFunction(type);
                if (this.returnFunction == null) {
                    throw new IllegalArgumentException("Locator.Block can only be used against BlockArgument, BlockValue, BlockPos or BlockState types!");
                }
            }

            @Nullable
            private static <R> java.util.function.Function<BlockArgument, R> getReturnFunction(Class<R> type) {
                if (type == BlockArgument.class) {
                    return r -> r;
                }
                if (type == BlockValue.class) {
                    return r -> r.block;
                }
                if (type == BlockPos.class) {
                    return r -> r.block.getPos();
                }
                if (type == BlockState.class) {
                    return r -> r.block.getBlockState();
                }
                return null;
            }

            @Override
            public String getTypeName() {
                return "block";
            }

            @Override
            public R checkAndConvert(Iterator<Value> valueIterator, Context context, Context.Type theLazyT) {
                BlockArgument locator = BlockArgument.findIn((CarpetContext)context, valueIterator, 0, this.acceptString, this.optional, this.anyString);
                return this.returnFunction.apply(locator);
            }
        }

        private static class FunctionLocator<R>
        extends AbstractLocator<R> {
            private final boolean returnFunctionValue;
            private final boolean allowNone;
            private final boolean checkArgs;

            FunctionLocator(Function annotation, Class<R> type) {
                boolean bl = this.returnFunctionValue = type == FunctionValue.class;
                if (!this.returnFunctionValue && type != FunctionArgument.class) {
                    throw new IllegalArgumentException("Params annotated with Locator.Function must be of either FunctionArgument or FunctionValue type");
                }
                this.allowNone = annotation.allowNone();
                this.checkArgs = annotation.checkArgs();
                if (this.returnFunctionValue && this.allowNone) {
                    throw new IllegalArgumentException("Cannot use allowNone of Locator.Function in FunctionValue types, use FunctionArgument");
                }
            }

            @Override
            public R checkAndConvert(Iterator<Value> valueIterator, Context context, Context.Type theLazyT) {
                Module module = context.host.main;
                FunctionArgument locator = FunctionArgument.findIn(context, module, Lists.newArrayList(valueIterator), 0, this.allowNone, this.checkArgs);
                Object ret = this.returnFunctionValue ? locator.function : locator;
                return (R)ret;
            }

            @Override
            public String getTypeName() {
                return "function";
            }
        }

        private static class Vec3dLocator<R>
        extends AbstractLocator<R> {
            private final boolean optionalDirection;
            private final boolean optionalEntity;
            private final boolean returnVec3d;

            public Vec3dLocator(Vec3d annotation, Class<R> type) {
                this.optionalDirection = annotation.optionalDirection();
                this.optionalEntity = annotation.optionalEntity();
                boolean bl = this.returnVec3d = type == Vec3.class;
                if (this.returnVec3d && this.optionalDirection) {
                    throw new IllegalArgumentException("optionalDirection Locator.Vec3d cannot be used for Vec3d type, use Vector3Argument instead");
                }
                if (!this.returnVec3d && type != Vector3Argument.class) {
                    throw new IllegalArgumentException("Locator.Vec3d can only be used in Vector3Argument or Vec3d types");
                }
            }

            @Override
            public String getTypeName() {
                return "position";
            }

            @Override
            public R checkAndConvert(Iterator<Value> valueIterator, Context context, Context.Type theLazyT) {
                Vector3Argument locator = Vector3Argument.findIn(valueIterator, 0, this.optionalDirection, this.optionalEntity);
                Vector3Argument ret = this.returnVec3d ? locator.vec : locator;
                return (R)ret;
            }
        }

        private static abstract class AbstractLocator<R>
        implements ValueConverter<R>,
        Locator {
            private AbstractLocator() {
            }

            @Override
            public R convert(Value value, @Nullable Context context) {
                throw new UnsupportedOperationException("Cannot call a locator in a parameter that doesn't contain a context!");
            }

            @Override
            public boolean consumesVariableArgs() {
                return true;
            }

            @Override
            public int valueConsumption() {
                return 1;
            }

            @Override
            public abstract R checkAndConvert(Iterator<Value> var1, Context var2, Context.Type var3);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.TYPE_USE})
    public static @interface Function {
        public boolean allowNone() default false;

        public boolean checkArgs();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.TYPE_USE})
    public static @interface Vec3d {
        public boolean optionalDirection() default false;

        public boolean optionalEntity() default false;
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER, ElementType.TYPE_USE})
    public static @interface Block {
        public boolean acceptString() default false;

        public boolean optional() default false;

        public boolean anyString() default false;
    }
}

