/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.script.CarpetContext;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.Fluff;
import carpet.script.LazyValue;
import carpet.script.argument.BlockArgument;
import carpet.script.argument.Vector3Argument;
import carpet.script.exception.BreakStatement;
import carpet.script.exception.ContinueStatement;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.BlockValue;
import carpet.script.value.LazyListValue;
import carpet.script.value.ListValue;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;

public class BlockIterators {
    public static void apply(Expression expression) {
        expression.addLazyFunction("scan", (c, t, llv) -> {
            if (llv.size() < 3) {
                throw new InternalExpressionException("'scan' needs many more arguments");
            }
            List<Value> lv = Fluff.AbstractFunction.unpackLazy(llv.subList(0, llv.size() - 1), c, Context.NONE);
            CarpetContext cc = (CarpetContext)c;
            BlockArgument centerLocator = BlockArgument.findIn(cc, lv, 0);
            Vector3Argument rangeLocator = Vector3Argument.findIn(lv, centerLocator.offset);
            BlockPos center = centerLocator.block.getPos();
            Vec3i range = rangeLocator.fromBlock ? new Vec3i(Mth.floor((double)Math.abs(rangeLocator.vec.x - (double)center.getX())), Mth.floor((double)Math.abs(rangeLocator.vec.y - (double)center.getY())), Mth.floor((double)Math.abs(rangeLocator.vec.z - (double)center.getZ()))) : new Vec3i(Mth.floor((double)Math.abs(rangeLocator.vec.x)), Mth.floor((double)Math.abs(rangeLocator.vec.y)), Mth.floor((double)Math.abs(rangeLocator.vec.z)));
            Vec3i upperRange = range;
            if (lv.size() > rangeLocator.offset + 1) {
                rangeLocator = Vector3Argument.findIn(lv, rangeLocator.offset);
                upperRange = rangeLocator.fromBlock ? new Vec3i(Mth.floor((double)Math.abs(rangeLocator.vec.x - (double)center.getX())), Mth.floor((double)Math.abs(rangeLocator.vec.y - (double)center.getY())), Mth.floor((double)Math.abs(rangeLocator.vec.z - (double)center.getZ()))) : new Vec3i(Mth.floor((double)Math.abs(rangeLocator.vec.x)), Mth.floor((double)Math.abs(rangeLocator.vec.y)), Mth.floor((double)Math.abs(rangeLocator.vec.z)));
            }
            if (llv.size() != rangeLocator.offset + 1) {
                throw new InternalExpressionException("'scan' takes two, or three block positions, and an expression: " + lv.size() + " " + rangeLocator.offset);
            }
            LazyValue expr = (LazyValue)llv.get(rangeLocator.offset);
            int cx = center.getX();
            int cy = center.getY();
            int cz = center.getZ();
            int xrange = range.getX();
            int yrange = range.getY();
            int zrange = range.getZ();
            int xprange = upperRange.getX();
            int yprange = upperRange.getY();
            int zprange = upperRange.getZ();
            LazyValue xVal = c.getVariable("_x");
            LazyValue yVal = c.getVariable("_y");
            LazyValue zVal = c.getVariable("_z");
            LazyValue defaultVal = c.getVariable("_");
            int sCount = 0;
            block3: for (int y = cy - yrange; y <= cy + yprange; ++y) {
                int yFinal = y;
                c.setVariable("_y", (ct, tt) -> new NumericValue(yFinal).bindTo("_y"));
                for (int x = cx - xrange; x <= cx + xprange; ++x) {
                    int xFinal = x;
                    c.setVariable("_x", (ct, tt) -> new NumericValue(xFinal).bindTo("_x"));
                    for (int z = cz - zrange; z <= cz + zprange; ++z) {
                        Value result;
                        int zFinal = z;
                        c.setVariable("_z", (ct, tt) -> new NumericValue(zFinal).bindTo("_z"));
                        Value blockValue = BlockValue.fromCoords((CarpetContext)c, xFinal, yFinal, zFinal).bindTo("_");
                        c.setVariable("_", (ct, tt) -> blockValue);
                        try {
                            result = expr.evalValue((Context)c, (Context.Type)((Object)t));
                        }
                        catch (ContinueStatement notIgnored) {
                            result = notIgnored.retval;
                        }
                        catch (BreakStatement notIgnored) {
                            break block3;
                        }
                        if (t == Context.VOID || !result.getBoolean()) continue;
                        ++sCount;
                    }
                }
            }
            c.setVariable("_x", xVal);
            c.setVariable("_y", yVal);
            c.setVariable("_z", zVal);
            c.setVariable("_", defaultVal);
            int finalSCount = sCount;
            return (ct, tt) -> new NumericValue(finalSCount);
        });
        expression.addLazyFunction("volume", (c, t, llv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (llv.size() < 3) {
                throw new InternalExpressionException("'volume' needs many more arguments");
            }
            List<Value> lv = Fluff.AbstractFunction.unpackLazy(llv.subList(0, llv.size() - 1), c, Context.NONE);
            BlockArgument pos1Locator = BlockArgument.findIn(cc, lv, 0);
            BlockArgument pos2Locator = BlockArgument.findIn(cc, lv, pos1Locator.offset);
            BlockPos pos1 = pos1Locator.block.getPos();
            BlockPos pos2 = pos2Locator.block.getPos();
            int x1 = pos1.getX();
            int y1 = pos1.getY();
            int z1 = pos1.getZ();
            int x2 = pos2.getX();
            int y2 = pos2.getY();
            int z2 = pos2.getZ();
            int minx = Math.min(x1, x2);
            int miny = Math.min(y1, y2);
            int minz = Math.min(z1, z2);
            int maxx = Math.max(x1, x2);
            int maxy = Math.max(y1, y2);
            int maxz = Math.max(z1, z2);
            LazyValue expr = (LazyValue)llv.get(pos2Locator.offset);
            LazyValue xVal = c.getVariable("_x");
            LazyValue yVal = c.getVariable("_y");
            LazyValue zVal = c.getVariable("_z");
            LazyValue defaultVal = c.getVariable("_");
            int sCount = 0;
            block3: for (int y = miny; y <= maxy; ++y) {
                int yFinal = y;
                c.setVariable("_y", (ct, tt) -> new NumericValue(yFinal).bindTo("_y"));
                for (int x = minx; x <= maxx; ++x) {
                    int xFinal = x;
                    c.setVariable("_x", (ct, tt) -> new NumericValue(xFinal).bindTo("_x"));
                    for (int z = minz; z <= maxz; ++z) {
                        Value result;
                        int zFinal = z;
                        c.setVariable("_z", (ct, tt) -> new NumericValue(zFinal).bindTo("_z"));
                        Value blockValue = BlockValue.fromCoords((CarpetContext)c, xFinal, yFinal, zFinal).bindTo("_");
                        c.setVariable("_", (ct, tt) -> blockValue);
                        try {
                            result = expr.evalValue((Context)c, (Context.Type)((Object)t));
                        }
                        catch (ContinueStatement notIgnored) {
                            result = notIgnored.retval;
                        }
                        catch (BreakStatement notIgnored) {
                            break block3;
                        }
                        if (t == Context.VOID || !result.getBoolean()) continue;
                        ++sCount;
                    }
                }
            }
            c.setVariable("_x", xVal);
            c.setVariable("_y", yVal);
            c.setVariable("_z", zVal);
            c.setVariable("_", defaultVal);
            int finalSCount = sCount;
            return (ct, tt) -> new NumericValue(finalSCount);
        });
        expression.addContextFunction("neighbours", -1, (c, t, lv) -> {
            BlockPos center = BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<Value>)lv, (int)0).block.getPos();
            ServerLevel world = ((CarpetContext)c).level();
            ArrayList<Value> neighbours = new ArrayList<Value>();
            neighbours.add(new BlockValue(world, center.above()));
            neighbours.add(new BlockValue(world, center.below()));
            neighbours.add(new BlockValue(world, center.north()));
            neighbours.add(new BlockValue(world, center.south()));
            neighbours.add(new BlockValue(world, center.east()));
            neighbours.add(new BlockValue(world, center.west()));
            return ListValue.wrap(neighbours);
        });
        expression.addContextFunction("rect", -1, (c, t, lv) -> {
            int smaxz;
            int smaxy;
            int smaxx;
            int sminz;
            int sminy;
            int sminx;
            final CarpetContext cc = (CarpetContext)c;
            BlockArgument cposLocator = BlockArgument.findIn(cc, lv, 0);
            BlockPos cpos = cposLocator.block.getPos();
            final int cx = cpos.getX();
            final int cy = cpos.getY();
            final int cz = cpos.getZ();
            if (lv.size() > cposLocator.offset) {
                Vector3Argument diffLocator = Vector3Argument.findIn(lv, cposLocator.offset);
                if (diffLocator.fromBlock) {
                    sminx = Mth.floor((double)Math.abs(diffLocator.vec.x - (double)cx));
                    sminy = Mth.floor((double)Math.abs(diffLocator.vec.y - (double)cx));
                    sminz = Mth.floor((double)Math.abs(diffLocator.vec.z - (double)cx));
                } else {
                    sminx = Mth.floor((double)Math.abs(diffLocator.vec.x));
                    sminy = Mth.floor((double)Math.abs(diffLocator.vec.y));
                    sminz = Mth.floor((double)Math.abs(diffLocator.vec.z));
                }
                if (lv.size() > diffLocator.offset) {
                    Vector3Argument posDiff = Vector3Argument.findIn(lv, diffLocator.offset);
                    if (posDiff.fromBlock) {
                        smaxx = Mth.floor((double)Math.abs(posDiff.vec.x - (double)cx));
                        smaxy = Mth.floor((double)Math.abs(posDiff.vec.y - (double)cx));
                        smaxz = Mth.floor((double)Math.abs(posDiff.vec.z - (double)cx));
                    } else {
                        smaxx = Mth.floor((double)Math.abs(posDiff.vec.x));
                        smaxy = Mth.floor((double)Math.abs(posDiff.vec.y));
                        smaxz = Mth.floor((double)Math.abs(posDiff.vec.z));
                    }
                } else {
                    smaxx = sminx;
                    smaxy = sminy;
                    smaxz = sminz;
                }
            } else {
                sminx = 1;
                sminy = 1;
                sminz = 1;
                smaxx = 1;
                smaxy = 1;
                smaxz = 1;
            }
            return new LazyListValue(){
                final int minx;
                final int miny;
                final int minz;
                final int maxx;
                final int maxy;
                final int maxz;
                int x;
                int y;
                int z;
                {
                    this.minx = cx - sminx;
                    this.miny = cy - sminy;
                    this.minz = cz - sminz;
                    this.maxx = cx + smaxx;
                    this.maxy = cy + smaxy;
                    this.maxz = cz + smaxz;
                    this.reset();
                }

                @Override
                public boolean hasNext() {
                    return this.y <= this.maxy;
                }

                @Override
                public Value next() {
                    BlockValue r = BlockValue.fromCoords(cc, this.x, this.y, this.z);
                    ++this.x;
                    if (this.x > this.maxx) {
                        this.x = this.minx;
                        ++this.z;
                        if (this.z > this.maxz) {
                            this.z = this.minz;
                            ++this.y;
                        }
                    }
                    return r;
                }

                @Override
                public void fatality() {
                    super.fatality();
                }

                @Override
                public void reset() {
                    this.x = this.minx;
                    this.y = this.miny;
                    this.z = this.minz;
                }

                @Override
                public String getString() {
                    return String.format(Locale.ROOT, "rect[(%d,%d,%d),..,(%d,%d,%d)]", this.minx, this.miny, this.minz, this.maxx, this.maxy, this.maxz);
                }
            };
        });
        expression.addContextFunction("diamond", -1, (c, t, lv) -> {
            int height;
            int width;
            int cz;
            int cy;
            int cx;
            CarpetContext cc;
            block6: {
                cc = (CarpetContext)c;
                BlockArgument cposLocator = BlockArgument.findIn((CarpetContext)c, lv, 0);
                BlockPos cpos = cposLocator.block.getPos();
                try {
                    cx = cpos.getX();
                    cy = cpos.getY();
                    cz = cpos.getZ();
                    if (lv.size() == cposLocator.offset) {
                        return ListValue.of(BlockValue.fromCoords(cc, cx, cy - 1, cz), BlockValue.fromCoords(cc, cx, cy, cz), BlockValue.fromCoords(cc, cx - 1, cy, cz), BlockValue.fromCoords(cc, cx, cy, cz - 1), BlockValue.fromCoords(cc, cx + 1, cy, cz), BlockValue.fromCoords(cc, cx, cy, cz + 1), BlockValue.fromCoords(cc, cx, cy + 1, cz));
                    }
                    if (lv.size() == 1 + cposLocator.offset) {
                        width = (int)((NumericValue)lv.get(cposLocator.offset)).getLong();
                        height = 0;
                        break block6;
                    }
                    if (lv.size() == 2 + cposLocator.offset) {
                        width = (int)((NumericValue)lv.get(cposLocator.offset)).getLong();
                        height = (int)((NumericValue)lv.get(cposLocator.offset + 1)).getLong();
                        break block6;
                    }
                    throw new InternalExpressionException("Incorrect number of arguments for 'diamond'");
                }
                catch (ClassCastException ignored) {
                    throw new InternalExpressionException("Attempted to pass a non-number to 'diamond'");
                }
            }
            if (height == 0) {
                return new LazyListValue(){
                    int curradius;
                    int curpos;
                    {
                        this.reset();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.curradius <= width;
                    }

                    @Override
                    public Value next() {
                        if (this.curradius == 0) {
                            this.curradius = 1;
                            return BlockValue.fromCoords(cc, cx, cy, cz);
                        }
                        BlockValue block = BlockValue.fromCoords(cc, cx + (this.curradius - Math.abs(this.curpos - 2 * this.curradius)), cy, cz - this.curradius + Math.abs(Math.abs(this.curpos - this.curradius) % (4 * this.curradius) - 2 * this.curradius));
                        ++this.curpos;
                        if (this.curpos >= this.curradius * 4) {
                            ++this.curradius;
                            this.curpos = 0;
                        }
                        return block;
                    }

                    @Override
                    public void reset() {
                        this.curradius = 0;
                        this.curpos = 0;
                    }

                    @Override
                    public String getString() {
                        return String.format(Locale.ROOT, "diamond[(%d,%d,%d),%d,0]", cx, cy, cz, width);
                    }
                };
            }
            return new LazyListValue(){
                int curradius;
                int curpos;
                int curheight;
                {
                    this.reset();
                }

                @Override
                public boolean hasNext() {
                    return this.curheight <= height;
                }

                @Override
                public Value next() {
                    if (this.curheight == -height || this.curheight == height) {
                        return BlockValue.fromCoords(cc, cx, cy + this.curheight++, cz);
                    }
                    if (this.curradius == 0) {
                        ++this.curradius;
                        return BlockValue.fromCoords(cc, cx, cy + this.curheight, cz);
                    }
                    BlockValue block = BlockValue.fromCoords(cc, cx + (this.curradius - Math.abs(this.curpos - 2 * this.curradius)), cy + this.curheight, cz - this.curradius + Math.abs(Math.abs(this.curpos - this.curradius) % (4 * this.curradius) - 2 * this.curradius));
                    ++this.curpos;
                    if (this.curpos >= this.curradius * 4) {
                        ++this.curradius;
                        this.curpos = 0;
                        if (this.curradius > width - Math.abs(width * this.curheight / height)) {
                            ++this.curheight;
                            this.curradius = 0;
                        }
                    }
                    return block;
                }

                @Override
                public void reset() {
                    this.curradius = 0;
                    this.curpos = 0;
                    this.curheight = -height;
                }

                @Override
                public String getString() {
                    return String.format(Locale.ROOT, "diamond[(%d,%d,%d),%d,%d]", cx, cy, cz, width, height);
                }
            };
        });
    }
}

