/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.command;

import carpet.script.CarpetScriptHost;
import carpet.script.command.CommandArgument;
import carpet.script.value.FunctionValue;
import com.google.common.collect.Lists;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public class CommandToken
implements Comparable<CommandToken> {
    public final String surface;
    public final boolean isArgument;
    @Nullable
    public final CommandArgument type;

    private CommandToken(String surface, @Nullable CommandArgument type) {
        this.surface = surface;
        this.type = type;
        this.isArgument = type != null;
    }

    @Nullable
    public static CommandToken getToken(String source, CarpetScriptHost host) {
        if (!source.startsWith("<")) {
            return source.matches("[_a-zA-Z]+") ? new CommandToken(source, null) : null;
        }
        return (source = source.substring(1, source.length() - 1)).matches("[_a-zA-Z]+") ? new CommandToken(source, CommandArgument.getTypeForArgument(source, host)) : null;
    }

    public static List<CommandToken> parseSpec(String spec, CarpetScriptHost host) throws CommandSyntaxException {
        if ((spec = spec.trim()).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CommandToken> elements = new ArrayList<CommandToken>();
        HashSet<String> seenArgs = new HashSet<String>();
        for (String el : spec.split("\\s+")) {
            CommandToken tok = CommandToken.getToken(el, host);
            if (tok == null) {
                throw CommandArgument.error("Unrecognized command token: " + el);
            }
            if (tok.isArgument) {
                if (seenArgs.contains(tok.surface)) {
                    throw CommandArgument.error("Repeated command argument: " + tok.surface + ", for '" + spec + "'. Argument names have to be unique");
                }
                seenArgs.add(tok.surface);
            }
            elements.add(tok);
        }
        return elements;
    }

    public static String specFromSignature(FunctionValue function) {
        ArrayList tokens = Lists.newArrayList((Object[])new String[]{function.getString()});
        for (String arg : function.getArguments()) {
            tokens.add("<" + arg + ">");
        }
        return String.join((CharSequence)" ", tokens);
    }

    public ArgumentBuilder<CommandSourceStack, ?> getCommandNode(CarpetScriptHost host) throws CommandSyntaxException {
        return this.isArgument ? CommandArgument.argumentNode(this.surface, host) : Commands.literal((String)this.surface);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandToken that = (CommandToken)o;
        return this.surface.equals(that.surface) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.surface, this.type);
    }

    @Override
    public int compareTo(CommandToken o) {
        if (this.isArgument && !o.isArgument) {
            return 1;
        }
        if (!this.isArgument && o.isArgument) {
            return -1;
        }
        return this.surface.compareTo(o.surface);
    }
}

