/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.value.ListValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import java.util.ArrayList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NullValue
extends NumericValue {
    public static final NullValue NULL = new NullValue();

    @Override
    public String getString() {
        return "null";
    }

    @Override
    public String getPrettyString() {
        return "null";
    }

    @Override
    public boolean getBoolean() {
        return false;
    }

    @Override
    public Value clone() {
        return new NullValue();
    }

    protected NullValue() {
        super(0L);
    }

    @Override
    public boolean equals(Object o) {
        Value value;
        return o instanceof Value && (value = (Value)o).isNull();
    }

    @Override
    public Value slice(long fromDesc, Long toDesc) {
        return Value.NULL;
    }

    @Override
    public NumericValue opposite() {
        return Value.NULL;
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public int compareTo(Value o) {
        return o.isNull() ? 0 : -1;
    }

    @Override
    public Value in(Value value) {
        return Value.NULL;
    }

    @Override
    public String getTypeString() {
        return "null";
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public Tag toTag(boolean force, RegistryAccess regs) {
        if (!force) {
            throw new NBTSerializableValue.IncompatibleTypeException(this);
        }
        return StringTag.valueOf((String)"null");
    }

    @Override
    public Value split(Value delimiter) {
        return ListValue.wrap(new ArrayList<Value>());
    }

    @Override
    public JsonElement toJson() {
        return JsonNull.INSTANCE;
    }

    @Override
    public boolean isNull() {
        return true;
    }
}

