/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.external.Vanilla;
import carpet.script.utils.Colors;
import carpet.script.value.BlockValue;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class ValueConversions {
    private static final Int2ObjectMap<SlotParam> slotIdsToSlotParams = new Int2ObjectOpenHashMap<SlotParam>(){
        {
            int n;
            for (n = 0; n < 54; ++n) {
                this.put(n, new SlotParam(null, n));
            }
            for (n = 0; n < 27; ++n) {
                this.put(200 + n, new SlotParam("enderchest", n));
            }
            for (n = 0; n < 8; ++n) {
                this.put(300 + n, new SlotParam(null, n));
            }
            for (n = 0; n < 15; ++n) {
                this.put(500 + n, new SlotParam(null, n + 2));
            }
            this.put(98, new SlotParam("equipment", 0));
            this.put(99, new SlotParam("equipment", 5));
            for (n = 0; n < 4; ++n) {
                this.put(100 + n, new SlotParam("equipment", n + 1));
            }
            this.put(400, new SlotParam(null, 0));
            this.put(401, new SlotParam(null, 1));
        }
    };

    public static Value of(BlockPos pos) {
        return ListValue.of(new NumericValue(pos.getX()), new NumericValue(pos.getY()), new NumericValue(pos.getZ()));
    }

    public static Value of(Vec3 vec) {
        return ListValue.of(new NumericValue(vec.x), new NumericValue(vec.y), new NumericValue(vec.z));
    }

    public static Value of(ColumnPos cpos) {
        return ListValue.of(new NumericValue(cpos.x()), new NumericValue(cpos.z()));
    }

    public static Value of(ServerLevel world) {
        return ValueConversions.of(world.dimension().location());
    }

    public static Value of(MapColor color) {
        return ListValue.of(StringValue.of(Colors.mapColourName.get(color)), ValueConversions.ofRGB(color.col));
    }

    public static <T extends Number> Value of(MinMaxBounds<T> range) {
        return ListValue.of(range.min().map(NumericValue::of).orElse(Value.NULL), range.max().map(NumericValue::of).orElse(Value.NULL));
    }

    public static Value of(ItemStack stack, RegistryAccess regs) {
        return stack == null || stack.isEmpty() ? Value.NULL : ListValue.of(ValueConversions.of(regs.registryOrThrow(Registries.ITEM).getKey((Object)stack.getItem())), new NumericValue(stack.getCount()), NBTSerializableValue.fromStack(stack, regs));
    }

    public static Value of(Objective objective) {
        return ListValue.of(StringValue.of(objective.getName()), StringValue.of(objective.getCriteria().getName()));
    }

    public static Value of(ObjectiveCriteria criteria) {
        return ListValue.of(StringValue.of(criteria.getName()), BooleanValue.of(criteria.isReadOnly()));
    }

    public static Value of(ParticleOptions particle, RegistryAccess regs) {
        String repr = ParticleTypes.CODEC.encodeStart((DynamicOps)regs.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)particle).toString();
        return StringValue.of(repr.startsWith("minecraft:") ? repr.substring(10) : repr);
    }

    public static Value ofRGB(int value) {
        return new NumericValue(value * 256 + 255);
    }

    public static Level dimFromValue(Value dimensionValue, MinecraftServer server) {
        String dimString;
        if (dimensionValue instanceof EntityValue) {
            return ((EntityValue)dimensionValue).getEntity().getCommandSenderWorld();
        }
        if (dimensionValue instanceof BlockValue) {
            BlockValue bv = (BlockValue)dimensionValue;
            if (bv.getWorld() != null) {
                return bv.getWorld();
            }
            throw new InternalExpressionException("dimension argument accepts only world-localized block arguments");
        }
        return switch (dimString = dimensionValue.getString().toLowerCase(Locale.ROOT)) {
            case "nether", "the_nether" -> server.getLevel(Level.NETHER);
            case "end", "the_end" -> server.getLevel(Level.END);
            case "overworld", "over_world" -> server.getLevel(Level.OVERWORLD);
            default -> {
                ResourceKey dim = null;
                ResourceLocation id = ResourceLocation.parse((String)dimString);
                for (ResourceKey world : server.levelKeys()) {
                    if (!id.equals((Object)world.location())) continue;
                    dim = world;
                    break;
                }
                if (dim == null) {
                    throw new ThrowStatement(dimString, Throwables.UNKNOWN_DIMENSION);
                }
                yield server.getLevel(dim);
            }
        };
    }

    public static Value of(ResourceKey<?> dim) {
        return ValueConversions.of(dim.location());
    }

    public static Value of(TagKey<?> tagKey) {
        return ValueConversions.of(tagKey.location());
    }

    public static Value of(@Nullable ResourceLocation id) {
        if (id == null) {
            return Value.NULL;
        }
        return new StringValue(ValueConversions.simplify(id));
    }

    public static String simplify(ResourceLocation id) {
        if (id == null) {
            return "";
        }
        if (id.getNamespace().equals("minecraft")) {
            return id.getPath();
        }
        return id.toString();
    }

    public static Value of(GlobalPos pos) {
        return ListValue.of(ValueConversions.of(pos.dimension()), ValueConversions.of(pos.pos()));
    }

    public static Value fromPath(ServerLevel world, Path path) {
        ArrayList<Value> nodes = new ArrayList<Value>();
        int len = path.getNodeCount();
        for (int i = 0; i < len; ++i) {
            Node node = path.getNode(i);
            nodes.add(ListValue.of(new BlockValue(null, world, node.asBlockPos()), new StringValue(node.type.name().toLowerCase(Locale.ROOT)), new NumericValue(node.costMalus), BooleanValue.of(node.closed)));
        }
        return ListValue.wrap(nodes);
    }

    public static Value fromTimedMemory(Entity e, long expiry, Object v) {
        Value ret = ValueConversions.fromEntityMemory(e, v);
        return ret.isNull() || expiry == Long.MAX_VALUE ? ret : ListValue.of(ret, new NumericValue(expiry));
    }

    private static Value fromEntityMemory(Entity e, Object v) {
        if (v instanceof GlobalPos) {
            GlobalPos pos = (GlobalPos)v;
            return ValueConversions.of(pos);
        }
        if (v instanceof Entity) {
            Entity entity2 = (Entity)v;
            return new EntityValue(entity2);
        }
        if (v instanceof BlockPos) {
            BlockPos pos = (BlockPos)v;
            return new BlockValue(null, (ServerLevel)e.getCommandSenderWorld(), pos);
        }
        if (v instanceof Number) {
            Number number = (Number)((Object)v);
            return new NumericValue(number.doubleValue());
        }
        if (v instanceof Boolean) {
            Boolean bool = (Boolean)((Object)v);
            return BooleanValue.of(bool);
        }
        if (v instanceof UUID) {
            UUID uuid = (UUID)((Object)v);
            return ValueConversions.ofUUID((ServerLevel)e.getCommandSenderWorld(), uuid);
        }
        if (v instanceof DamageSource) {
            DamageSource source = (DamageSource)v;
            return ListValue.of(new StringValue(source.getMsgId()), source.getEntity() == null ? Value.NULL : new EntityValue(source.getEntity()));
        }
        if (v instanceof Path) {
            Path path = (Path)v;
            return ValueConversions.fromPath((ServerLevel)e.getCommandSenderWorld(), path);
        }
        if (v instanceof PositionTracker) {
            PositionTracker tracker = (PositionTracker)v;
            return new BlockValue(null, (ServerLevel)e.getCommandSenderWorld(), tracker.currentBlockPosition());
        }
        if (v instanceof WalkTarget) {
            WalkTarget target = (WalkTarget)v;
            return ListValue.of(new BlockValue(null, (ServerLevel)e.getCommandSenderWorld(), target.getTarget().currentBlockPosition()), new NumericValue(target.getSpeedModifier()), new NumericValue(target.getCloseEnoughDist()));
        }
        if (v instanceof NearestVisibleLivingEntities) {
            NearestVisibleLivingEntities nvle = (NearestVisibleLivingEntities)v;
            v = StreamSupport.stream(nvle.findAll(entity -> true).spliterator(), false).toList();
        }
        if (v instanceof Set) {
            Set set = (Set)((Object)v);
            v = new ArrayList(set);
        }
        if (v instanceof List) {
            List l = v;
            if (l.isEmpty()) {
                return ListValue.of(new Value[0]);
            }
            Object el = l.get(0);
            if (el instanceof Entity) {
                Entity entity3 = (Entity)el;
                return ListValue.wrap(l.stream().map(o -> new EntityValue(entity3)));
            }
            if (el instanceof GlobalPos) {
                GlobalPos pos = (GlobalPos)el;
                return ListValue.wrap(l.stream().map(o -> ValueConversions.of(pos)));
            }
        }
        return Value.NULL;
    }

    private static Value ofUUID(ServerLevel entityWorld, UUID uuid) {
        Entity current = entityWorld.getEntity(uuid);
        return ListValue.of(current == null ? Value.NULL : new EntityValue(current), new StringValue(uuid.toString()));
    }

    public static Value of(AABB box) {
        return ListValue.of(ListValue.fromTriple(box.minX, box.minY, box.minZ), ListValue.fromTriple(box.maxX, box.maxY, box.maxZ));
    }

    public static Value of(BoundingBox box) {
        return ListValue.of(ListValue.fromTriple(box.minX(), box.minY(), box.minZ()), ListValue.fromTriple(box.maxX(), box.maxY(), box.maxZ()));
    }

    public static Value of(StructureStart structure, RegistryAccess regs) {
        if (structure == null || structure == StructureStart.INVALID_START) {
            return Value.NULL;
        }
        BoundingBox boundingBox = structure.getBoundingBox();
        if (boundingBox.maxX() < boundingBox.minX() || boundingBox.maxY() < boundingBox.minY() || boundingBox.maxZ() < boundingBox.minZ()) {
            return Value.NULL;
        }
        HashMap<Value, Value> ret = new HashMap<Value, Value>();
        ret.put(new StringValue("box"), ValueConversions.of(boundingBox));
        ArrayList<Value> pieces = new ArrayList<Value>();
        for (StructurePiece piece : structure.getPieces()) {
            BoundingBox box = piece.getBoundingBox();
            if (box.maxX() < box.minX() || box.maxY() < box.minY() || box.maxZ() < box.minZ()) continue;
            pieces.add(ListValue.of(NBTSerializableValue.nameFromRegistryId(regs.registryOrThrow(Registries.STRUCTURE_PIECE).getKey((Object)piece.getType())), piece.getOrientation() == null ? Value.NULL : new StringValue(piece.getOrientation().getName()), ListValue.fromTriple(box.minX(), box.minY(), box.minZ()), ListValue.fromTriple(box.maxX(), box.maxY(), box.maxZ())));
        }
        ret.put(new StringValue("pieces"), ListValue.wrap(pieces));
        return MapValue.wrap(ret);
    }

    public static Value of(ScoreHolder scoreHolder) {
        return FormattedTextValue.of(scoreHolder.getFeedbackDisplayName());
    }

    public static Value fromProperty(BlockState state, Property<?> p) {
        Comparable object = state.getValue(p);
        if (object instanceof Boolean || object instanceof Number) {
            return StringValue.of(object.toString());
        }
        if (object instanceof StringRepresentable) {
            StringRepresentable stringRepresentable = (StringRepresentable)object;
            return StringValue.of(stringRepresentable.getSerializedName());
        }
        throw new InternalExpressionException("Unknown property type: " + p.getName());
    }

    public static Value ofVanillaSlotResult(int itemSlot) {
        SlotParam ret = (SlotParam)slotIdsToSlotParams.get(itemSlot);
        return ret == null ? ListValue.of(Value.NULL, new NumericValue(itemSlot)) : ret.build();
    }

    public static Value ofBlockPredicate(RegistryAccess registryAccess, Predicate<BlockInWorld> blockPredicate) {
        Vanilla.BlockPredicatePayload payload = Vanilla.BlockPredicatePayload.of(blockPredicate);
        Registry blocks = registryAccess.registryOrThrow(Registries.BLOCK);
        return ListValue.of(payload.state() == null ? Value.NULL : ValueConversions.of(blocks.getKey((Object)payload.state().getBlock())), payload.tagKey() == null ? Value.NULL : ValueConversions.of(((HolderSet.Named)blocks.getTag(payload.tagKey()).get()).key()), MapValue.wrap(payload.properties()), payload.tag() == null ? Value.NULL : new NBTSerializableValue((Tag)payload.tag()));
    }

    public static ItemStack getItemStackFromValue(Value value, boolean withCount, RegistryAccess regs) {
        String name;
        if (value.isNull()) {
            return ItemStack.EMPTY;
        }
        int count = 1;
        CompoundTag nbtTag = null;
        if (value instanceof ListValue) {
            Value nbtValue;
            ListValue list = (ListValue)value;
            if (list.length() != 3) {
                throw new ThrowStatement("item definition from list of size " + list.length(), Throwables.UNKNOWN_ITEM);
            }
            List<Value> items = list.getItems();
            name = items.get(0).getString();
            if (withCount) {
                count = NumericValue.asNumber(items.get(1)).getInt();
            }
            if (!(nbtValue = items.get(2)).isNull()) {
                nbtTag = ((NBTSerializableValue)NBTSerializableValue.fromValue(nbtValue)).getCompoundTag();
            }
        } else {
            name = value.getString();
        }
        ItemStack itemInput = NBTSerializableValue.parseItem(name, nbtTag, regs);
        itemInput.setCount(count);
        return itemInput;
    }

    public static Value guess(ServerLevel serverWorld, Object o) {
        if (o == null) {
            return Value.NULL;
        }
        if (o instanceof List) {
            List list = (List)o;
            return ListValue.wrap(list.stream().map(oo -> ValueConversions.guess(serverWorld, oo)));
        }
        if (o instanceof BlockPos) {
            BlockPos pos = (BlockPos)o;
            return new BlockValue(null, serverWorld, pos);
        }
        if (o instanceof Entity) {
            Entity e = (Entity)o;
            return EntityValue.of(e);
        }
        if (o instanceof Vec3) {
            Vec3 vec3 = (Vec3)o;
            return ValueConversions.of(vec3);
        }
        if (o instanceof Vec3i) {
            Vec3i vec3i = (Vec3i)o;
            return ValueConversions.of(new BlockPos(vec3i));
        }
        if (o instanceof AABB) {
            AABB aabb = (AABB)o;
            return ValueConversions.of(aabb);
        }
        if (o instanceof BoundingBox) {
            BoundingBox bb = (BoundingBox)o;
            return ValueConversions.of(bb);
        }
        if (o instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)o;
            return ValueConversions.of(itemStack, serverWorld.registryAccess());
        }
        if (o instanceof Boolean) {
            Boolean bool = (Boolean)o;
            return BooleanValue.of(bool);
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            return NumericValue.of(number);
        }
        if (o instanceof ResourceLocation) {
            ResourceLocation resourceLocation = (ResourceLocation)o;
            return ValueConversions.of(resourceLocation);
        }
        return StringValue.of(o.toString());
    }

    record SlotParam(String type, int id) {
        public ListValue build() {
            return ListValue.of(StringValue.of(this.type), new NumericValue(this.id));
        }
    }
}

