/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.CarpetSettings;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerPlayer;

public final class CommandHelper {
    private CommandHelper() {
    }

    public static void notifyPlayersCommandsChanged(MinecraftServer server) {
        if (server == null || server.getPlayerList() == null) {
            return;
        }
        server.tell((Runnable)new TickTask(server.getTickCount(), () -> {
            try {
                for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                    server.getCommands().sendCommands(player);
                }
            }
            catch (NullPointerException e) {
                CarpetSettings.LOG.warn("Exception while refreshing commands, please report this to Carpet", (Throwable)e);
            }
        }));
    }

    public static boolean canUseCommand(CommandSourceStack source, Object commandLevel) {
        String commandLevelString;
        if (commandLevel instanceof Boolean) {
            return (Boolean)commandLevel;
        }
        return switch (commandLevelString = commandLevel.toString()) {
            case "true" -> true;
            case "false" -> false;
            case "ops" -> source.hasPermission(2);
            case "0", "1", "2", "3", "4" -> source.hasPermission(Integer.parseInt(commandLevelString));
            default -> false;
        };
    }
}

