/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.CarpetSettings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Translations {
    private static Map<String, String> translationMap = Collections.emptyMap();
    private static final Map<String, String> FALLBACKS = new HashMap<String, String>();

    public static String tr(String key) {
        return translationMap.getOrDefault(key, key);
    }

    public static String trOrNull(String key) {
        return translationMap.get(key);
    }

    public static String tr(String key, String str) {
        return translationMap.getOrDefault(key, str);
    }

    public static boolean hasTranslations() {
        return !translationMap.isEmpty();
    }

    public static boolean hasTranslation(String key) {
        return translationMap.containsKey(key);
    }

    public static Map<String, String> getTranslationFromResourcePath(String path) {
        InputStream langFile = Translations.class.getClassLoader().getResourceAsStream(path);
        if (langFile == null) {
            return Collections.emptyMap();
        }
        Gson gson = new GsonBuilder().setLenient().create();
        return (Map)gson.fromJson((Reader)new InputStreamReader(langFile, StandardCharsets.UTF_8), (TypeToken)new TypeToken<Map<String, String>>(){});
    }

    public static void updateLanguage() {
        HashMap<String, String> translations = new HashMap<String, String>();
        translations.putAll(Translations.getTranslationFromResourcePath(String.format("assets/carpet/lang/%s.json", CarpetSettings.language)));
        for (CarpetExtension ext : CarpetServer.extensions) {
            Map<String, String> extMappings = ext.canHasTranslations(CarpetSettings.language);
            if (extMappings == null) continue;
            boolean warned = false;
            for (Map.Entry<String, String> entry : extMappings.entrySet()) {
                Object key = entry.getKey();
                if (!((String)key).startsWith("carpet.")) {
                    if (((String)key).startsWith("rule.")) {
                        key = "%s.rule.".formatted("carpet") + ((String)key).substring(5);
                    } else if (((String)key).startsWith("category.")) {
                        key = "%s.category.%s".formatted("carpet", ((String)key).substring(9));
                    }
                    if (!warned && key != entry.getKey()) {
                        CarpetSettings.LOG.warn("Found outdated translation keys in extension '%s'!\nThese won't be supported in a later Carpet version!\nCarpet will now try to map them to the correct keys in a best-effort basis".formatted(ext.getClass().getName()));
                        warned = true;
                    }
                }
                translations.putIfAbsent((String)key, entry.getValue());
            }
        }
        translations.keySet().removeIf(e -> {
            if (e.startsWith("//")) {
                CarpetSettings.LOG.warn("Found translation key starting with // while preparing translations!\nDoing this is deprecated and may cause issues in later versions! Consider settings GSON to \"lenient\" mode and\nusing regular comments instead!\nTranslation key is '%s'".formatted(e));
                return true;
            }
            return false;
        });
        Translations.addFallbacksTo(translations);
        translationMap = translations;
    }

    public static boolean isValidLanguage(String newValue) {
        return true;
    }

    @Deprecated(forRemoval=true)
    public static void registerFallbackTranslation(String key, String description) {
        FALLBACKS.put(key, description);
    }

    private static void addFallbacksTo(Map<String, String> translationMap) {
        FALLBACKS.forEach(translationMap::putIfAbsent);
    }
}

