/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat.model.kinetic;

import com.copycatsplus.copycats.foundation.copycat.ICopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.model.kinetic.CopycatInstance;
import com.copycatsplus.copycats.foundation.copycat.model.kinetic.KineticCopycatRenderData;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlockEntity;
import dev.engine_room.flywheel.lib.instance.AbstractInstance;
import dev.engine_room.flywheel.lib.visual.AbstractBlockEntityVisual;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public abstract class CopycatInstanceManager<B extends BlockEntity, R extends AbstractInstance> {
    protected final AbstractBlockEntityVisual<B> visual;
    protected final B blockEntity;
    protected Map<String, CopycatInstance<R>> copycatInstances = new HashMap<String, CopycatInstance<R>>();
    private ICopycatBlockEntity singleStateBE;
    private IMultiStateCopycatBlockEntity multiStateBE;

    public CopycatInstanceManager(AbstractBlockEntityVisual<B> visual, B blockEntity, String ... keys) {
        this.visual = visual;
        B b = this.blockEntity = blockEntity;
        if (b instanceof IMultiStateCopycatBlockEntity) {
            IMultiStateCopycatBlockEntity multi;
            this.multiStateBE = multi = (IMultiStateCopycatBlockEntity)b;
        } else {
            b = this.blockEntity;
            if (b instanceof ICopycatBlockEntity) {
                ICopycatBlockEntity single;
                this.singleStateBE = single = (ICopycatBlockEntity)b;
            } else {
                throw new IllegalArgumentException("Block entity must implement either IMultiStateCopycatBlockEntity or ICopycatBlockEntity");
            }
        }
        for (String key : keys) {
            this.addModel(key);
        }
    }

    private void addModel(String key) {
        CopycatInstance<R> newInstance = this.createInstance(key);
        newInstance.instance().setChanged();
        this.copycatInstances.put(key, newInstance);
    }

    private BlockState getMaterial(String key) {
        if (this.singleStateBE != null) {
            return this.singleStateBE.getMaterial();
        }
        return this.multiStateBE.getMaterialItemStorage().getMaterialItem(key).material();
    }

    public void update(float pt) {
        for (Map.Entry<String, CopycatInstance<R>> entry : this.copycatInstances.entrySet()) {
            KineticCopycatRenderData renderData = entry.getValue().renderData();
            if (!renderData.state().equalsState(this.blockEntity.getBlockState()) || !renderData.material().equals(this.getMaterial(entry.getKey()))) {
                entry.getValue().instance().delete();
                CopycatInstance<R> newInstance = this.createInstance(entry.getKey());
                entry.setValue(newInstance);
                newInstance.instance().setChanged();
                this.visual.updateLight(pt);
                continue;
            }
            this.updateInstance(entry.getValue());
        }
    }

    public void forEach(Consumer<CopycatInstance<R>> consumer) {
        this.copycatInstances.values().forEach(consumer);
    }

    public abstract void updateInstance(CopycatInstance<R> var1);

    public abstract CopycatInstance<R> createInstance(String var1);
}

