/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.collections;

import com.moulberry.axiom.collections.Position2ObjectMap;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public final class SimpleBlockWeightTracker {
    private class_2680 currentBlock = null;
    private float currentWeight = 0.0f;
    private float totalWeight = 0.0f;

    public static Position2ObjectMap<SimpleBlockWeightTracker> createMap() {
        return new Position2ObjectMap<SimpleBlockWeightTracker>(k -> {
            SimpleBlockWeightTracker[] array = new SimpleBlockWeightTracker[4096];
            for (int i = 0; i < 4096; ++i) {
                array[i] = new SimpleBlockWeightTracker();
            }
            return array;
        });
    }

    public void add(SimpleBlockWeightTracker other) {
        this.totalWeight += other.totalWeight;
        if (this.currentBlock == other.currentBlock) {
            this.currentWeight += other.currentWeight;
        } else {
            this.currentWeight -= other.currentWeight;
            if (this.currentWeight <= 0.0f) {
                this.currentBlock = other.currentBlock;
                this.currentWeight = -this.currentWeight;
            }
        }
    }

    public void add(SimpleBlockWeightTracker other, float multiplier) {
        this.totalWeight += other.totalWeight * multiplier;
        if (this.currentBlock == other.currentBlock) {
            this.currentWeight += other.currentWeight * multiplier;
        } else {
            this.currentWeight -= other.currentWeight * multiplier;
            if (this.currentWeight <= 0.0f) {
                this.currentBlock = other.currentBlock;
                this.currentWeight = -this.currentWeight;
            }
        }
    }

    public void addWeight(class_2680 block, float weight) {
        this.totalWeight += weight;
        if (this.currentBlock == block) {
            this.currentWeight += weight;
        } else {
            this.currentWeight -= weight;
            if (this.currentWeight <= 0.0f) {
                this.currentBlock = block;
                this.currentWeight = -this.currentWeight;
            }
        }
    }

    public void addWeight(class_2680 block, float weight, float blockWeight) {
        this.totalWeight += weight;
        if (this.currentBlock == block) {
            this.currentWeight += blockWeight;
        } else {
            this.currentWeight -= blockWeight;
            if (this.currentWeight <= 0.0f) {
                this.currentBlock = block;
                this.currentWeight = -this.currentWeight;
            }
        }
    }

    public void weight(float weight) {
        this.totalWeight = weight;
    }

    @Nullable
    public class_2680 block() {
        return this.currentBlock;
    }

    public float totalWeight() {
        return this.totalWeight;
    }

    public float currentWeight() {
        return this.currentWeight;
    }

    public String toString() {
        return "SimpleBlockWeightTracker[currentBlock=" + String.valueOf(this.currentBlock) + ", currentWeight=" + this.currentWeight + ", totalWeight=" + this.totalWeight + "]";
    }
}

