/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.mixin;

import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.hooks.WindowExt;
import com.moulberry.axiom.utils.WindowSizeTracker;
import net.minecraft.class_1041;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1041.class})
public abstract class MixinWindow
implements WindowExt {
    @Shadow
    private int field_5181;
    @Shadow
    private int field_5196;
    @Shadow
    private int field_5182;
    @Shadow
    private int field_5197;
    @Shadow
    private double field_5179;
    @Shadow
    private int field_5180;
    @Shadow
    private int field_5194;

    @Shadow
    protected abstract void method_4483();

    @Shadow
    protected abstract void method_4488(long var1, int var3, int var4);

    @Shadow
    public abstract long method_4490();

    @Unique
    private float calculateWidthScaleFactor() {
        return Math.max(0.125f, Math.min(8.0f, (float)this.field_5181 / (float)this.field_5182));
    }

    @Override
    public void axiom$refreshFramebufferSize() {
        this.method_4483();
    }

    @Override
    public void axiom$resize(long window, int width, int height) {
        this.method_4488(window, width, height);
    }

    @Unique
    private float calculateHeightScaleFactor() {
        return Math.max(0.125f, Math.min(8.0f, (float)this.field_5196 / (float)this.field_5197));
    }

    @Inject(method={"getWidth"}, at={@At(value="HEAD")}, cancellable=true)
    public void getWidth(CallbackInfoReturnable<Integer> cir) {
        if (EditorUI.isActive()) {
            cir.setReturnValue((Object)EditorUI.getNewGameWidth(this.calculateWidthScaleFactor()));
        }
    }

    @Inject(method={"getHeight"}, at={@At(value="HEAD")}, cancellable=true)
    public void getHeight(CallbackInfoReturnable<Integer> cir) {
        if (EditorUI.isActive()) {
            cir.setReturnValue((Object)EditorUI.getNewGameHeight(this.calculateHeightScaleFactor()));
        }
    }

    @Inject(method={"getScreenWidth"}, at={@At(value="HEAD")}, cancellable=true)
    public void getScreenWidth(CallbackInfoReturnable<Integer> cir) {
        if (EditorUI.isActive()) {
            cir.setReturnValue((Object)EditorUI.getNewGameWidth(1.0f));
        }
    }

    @Inject(method={"getScreenHeight"}, at={@At(value="HEAD")}, cancellable=true)
    public void getScreenHeight(CallbackInfoReturnable<Integer> cir) {
        if (EditorUI.isActive()) {
            cir.setReturnValue((Object)EditorUI.getNewGameHeight(1.0f));
        }
    }

    @Inject(method={"onResize"}, at={@At(value="HEAD")}, cancellable=true)
    public void onResizeInject(long l, int i, int j, CallbackInfo ci) {
        if (EditorUI.isActive()) {
            if (l != this.method_4490()) {
                ci.cancel();
            } else {
                WindowSizeTracker.dirty();
            }
        }
    }

    @Inject(method={"calculateScale"}, at={@At(value="HEAD")}, cancellable=true)
    public void calculateScale(int scale, boolean forceEven, CallbackInfoReturnable<Integer> cir) {
        if (EditorUI.isActive()) {
            int j;
            int fbw = EditorUI.getNewGameWidth(this.calculateWidthScaleFactor());
            int fbh = EditorUI.getNewGameHeight(this.calculateHeightScaleFactor());
            for (j = 1; j != scale && j < fbw && j < fbh && fbw / (j + 1) >= 320 && fbh / (j + 1) >= 240; ++j) {
            }
            if (forceEven && j % 2 != 0) {
                ++j;
            }
            cir.setReturnValue((Object)j);
        }
    }

    @Inject(method={"setGuiScale"}, at={@At(value="HEAD")}, cancellable=true)
    public void setGuiScale(double d, CallbackInfo ci) {
        if (EditorUI.isActive()) {
            int fbw = EditorUI.getNewGameWidth(this.calculateWidthScaleFactor());
            int fbh = EditorUI.getNewGameHeight(this.calculateHeightScaleFactor());
            this.field_5179 = d;
            int i = (int)((double)fbw / d);
            this.field_5180 = (double)fbw / d > (double)i ? i + 1 : i;
            int j = (int)((double)fbh / d);
            this.field_5194 = (double)fbh / d > (double)j ? j + 1 : j;
            ci.cancel();
        }
    }
}

