/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.operations;

import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.utils.IntWrapper;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import java.text.NumberFormat;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_638;

public class UpdateBlocksOperation {
    public static void updateBlocks() {
        SelectionBuffer selectionBuffer = Selection.getSelectionBuffer();
        if (selectionBuffer instanceof SelectionBuffer.AABB) {
            SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)selectionBuffer;
            UpdateBlocksOperation.updateBlocksAABB(aabb);
        } else if (selectionBuffer instanceof SelectionBuffer.Set) {
            SelectionBuffer.Set set = (SelectionBuffer.Set)selectionBuffer;
            UpdateBlocksOperation.updateBlocksSet(set);
        }
    }

    private static void updateBlocksAABB(SelectionBuffer.AABB aabb) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        int changeCount = 0;
        int minX = aabb.min().method_10263();
        int minY = aabb.min().method_10264();
        int minZ = aabb.min().method_10260();
        int maxX = aabb.max().method_10263();
        int maxY = aabb.max().method_10264();
        int maxZ = aabb.max().method_10260();
        minY = Math.max(world.method_31607(), minY);
        maxY = Math.min(world.method_31600() - 1, maxY);
        class_2350[] directions = class_2350.values();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_2338.class_2339 mutableBlockPos2 = new class_2338.class_2339();
        class_5819 randomSource = class_5819.method_43047();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                    if (block.method_26204() == class_2246.field_10243) continue;
                    class_2680 originalBlock = block;
                    for (class_2350 direction : directions) {
                        mutableBlockPos2.method_25505((class_2382)mutableBlockPos, direction);
                        block = block.method_26191(direction, world.method_8320((class_2338)mutableBlockPos2), (class_1936)world, (class_2338)mutableBlockPos, (class_2338)mutableBlockPos2);
                    }
                    if (originalBlock == block) continue;
                    setOperation.set(x, y, z, block);
                    previousBlocksForUndo.set(x, y, z, originalBlock);
                    ++changeCount;
                }
            }
        }
        String countString = NumberFormat.getInstance().format(changeCount);
        String historyDescription = AxiomI18n.get("axiom.history_description.updated", countString);
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBlocksForUndo, aabb.center(), historyDescription, 0));
    }

    private static void updateBlocksSet(SelectionBuffer.Set set) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        BlockBuffer setOperation = new BlockBuffer();
        BlockBuffer previousBlocksForUndo = new BlockBuffer();
        IntWrapper intWrapper = new IntWrapper();
        class_2350[] directions = class_2350.values();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        class_2338.class_2339 mutableBlockPos2 = new class_2338.class_2339();
        class_5819 randomSource = class_5819.method_43047();
        set.selectionRegion.forEach((x, y, z) -> {
            class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
            if (block.method_26204() == class_2246.field_10243) {
                return;
            }
            class_2680 originalBlock = block;
            for (class_2350 direction : directions) {
                mutableBlockPos2.method_25505((class_2382)mutableBlockPos, direction);
                block = block.method_26191(direction, world.method_8320((class_2338)mutableBlockPos2), (class_1936)world, (class_2338)mutableBlockPos, (class_2338)mutableBlockPos2);
            }
            if (originalBlock != block) {
                setOperation.set(x, y, z, block);
                previousBlocksForUndo.set(x, y, z, originalBlock);
                ++intWrapper.value;
            }
        });
        String countString = NumberFormat.getInstance().format(intWrapper.value);
        String historyDescription = AxiomI18n.get("axiom.history_description.updated", countString);
        Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBlocksForUndo, set.selectionRegion.getCenter(), historyDescription, 0));
    }
}

