/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.lasso_select;

import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.core_rendering.AxiomGpuTexture;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.rasterization.Rasterization2D;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.tools.lasso_select.PendingLassoSelect;
import com.moulberry.axiom.utils.AutoCleaningDynamicTexture;
import com.moulberry.axiom.utils.ColourUtils;
import com.moulberry.axiom.utils.FramebufferUtils;
import imgui.ImGui;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_241;
import net.minecraft.class_2487;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class LassoSelect
implements Tool {
    private byte[] points = null;
    private AutoCleaningDynamicTexture lassoTexture = null;
    private Vector2i nextScreenPos = null;
    private Vector2i lastScreenPos = null;
    private Vector2i startScreenPos = null;
    public static List<PendingLassoSelect> pendingDepthBuffer = new ArrayList<PendingLassoSelect>();
    private final int[] mode = new int[]{1};
    private final int[] depth = new int[]{1};
    private boolean includeNonSolid = false;

    @Override
    public void reset() {
        if (this.lassoTexture != null) {
            this.lassoTexture.close();
            this.lassoTexture = null;
        }
        this.lastScreenPos = null;
        this.startScreenPos = null;
        this.points = null;
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                if (this.points != null) {
                    return UserAction.ActionResult.USED_STOP;
                }
                this.reset();
                class_276 target = class_310.method_1551().method_1522();
                int width = target.field_1482;
                int height = target.field_1481;
                if (width <= 0 || height <= 0) {
                    return UserAction.ActionResult.USED_STOP;
                }
                this.points = new byte[width * height];
                return UserAction.ActionResult.USED_STOP;
            }
            case ENTER: {
                if (this.points == null) {
                    return UserAction.ActionResult.NOT_HANDLED;
                }
                this.confirm();
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: {
                if (this.points == null) break;
                this.reset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    private void confirm() {
        class_276 target = class_310.method_1551().method_1522();
        int width = target.field_1482;
        int height = target.field_1481;
        if (this.points.length == width * height && this.depth[0] != 0) {
            if (this.lastScreenPos != null && this.startScreenPos != null) {
                if (this.nextScreenPos == null || this.nextScreenPos.equals((Object)this.lastScreenPos) || this.nextScreenPos.equals((Object)this.startScreenPos)) {
                    LassoSelect.drawLine(this.points, width, new Vector2i((Vector2ic)this.lastScreenPos), new Vector2i((Vector2ic)this.startScreenPos));
                } else {
                    LassoSelect.drawLine(this.points, width, new Vector2i((Vector2ic)this.lastScreenPos), new Vector2i((Vector2ic)this.nextScreenPos));
                    LassoSelect.drawLine(this.points, width, new Vector2i((Vector2ic)this.nextScreenPos), new Vector2i((Vector2ic)this.startScreenPos));
                }
            }
            PendingLassoSelect pendingLassoSelect = new PendingLassoSelect(this.points, width, height, this.depth[0], this.includeNonSolid || this.depth[0] < 0, this.mode[0]);
            pendingDepthBuffer.add(pendingLassoSelect);
        }
        this.reset();
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        class_1011 pixels;
        if (this.points == null) {
            Selection.render(camera, time, matrices, projection, 7);
            return;
        }
        Selection.render(camera, time, matrices, projection, 4);
        if (Tool.cancelUsing()) {
            this.reset();
            return;
        }
        class_276 target = class_310.method_1551().method_1522();
        int width = target.field_1482;
        int height = target.field_1481;
        if (this.points.length != width * height) {
            this.reset();
            return;
        }
        boolean changed = false;
        class_241 currentMousePosition = new class_241(EditorUI.getIO().getMousePosX(), EditorUI.getIO().getMousePosY());
        if (Tool.isMouseDown(1)) {
            ArrayList<class_241> mousePositions = new ArrayList<class_241>(EditorUI.imguiGlfw.getCapturedInterframeMousePositions());
            mousePositions.add(currentMousePosition);
            for (class_241 mousePosition : mousePositions) {
                class_241 screenPos = EditorUI.getMouseViewportFraction(mousePosition.field_1343, mousePosition.field_1342);
                int x = (int)(screenPos.field_1343 * (float)width);
                int y = (int)(screenPos.field_1342 * (float)height);
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                if (x >= width) {
                    x = width - 1;
                }
                if (y >= height) {
                    y = height - 1;
                }
                Vector2i screenPosInt = new Vector2i(x, y);
                if (this.startScreenPos == null) {
                    this.startScreenPos = new Vector2i((Vector2ic)screenPosInt);
                }
                if (this.lastScreenPos != null) {
                    if (this.lastScreenPos.x == screenPosInt.x && this.lastScreenPos.y == screenPosInt.y) continue;
                    LassoSelect.drawLine(this.points, width, new Vector2i((Vector2ic)this.lastScreenPos), new Vector2i((Vector2ic)screenPosInt));
                    this.lastScreenPos = new Vector2i((Vector2ic)screenPosInt);
                    changed = true;
                    continue;
                }
                this.points[x + y * width] = -1;
                this.lastScreenPos = new Vector2i((Vector2ic)screenPosInt);
                changed = true;
            }
            this.nextScreenPos = null;
        } else {
            class_241 screenPos = EditorUI.getMouseViewportFraction(currentMousePosition.field_1343, currentMousePosition.field_1342);
            int x = (int)(screenPos.field_1343 * (float)width);
            int y = (int)(screenPos.field_1342 * (float)height);
            if (x > 0 && y > 0 && x < width - 1 && y < height - 1) {
                Vector2i nextScreenPos = new Vector2i(x, y);
                if (this.nextScreenPos == null || this.nextScreenPos.x != nextScreenPos.x || this.nextScreenPos.y != nextScreenPos.y) {
                    this.nextScreenPos = nextScreenPos;
                    changed = true;
                }
            } else if (this.nextScreenPos != null) {
                this.nextScreenPos = null;
                changed = true;
            }
        }
        if (this.lassoTexture == null) {
            this.lassoTexture = new AutoCleaningDynamicTexture(width, height, true);
            changed = true;
        }
        if ((pixels = this.lassoTexture.method_4525()) == null || pixels.method_4307() != width || pixels.method_4323() != height) {
            this.lassoTexture.close();
            this.lassoTexture = new AutoCleaningDynamicTexture(width, height, true);
            pixels = Objects.requireNonNull(this.lassoTexture.method_4525());
            changed = true;
        }
        if (changed) {
            byte[] data;
            if (this.lastScreenPos != null && this.startScreenPos != null) {
                data = Arrays.copyOf(this.points, this.points.length);
                if (this.nextScreenPos == null || this.nextScreenPos.equals((Object)this.lastScreenPos) || this.nextScreenPos.equals((Object)this.startScreenPos)) {
                    LassoSelect.drawLine(data, width, new Vector2i((Vector2ic)this.lastScreenPos), new Vector2i((Vector2ic)this.startScreenPos));
                } else {
                    LassoSelect.drawLine(data, width, new Vector2i((Vector2ic)this.lastScreenPos), new Vector2i((Vector2ic)this.nextScreenPos));
                    LassoSelect.drawLine(data, width, new Vector2i((Vector2ic)this.nextScreenPos), new Vector2i((Vector2ic)this.startScreenPos));
                }
            } else {
                data = this.points;
            }
            for (int y = 0; y < height; ++y) {
                boolean inside = false;
                int countUp = 0;
                int countDown = 0;
                for (int x = 0; x < width; ++x) {
                    byte value = data[x + y * width];
                    if (value != 0) {
                        if (this.points[x + y * width] != 0) {
                            pixels.method_4305(x, height - y - 1, ColourUtils.argbToAbgr(-6882));
                        } else {
                            pixels.method_4305(x, height - y - 1, ColourUtils.argbToAbgr(-2130713314));
                        }
                        if (value == -1 || (countUp += value >> 4 & 0xF) <= 0 || (countDown += value & 0xF) <= 0) continue;
                        int min2 = Math.min(countUp, countDown);
                        if ((min2 & 1) != 0) {
                            inside = !inside;
                        }
                        countUp -= min2;
                        countDown -= min2;
                        continue;
                    }
                    if (inside) {
                        pixels.method_4305(x, height - y - 1, ColourUtils.argbToAbgr(-2130713314));
                        continue;
                    }
                    pixels.method_4305(x, height - y - 1, ColourUtils.argbToAbgr(0));
                }
            }
            this.lassoTexture.method_4524();
        }
        FramebufferUtils.blitToMainBlend(new AxiomGpuTexture(this.lassoTexture.method_4624()), width, height);
    }

    private static void drawLine(byte[] data, int stride, Vector2i from, Vector2i to) {
        Rasterization2D.dda(from, to, (x1, y1) -> {
            if (x1 == from.x && y1 == from.y) {
                return;
            }
            int lastIndex = from.x + from.y * stride;
            int index = x1 + y1 * stride;
            byte lastValue = data[lastIndex];
            byte value = data[index];
            if (from.y < y1) {
                int up;
                int down;
                if (value == 0 || value == -1) {
                    data[index] = 1;
                } else {
                    down = (value & 0xF) + 1;
                    up = value >> 4 & 0xF;
                    data[index] = (byte)((up & 0xF) << 4 | down & 0xF);
                }
                if (lastValue == 0 || lastValue == -1) {
                    data[lastIndex] = 16;
                } else {
                    down = lastValue & 0xF;
                    up = (lastValue >> 4 & 0xF) + 1;
                    data[lastIndex] = (byte)((up & 0xF) << 4 | down & 0xF);
                }
            } else if (from.y > y1) {
                int up;
                int down;
                if (value == 0 || value == -1) {
                    data[index] = 16;
                } else {
                    down = value & 0xF;
                    up = (value >> 4 & 0xF) + 1;
                    data[index] = (byte)((up & 0xF) << 4 | down & 0xF);
                }
                if (lastValue == 0 || lastValue == -1) {
                    data[lastIndex] = 1;
                } else {
                    down = (lastValue & 0xF) + 1;
                    up = lastValue >> 4 & 0xF;
                    data[lastIndex] = (byte)((up & 0xF) << 4 | down & 0xF);
                }
            } else if (value == 0) {
                data[index] = -1;
            }
            from.x = x1;
            from.y = y1;
        });
    }

    @Override
    public void displayImguiOptions() {
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.lasso_select"));
        ImGui.sliderInt(AxiomI18n.get("axiom.tool.lasso_select.depth"), this.depth, -64, 64);
        ImGuiHelper.tooltip(AxiomI18n.get("axiom.widget.ctrl_click_hint"));
        if (this.depth[0] > 0 && ImGui.checkbox(AxiomI18n.get("axiom.tool.lasso_select.include_non_solid"), this.includeNonSolid)) {
            this.includeNonSolid = !this.includeNonSolid;
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.selection"));
        ImGuiHelper.combo(AxiomI18n.get("axiom.tool.selection.mode"), this.mode, new String[]{AxiomI18n.get("axiom.tool.selection.replace"), AxiomI18n.get("axiom.tool.selection.add"), AxiomI18n.get("axiom.tool.selection.subtract"), AxiomI18n.get("axiom.tool.selection.intersect")});
        if (this.points != null) {
            ImGui.separator();
            if (ImGui.button("Confirm (" + Keybinds.CONFIRM.longKeyIdentifier() + ")")) {
                this.confirm();
            }
        }
    }

    @Override
    public String listenForEsc() {
        if (this.points != null) {
            return null;
        }
        return AxiomI18n.get("axiom.widget.cancel");
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.lasso_select");
    }

    @Override
    public void writeSettings(class_2487 tag) {
    }

    @Override
    public void loadSettings(class_2487 tag) {
    }

    @Override
    public char iconChar() {
        return '\ue91d';
    }

    @Override
    public String keybindId() {
        return "lasso_select";
    }

    @Override
    public int defaultKeybind() {
        return 76;
    }

    @Override
    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.TOOL_LASSOSELECT);
    }
}

