/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.modelling;

import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.gizmo.ExtrudedGizmo;
import com.moulberry.axiom.gizmo.Gizmo;
import com.moulberry.axiom.tools.Tool;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class GizmoList {
    private final List<Gizmo> gizmos = new ArrayList<Gizmo>();
    private List<GizmoListHistoryEntry> history = new ArrayList<GizmoListHistoryEntry>();
    private int historyPosition = 0;
    private boolean renderGizmos = false;
    private boolean hasGrabbedGizmo = false;
    private boolean isCtrlDown = false;
    private int activeGizmo = -1;
    private boolean pendingDeselect = false;

    private void pushHistory(GizmoListHistoryEntry entry, boolean apply) {
        GizmoListHistoryAction gizmoListHistoryAction;
        while (this.history.size() > this.historyPosition) {
            this.history.remove(this.history.size() - 1);
        }
        if (apply) {
            entry.redo.apply(this);
        }
        if (!this.history.isEmpty() && (gizmoListHistoryAction = entry.undo) instanceof MoveGizmo) {
            MoveGizmo backMoveGizmo = (MoveGizmo)gizmoListHistoryAction;
            GizmoListHistoryEntry last = this.history.get(this.history.size() - 1);
            GizmoListHistoryAction gizmoListHistoryAction2 = last.redo;
            if (gizmoListHistoryAction2 instanceof MoveGizmo) {
                MoveGizmo forwardsMoveGizmo = (MoveGizmo)gizmoListHistoryAction2;
                if (backMoveGizmo.index == forwardsMoveGizmo.index) {
                    this.history.remove(this.history.size() - 1);
                    entry = new GizmoListHistoryEntry(last.undo, entry.redo);
                }
            }
        }
        this.history.add(entry);
        this.historyPosition = this.history.size();
    }

    public List<Gizmo> getGizmos() {
        return this.gizmos;
    }

    @Nullable
    public ExtrudedGizmo extrude() {
        if (this.activeGizmo >= 0) {
            Gizmo gizmo = this.gizmos.get(this.activeGizmo);
            return new ExtrudedGizmo(class_310.method_1551().field_1724, gizmo);
        }
        return null;
    }

    public void finishExtrude(ExtrudedGizmo extrudedGizmo, class_243 lookDirection) {
        if (lookDirection != null) {
            int addIndex = this.gizmos.size();
            for (int i = 0; i < this.gizmos.size(); ++i) {
                Gizmo gizmo = this.gizmos.get(i);
                if (gizmo != extrudedGizmo.extrudeGizmoFrom) continue;
                addIndex = i + 1;
            }
            class_2338 pos = extrudedGizmo.getBlockPos(lookDirection);
            if (pos != null) {
                this.pushHistory(new GizmoListHistoryEntry(new RemoveGizmo(addIndex), new AddGizmo(addIndex, class_243.method_24953((class_2382)pos))), true);
            }
        }
    }

    public boolean handleScroll(int xScroll, int yScroll) {
        for (int i = 0; i < this.gizmos.size(); ++i) {
            Gizmo gizmo = this.gizmos.get(i);
            if (!gizmo.isCenterGrabbed()) continue;
            class_243 look = Tool.getLookDirection();
            class_243 oldTarget = gizmo.getTargetVec();
            gizmo.handleScroll(xScroll, yScroll, EditorUI.isCtrlOrCmdDown(), look);
            class_243 newTarget = gizmo.getTargetVec();
            if (!oldTarget.equals((Object)newTarget)) {
                this.pushHistory(new GizmoListHistoryEntry(new MoveGizmo(i, oldTarget), new MoveGizmo(i, newTarget)), false);
            }
            return true;
        }
        return false;
    }

    public boolean hasActiveGizmo() {
        return this.activeGizmo >= 0;
    }

    public int getActiveGizmoIndex() {
        return this.activeGizmo;
    }

    public boolean hasGrabbedGizmo() {
        return this.hasGrabbedGizmo;
    }

    public boolean isEmpty() {
        return this.gizmos.isEmpty();
    }

    public void deselectActiveGizmo() {
        this.setActiveGizmo(-1);
    }

    public boolean undo() {
        if (this.historyPosition == 0) {
            return false;
        }
        --this.historyPosition;
        this.history.get((int)this.historyPosition).undo.apply(this);
        return true;
    }

    public boolean redo() {
        if (this.historyPosition == this.history.size()) {
            return false;
        }
        this.history.get((int)this.historyPosition).redo.apply(this);
        ++this.historyPosition;
        return true;
    }

    public void delete() {
        if (this.activeGizmo >= 0) {
            Gizmo gizmo = this.gizmos.get(this.activeGizmo);
            this.pushHistory(new GizmoListHistoryEntry(new AddGizmo(this.activeGizmo, gizmo.getTargetVec()), new RemoveGizmo(this.activeGizmo)), true);
        } else {
            this.clear();
        }
    }

    public void clear() {
        if (!this.gizmos.isEmpty()) {
            ArrayList<class_243> positions = new ArrayList<class_243>();
            for (Gizmo gizmo : this.gizmos) {
                positions.add(gizmo.getTargetVec());
            }
            this.pushHistory(new GizmoListHistoryEntry(new SetGizmos(positions), new ClearGizmos()), true);
        }
    }

    public void setActiveGizmo(int index) {
        this.pendingDeselect = false;
        if (this.activeGizmo >= 0 && this.activeGizmo < this.gizmos.size()) {
            this.gizmos.get((int)this.activeGizmo).enableAxes = false;
        }
        if (index >= 0 && index < this.gizmos.size()) {
            this.gizmos.get((int)index).enableAxes = true;
            this.activeGizmo = index;
        } else {
            this.activeGizmo = -1;
        }
    }

    public void addGizmo(class_243 position) {
        int addIndex = this.activeGizmo >= 0 ? this.activeGizmo + 1 : this.gizmos.size();
        this.pushHistory(new GizmoListHistoryEntry(new RemoveGizmo(addIndex), new AddGizmo(addIndex, position)), true);
    }

    public boolean leftClick() {
        Gizmo gizmo;
        if (this.activeGizmo >= 0 && (gizmo = this.gizmos.get(this.activeGizmo)).leftClick()) {
            return true;
        }
        for (int i = 0; i < this.gizmos.size(); ++i) {
            Gizmo gizmo2;
            if (i == this.activeGizmo || !(gizmo2 = this.gizmos.get(i)).leftClick()) continue;
            this.setActiveGizmo(i);
            return true;
        }
        this.pendingDeselect = true;
        return false;
    }

    public boolean updateGizmos(class_4184 camera, long time) {
        boolean showGizmo;
        if (this.pendingDeselect) {
            this.pendingDeselect = false;
            this.setActiveGizmo(-1);
        }
        class_243 lookDirection = Tool.getLookDirection();
        boolean isLeftDown = Tool.isMouseDown(0);
        this.isCtrlDown = EditorUI.isCtrlOrCmdDown();
        this.renderGizmos = showGizmo = !EditorUI.isActive() || !this.isCtrlDown;
        boolean positionChanged = false;
        this.hasGrabbedGizmo = false;
        for (int i = 0; i < this.gizmos.size(); ++i) {
            class_243 after;
            Gizmo gizmo = this.gizmos.get(i);
            class_243 before = gizmo.getTargetVec();
            gizmo.update(time, lookDirection, isLeftDown, this.isCtrlDown, showGizmo);
            gizmo.setAxisDirections(camera.method_19326().field_1352 > (double)gizmo.getTargetPosition().method_10263(), camera.method_19326().field_1351 > (double)gizmo.getTargetPosition().method_10264(), camera.method_19326().field_1350 > (double)gizmo.getTargetPosition().method_10260());
            if (gizmo.isGrabbed()) {
                this.renderGizmos = true;
                this.hasGrabbedGizmo = true;
            }
            if (before.equals((Object)(after = gizmo.getTargetVec()))) continue;
            positionChanged = true;
            this.pushHistory(new GizmoListHistoryEntry(new MoveGizmo(i, before), new MoveGizmo(i, after)), false);
        }
        return positionChanged;
    }

    public void renderGizmos(class_4587 matrices, class_4184 camera) {
        if (!this.renderGizmos) {
            return;
        }
        for (Gizmo gizmo : this.gizmos) {
            gizmo.render(matrices, camera, this.isCtrlDown);
        }
    }

    public record GizmoListHistoryEntry(GizmoListHistoryAction undo, GizmoListHistoryAction redo) {
    }

    public static interface GizmoListHistoryAction {
        public void apply(GizmoList var1);
    }

    public record MoveGizmo(int index, class_243 newPosition) implements GizmoListHistoryAction
    {
        @Override
        public void apply(GizmoList gizmoList) {
            gizmoList.gizmos.get(this.index).moveToVecInstantly(this.newPosition);
        }
    }

    public record RemoveGizmo(int index) implements GizmoListHistoryAction
    {
        @Override
        public void apply(GizmoList gizmoList) {
            gizmoList.gizmos.remove(this.index);
            if (gizmoList.activeGizmo >= 0) {
                if (gizmoList.activeGizmo == this.index) {
                    gizmoList.setActiveGizmo(-1);
                } else if (gizmoList.activeGizmo > this.index) {
                    gizmoList.setActiveGizmo(gizmoList.activeGizmo - 1);
                }
            }
        }
    }

    public record AddGizmo(int index, class_243 position) implements GizmoListHistoryAction
    {
        @Override
        public void apply(GizmoList gizmoList) {
            Gizmo gizmo = new Gizmo(this.position);
            gizmo.enableAxes = false;
            gizmoList.gizmos.add(this.index, gizmo);
            gizmoList.setActiveGizmo(this.index);
        }
    }

    public record SetGizmos(List<class_243> positions) implements GizmoListHistoryAction
    {
        @Override
        public void apply(GizmoList gizmoList) {
            gizmoList.setActiveGizmo(-1);
            gizmoList.gizmos.clear();
            for (class_243 position : this.positions) {
                Gizmo gizmo = new Gizmo(position);
                gizmo.enableAxes = false;
                gizmoList.gizmos.add(gizmo);
            }
        }
    }

    public record ClearGizmos() implements GizmoListHistoryAction
    {
        @Override
        public void apply(GizmoList gizmoList) {
            gizmoList.setActiveGizmo(-1);
            gizmoList.gizmos.clear();
        }
    }
}

