/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_properties.client;

import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.packets.AxiomServerboundSetWorldProperty;
import com.moulberry.axiom.world_properties.WorldPropertyDataType;
import com.moulberry.axiom.world_properties.WorldPropertyWidgetType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public abstract class ClientWorldProperty<T> {
    private static int GLOBAL_UPDATE_ID = 0;
    private final class_2960 id;
    private final String name;
    protected final boolean localizeName;
    protected int updateId = -1;
    protected T value;
    protected T serverValue;

    public ClientWorldProperty(class_2960 id, String name, boolean localizeName, T initialValue) {
        this.id = id;
        this.name = name;
        this.localizeName = localizeName;
        this.serverValue = initialValue;
        this.value = this.serverValue;
    }

    public abstract void renderImgui();

    public abstract WorldPropertyDataType<T> getType();

    public class_2960 getId() {
        return this.id;
    }

    public String getLocalizedName() {
        if (this.localizeName) {
            return AxiomI18n.get(this.name);
        }
        return this.name;
    }

    public T getLocalValue() {
        return this.value;
    }

    public void setRemoteValue(byte[] bytes) {
        this.serverValue = this.getType().deserialize(bytes);
        if (this.updateId < 0) {
            this.value = this.serverValue;
        }
    }

    public void changeLocalValue(T value) {
        if (++GLOBAL_UPDATE_ID < 0) {
            GLOBAL_UPDATE_ID = 0;
        }
        this.updateId = GLOBAL_UPDATE_ID;
        this.value = value;
        new AxiomServerboundSetWorldProperty(this.getId(), this.getType().getTypeId(), this.getType().serialize(this.value), this.updateId).send();
    }

    public void ackChangesUpTo(int updateId) {
        if (this.updateId < 0) {
            return;
        }
        if (this.updateId <= updateId) {
            this.updateId = -1;
            this.value = this.serverValue;
        }
    }

    public static ClientWorldProperty<?> read(class_2540 friendlyByteBuf) {
        class_2960 id = friendlyByteBuf.method_10810();
        String name = friendlyByteBuf.method_19772();
        boolean localizeName = friendlyByteBuf.readBoolean();
        WorldPropertyWidgetType<?> widgetType = WorldPropertyWidgetType.read(friendlyByteBuf);
        byte[] data = friendlyByteBuf.method_10795();
        return widgetType.create(id, name, localizeName, data);
    }
}

