/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.Const;
import org.apache.bcel.classfile.ConstantPool;

public final class StackMapType
implements Cloneable {
    private byte type;
    private int index = -1;
    private ConstantPool constantPool;

    public StackMapType(byte type2, int index, ConstantPool constantPool) {
        if (type2 < 0 || type2 > 8) {
            throw new IllegalArgumentException("Illegal type for StackMapType: " + type2);
        }
        this.type = type2;
        this.index = index;
        this.constantPool = constantPool;
    }

    StackMapType(DataInput file, ConstantPool constantPool) throws IOException {
        this(file.readByte(), -1, constantPool);
        if (this.hasIndex()) {
            this.index = file.readShort();
        }
        this.constantPool = constantPool;
    }

    public StackMapType copy() {
        try {
            return (StackMapType)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeByte(this.type);
        if (this.hasIndex()) {
            file.writeShort(this.getIndex());
        }
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public int getIndex() {
        return this.index;
    }

    public byte getType() {
        return this.type;
    }

    public boolean hasIndex() {
        return this.type == 7 || this.type == 8;
    }

    private String printIndex() {
        if (this.type == 7) {
            if (this.index < 0) {
                return ", class=<unknown>";
            }
            return ", class=" + this.constantPool.constantToString(this.index, (byte)7);
        }
        if (this.type == 8) {
            return ", offset=" + this.index;
        }
        return "";
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.constantPool = constantPool;
    }

    public void setIndex(int t2) {
        this.index = t2;
    }

    public void setType(byte t2) {
        if (t2 < 0 || t2 > 8) {
            throw new IllegalArgumentException("Illegal type for StackMapType: " + t2);
        }
        this.type = t2;
    }

    public String toString() {
        return "(type=" + Const.getItemName(this.type) + this.printIndex() + ")";
    }
}

