/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.io.IOException;
import java.io.InputStream;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.LibFunction;
import org.luaj.vm2.lib.ResourceFinder;
import org.luaj.vm2.lib.TableLibFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class BaseLib
extends TwoArgFunction
implements ResourceFinder {
    Globals globals;

    @Override
    public LuaValue call(LuaValue modname, LuaValue env) {
        this.globals = env.checkglobals();
        this.globals.finder = this;
        this.globals.baselib = this;
        env.set("_G", env);
        env.set("_VERSION", "Luaj 0.0");
        env.set("assert", (LuaValue)new _assert());
        env.set("collectgarbage", (LuaValue)new collectgarbage());
        env.set("dofile", (LuaValue)new dofile());
        env.set("error", (LuaValue)new error());
        env.set("getmetatable", (LuaValue)new getmetatable());
        env.set("load", (LuaValue)new load());
        env.set("loadfile", (LuaValue)new loadfile());
        env.set("pcall", (LuaValue)new pcall());
        env.set("print", (LuaValue)new print(this));
        env.set("rawequal", (LuaValue)new rawequal());
        env.set("rawget", (LuaValue)new rawget());
        env.set("rawlen", (LuaValue)new rawlen());
        env.set("rawset", (LuaValue)new rawset());
        env.set("select", (LuaValue)new select());
        env.set("setmetatable", (LuaValue)new setmetatable());
        env.set("tonumber", (LuaValue)new tonumber());
        env.set("tostring", (LuaValue)new tostring());
        env.set("type", (LuaValue)new type());
        env.set("xpcall", (LuaValue)new xpcall());
        next next2 = new next();
        env.set("next", (LuaValue)next2);
        env.set("pairs", (LuaValue)new pairs(next2));
        env.set("ipairs", (LuaValue)new ipairs());
        return env;
    }

    @Override
    public InputStream findResource(String filename) {
        return this.getClass().getResourceAsStream((String)(filename.startsWith("/") ? filename : "/" + filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Varargs loadFile(String filename, String mode, LuaValue env) {
        InputStream is = this.globals.finder.findResource(filename);
        if (is == null) {
            return BaseLib.varargsOf(NIL, (Varargs)BaseLib.valueOf("cannot open " + filename + ": No such file or directory"));
        }
        try {
            Varargs varargs = this.loadStream(is, "@" + filename, mode, env);
            return varargs;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Varargs loadStream(InputStream is, String chunkname, String mode, LuaValue env) {
        try {
            if (is == null) {
                return BaseLib.varargsOf(NIL, (Varargs)BaseLib.valueOf("not found: " + chunkname));
            }
            return this.globals.load(is, chunkname, mode, env);
        }
        catch (Exception e) {
            return BaseLib.varargsOf(NIL, (Varargs)BaseLib.valueOf(e.getMessage()));
        }
    }

    static final class _assert
    extends VarArgFunction {
        _assert() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            if (!args.arg1().toboolean()) {
                _assert.error(args.narg() > 1 ? args.optjstring(2, "assertion failed!") : "assertion failed!");
            }
            return args;
        }
    }

    static final class collectgarbage
    extends VarArgFunction {
        collectgarbage() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            String s2 = args.optjstring(1, "collect");
            if ("collect".equals(s2)) {
                System.gc();
                return ZERO;
            }
            if ("count".equals(s2)) {
                Runtime rt = Runtime.getRuntime();
                long used = rt.totalMemory() - rt.freeMemory();
                return collectgarbage.varargsOf(collectgarbage.valueOf((double)used / 1024.0), (Varargs)collectgarbage.valueOf(used % 1024L));
            }
            if ("step".equals(s2)) {
                System.gc();
                return LuaValue.TRUE;
            }
            collectgarbage.argerror(1, "invalid option '" + s2 + "'");
            return NIL;
        }
    }

    final class dofile
    extends VarArgFunction {
        dofile() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            args.argcheck(args.isstring(1) || args.isnil(1), 1, "filename must be string or nil");
            String filename = args.isstring(1) ? args.tojstring(1) : null;
            Varargs v = filename == null ? BaseLib.this.loadStream(BaseLib.this.globals.STDIN, "=stdin", "bt", BaseLib.this.globals) : BaseLib.this.loadFile(args.checkjstring(1), "bt", BaseLib.this.globals);
            return v.isnil(1) ? dofile.error(v.tojstring(2)) : v.arg1().invoke();
        }
    }

    static final class error
    extends TwoArgFunction {
        error() {
        }

        @Override
        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            if (arg1.isnil()) {
                throw new LuaError(NIL);
            }
            if (!arg1.isstring() || arg2.optint(1) == 0) {
                throw new LuaError(arg1);
            }
            throw new LuaError(arg1.tojstring(), arg2.optint(1));
        }
    }

    static final class getmetatable
    extends LibFunction {
        getmetatable() {
        }

        @Override
        public LuaValue call() {
            return getmetatable.argerror(1, "value expected");
        }

        @Override
        public LuaValue call(LuaValue arg) {
            LuaValue mt = arg.getmetatable();
            return mt != null ? mt.rawget(METATABLE).optvalue(mt) : NIL;
        }
    }

    final class load
    extends VarArgFunction {
        load() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaValue ld = args.arg1();
            if (!ld.isstring() && !ld.isfunction()) {
                throw new LuaError("bad argument #1 to 'load' (string or function expected, got " + ld.typename() + ")");
            }
            String source = args.optjstring(2, ld.isstring() ? ld.tojstring() : "=(load)");
            String mode = args.optjstring(3, "bt");
            LuaValue env = args.optvalue(4, BaseLib.this.globals);
            return BaseLib.this.loadStream(ld.isstring() ? ld.strvalue().toInputStream() : new StringInputStream(ld.checkfunction()), source, mode, env);
        }
    }

    final class loadfile
    extends VarArgFunction {
        loadfile() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            args.argcheck(args.isstring(1) || args.isnil(1), 1, "filename must be string or nil");
            String filename = args.isstring(1) ? args.tojstring(1) : null;
            String mode = args.optjstring(2, "bt");
            LuaValue env = args.optvalue(3, BaseLib.this.globals);
            return filename == null ? BaseLib.this.loadStream(BaseLib.this.globals.STDIN, "=stdin", mode, env) : BaseLib.this.loadFile(filename, mode, env);
        }
    }

    final class pcall
    extends VarArgFunction {
        pcall() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Varargs invoke(Varargs args) {
            LuaValue func = args.checkvalue(1);
            if (BaseLib.this.globals != null && BaseLib.this.globals.debuglib != null) {
                BaseLib.this.globals.debuglib.onCall(this);
            }
            try {
                Varargs varargs = pcall.varargsOf(TRUE, func.invoke(args.subargs(2)));
                return varargs;
            }
            catch (LuaError le) {
                LuaValue m4 = le.getMessageObject();
                Varargs varargs = pcall.varargsOf(FALSE, (Varargs)(m4 != null ? m4 : NIL));
                return varargs;
            }
            catch (Exception e) {
                String m5 = e.getMessage();
                Varargs varargs = pcall.varargsOf(FALSE, (Varargs)pcall.valueOf(m5 != null ? m5 : e.toString()));
                return varargs;
            }
            finally {
                if (BaseLib.this.globals != null && BaseLib.this.globals.debuglib != null) {
                    BaseLib.this.globals.debuglib.onReturn();
                }
            }
        }
    }

    final class print
    extends VarArgFunction {
        final BaseLib baselib;

        print(BaseLib baselib) {
            this.baselib = baselib;
        }

        @Override
        public Varargs invoke(Varargs args) {
            LuaValue tostring2 = BaseLib.this.globals.get("tostring");
            int n = args.narg();
            for (int i = 1; i <= n; ++i) {
                if (i > 1) {
                    BaseLib.this.globals.STDOUT.print('\t');
                }
                LuaString s2 = tostring2.call(args.arg(i)).strvalue();
                BaseLib.this.globals.STDOUT.print(s2.tojstring());
            }
            BaseLib.this.globals.STDOUT.print('\n');
            return NONE;
        }
    }

    static final class rawequal
    extends LibFunction {
        rawequal() {
        }

        @Override
        public LuaValue call() {
            return rawequal.argerror(1, "value expected");
        }

        @Override
        public LuaValue call(LuaValue arg) {
            return rawequal.argerror(2, "value expected");
        }

        @Override
        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            return rawequal.valueOf(arg1.raweq(arg2));
        }
    }

    static final class rawget
    extends TableLibFunction {
        rawget() {
        }

        @Override
        public LuaValue call(LuaValue arg) {
            return rawget.argerror(2, "value expected");
        }

        @Override
        public LuaValue call(LuaValue arg1, LuaValue arg2) {
            return arg1.checktable().rawget(arg2);
        }
    }

    static final class rawlen
    extends LibFunction {
        rawlen() {
        }

        @Override
        public LuaValue call(LuaValue arg) {
            return rawlen.valueOf(arg.rawlen());
        }
    }

    static final class rawset
    extends TableLibFunction {
        rawset() {
        }

        @Override
        public LuaValue call(LuaValue table) {
            return rawset.argerror(2, "value expected");
        }

        @Override
        public LuaValue call(LuaValue table, LuaValue index) {
            return rawset.argerror(3, "value expected");
        }

        @Override
        public LuaValue call(LuaValue table, LuaValue index, LuaValue value) {
            LuaTable t2 = table.checktable();
            if (!index.isvalidkey()) {
                rawset.argerror(2, "table index is nil");
            }
            t2.rawset(index, value);
            return t2;
        }
    }

    static final class select
    extends VarArgFunction {
        select() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            int n = args.narg() - 1;
            if (args.arg1().equals(select.valueOf("#"))) {
                return select.valueOf(n);
            }
            int i = args.checkint(1);
            if (i == 0 || i < -n) {
                select.argerror(1, "index out of range");
            }
            return args.subargs(i < 0 ? n + i + 2 : i + 1);
        }
    }

    static final class setmetatable
    extends TableLibFunction {
        setmetatable() {
        }

        @Override
        public LuaValue call(LuaValue table) {
            return setmetatable.argerror(2, "nil or table expected");
        }

        @Override
        public LuaValue call(LuaValue table, LuaValue metatable) {
            LuaValue mt0 = table.checktable().getmetatable();
            if (mt0 != null && !mt0.rawget(METATABLE).isnil()) {
                setmetatable.error("cannot change a protected metatable");
            }
            return table.setmetatable(metatable.isnil() ? null : metatable.checktable());
        }
    }

    static final class tonumber
    extends LibFunction {
        tonumber() {
        }

        @Override
        public LuaValue call(LuaValue e) {
            return e.tonumber();
        }

        @Override
        public LuaValue call(LuaValue e, LuaValue base) {
            if (base.isnil()) {
                return e.tonumber();
            }
            int b = base.checkint();
            if (b < 2 || b > 36) {
                tonumber.argerror(2, "base out of range");
            }
            return e.checkstring().tonumber(b);
        }
    }

    static final class tostring
    extends LibFunction {
        tostring() {
        }

        @Override
        public LuaValue call(LuaValue arg) {
            LuaValue h2 = arg.metatag(TOSTRING);
            if (!h2.isnil()) {
                return h2.call(arg);
            }
            LuaValue v = arg.tostring();
            if (!v.isnil()) {
                return v;
            }
            return tostring.valueOf(arg.tojstring());
        }
    }

    static final class type
    extends LibFunction {
        type() {
        }

        @Override
        public LuaValue call(LuaValue arg) {
            return type.valueOf(arg.typename());
        }
    }

    final class xpcall
    extends VarArgFunction {
        xpcall() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public Varargs invoke(Varargs args) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static final class next
    extends VarArgFunction {
        next() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            return args.checktable(1).next(args.arg(2));
        }
    }

    static final class pairs
    extends VarArgFunction {
        final next next;

        pairs(next next2) {
            this.next = next2;
        }

        @Override
        public Varargs invoke(Varargs args) {
            return pairs.varargsOf(this.next, args.checktable(1), NIL);
        }
    }

    static final class ipairs
    extends VarArgFunction {
        inext inext = new inext();

        ipairs() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            return ipairs.varargsOf(this.inext, args.checktable(1), ZERO);
        }
    }

    private static class StringInputStream
    extends InputStream {
        final LuaValue func;
        byte[] bytes;
        int offset;
        int remaining = 0;

        StringInputStream(LuaValue func) {
            this.func = func;
        }

        @Override
        public int read() throws IOException {
            if (this.remaining < 0) {
                return -1;
            }
            if (this.remaining == 0) {
                LuaValue s2 = this.func.call();
                if (s2.isnil()) {
                    this.remaining = -1;
                    return -1;
                }
                LuaString ls = s2.strvalue();
                this.bytes = ls.m_bytes;
                this.offset = ls.m_offset;
                this.remaining = ls.m_length;
                if (this.remaining <= 0) {
                    return -1;
                }
            }
            --this.remaining;
            return 0xFF & this.bytes[this.offset++];
        }
    }

    static final class inext
    extends VarArgFunction {
        inext() {
        }

        @Override
        public Varargs invoke(Varargs args) {
            return args.checktable(1).inext(args.arg(2));
        }
    }
}

