/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.luaj.vm2.server.DefaultLauncher;
import org.luaj.vm2.server.Launcher;

public class LuajClassLoader
extends ClassLoader {
    static final String luajPackageRoot = "org.luaj.vm2.";
    static final String launcherInterfaceRoot = Launcher.class.getName();
    Map<String, Class<?>> classes = new HashMap();

    public static Launcher NewLauncher() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return LuajClassLoader.NewLauncher(DefaultLauncher.class);
    }

    public static Launcher NewLauncher(Class<? extends Launcher> launcher_class) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        LuajClassLoader loader = new LuajClassLoader();
        Object instance = loader.loadAsUserClass(launcher_class.getName()).newInstance();
        return (Launcher)instance;
    }

    public static boolean isUserClass(String classname) {
        return classname.startsWith(luajPackageRoot) && !classname.startsWith(launcherInterfaceRoot);
    }

    @Override
    public Class<?> loadClass(String classname) throws ClassNotFoundException {
        if (this.classes.containsKey(classname)) {
            return this.classes.get(classname);
        }
        if (!LuajClassLoader.isUserClass(classname)) {
            return super.findSystemClass(classname);
        }
        return this.loadAsUserClass(classname);
    }

    private Class<?> loadAsUserClass(String classname) throws ClassNotFoundException {
        String path = classname.replace('.', '/').concat(".class");
        InputStream is = this.getResourceAsStream(path);
        if (is != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] b = new byte[1024];
                int n = 0;
                while ((n = is.read(b)) >= 0) {
                    baos.write(b, 0, n);
                }
                byte[] bytes = baos.toByteArray();
                Class<?> result = super.defineClass(classname, bytes, 0, bytes.length);
                this.classes.put(classname, result);
                return result;
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Read failed: " + classname + ": " + e);
            }
        }
        throw new ClassNotFoundException("Not found: " + classname);
    }
}

