/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.dynfix;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.PatchAuditTrail;
import org.sinytra.adapter.patch.transformer.BundledMethodTransform;
import org.sinytra.adapter.patch.transformer.dynfix.DynamicFixer;

public class DynFixResolveAmbigousTarget
implements DynamicFixer<Data> {
    @Override
    @Nullable
    public Data prepare(MethodContext methodContext) {
        Pair<ClassNode, List<MethodNode>> candidates = methodContext.findInjectionTargetCandidates(methodContext.patchContext().environment().dirtyClassLookup(), true);
        if (candidates != null && !((List)candidates.getSecond()).isEmpty()) {
            MethodContext.TargetPair cleanTarget;
            if (((List)candidates.getSecond()).size() == 1 && ((cleanTarget = methodContext.findCleanInjectionTarget()) == null || ((MethodNode)((List)candidates.getSecond()).getFirst()).desc.equals(cleanTarget.methodNode().desc))) {
                return null;
            }
            return new Data(candidates);
        }
        return null;
    }

    @Override
    @Nullable
    public DynamicFixer.FixResult apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchAuditTrail auditTrail, Data data) {
        List candidates = (List)data.candidates().getSecond();
        for (MethodNode target : candidates) {
            if (candidates.size() != 1 && methodContext.findInjectionTargetInsns(new MethodContext.TargetPair((ClassNode)data.candidates().getFirst(), target)).isEmpty()) continue;
            String newTarget = target.name + target.desc;
            methodContext.recordAudit(this, "Resolve ambigous method selector to %s", newTarget);
            return DynamicFixer.FixResult.of(((BundledMethodTransform.Builder)BundledMethodTransform.builder().modifyTarget(newTarget)).apply(methodContext), PatchAuditTrail.Match.FULL);
        }
        return null;
    }

    public record Data(Pair<ClassNode, List<MethodNode>> candidates) {
    }
}

