/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.operation.param;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.transformer.operation.param.InjectParameterTransform;
import org.sinytra.adapter.patch.transformer.operation.param.InlineParameterTransformer;
import org.sinytra.adapter.patch.transformer.operation.param.MoveParametersTransformer;
import org.sinytra.adapter.patch.transformer.operation.param.ParamTransformTarget;
import org.sinytra.adapter.patch.transformer.operation.param.ParameterTransformer;
import org.sinytra.adapter.patch.transformer.operation.param.RemoveParameterTransformer;
import org.sinytra.adapter.patch.transformer.operation.param.ReplaceParametersTransformer;
import org.sinytra.adapter.patch.transformer.operation.param.SubstituteParameterTransformer;
import org.sinytra.adapter.patch.transformer.operation.param.SwapParametersTransformer;

public record TransformParameters(List<ParameterTransformer> transformers, boolean withOffset, ParamTransformTarget targetType) implements MethodTransform
{
    private static final BiMap<String, Codec<? extends ParameterTransformer>> TRANSFORMER_CODECS = ImmutableBiMap.builder().put((Object)"inject_parameter", InjectParameterTransform.CODEC).put((Object)"swap_parameters", SwapParametersTransformer.CODEC).put((Object)"substitute_parameters", SubstituteParameterTransformer.CODEC).put((Object)"remove_parameter", RemoveParameterTransformer.CODEC).put((Object)"replace_parameter", ReplaceParametersTransformer.CODEC).put((Object)"move_parameter", MoveParametersTransformer.CODEC).build();
    public static final Codec<TransformParameters> CODEC = RecordCodecBuilder.create(in -> in.group((App)Codec.STRING.dispatch("type", c -> (String)TRANSFORMER_CODECS.inverse().get(c.codec()), s -> ((Codec)TRANSFORMER_CODECS.get(s)).fieldOf("transformer")).listOf().fieldOf("transformers").forGetter(TransformParameters::transformers), (App)Codec.BOOL.optionalFieldOf("withOffset", (Object)false).forGetter(TransformParameters::withOffset), (App)ParamTransformTarget.CODEC.optionalFieldOf("targetType", (Object)ParamTransformTarget.ALL).forGetter(TransformParameters::targetType)).apply((Applicative)in, TransformParameters::new));

    @Override
    public Collection<String> getAcceptedAnnotations() {
        return this.targetType.getTargetMixinTypes();
    }

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        Type[] params = Type.getArgumentTypes((String)methodNode.desc);
        ArrayList<Type> newParameterTypes = new ArrayList<Type>(Arrays.asList(params));
        Patch.Result result = Patch.Result.PASS;
        int offset = this.calculateOffset(methodContext);
        for (ParameterTransformer transform : this.transformers) {
            result = result.or(transform.apply(classNode, methodNode, methodContext, context, newParameterTypes, offset));
        }
        methodContext.updateDescription(this, newParameterTypes);
        return result;
    }

    @Override
    public Codec<? extends MethodTransform> codec() {
        return CODEC;
    }

    private int calculateOffset(MethodContext methodContext) {
        MethodNode targetMethod;
        AnnotationHandle annotation = methodContext.methodAnnotation();
        if (this.targetType == ParamTransformTarget.METHOD_EXT && annotation.matchesDesc("Lorg/spongepowered/asm/mixin/injection/Redirect;") && (targetMethod = (MethodNode)Optional.ofNullable(methodContext.getInjectionPointMethodQualifier()).flatMap(q -> methodContext.patchContext().environment().dirtyClassLookup().findMethod(q.internalOwnerName(), q.name(), q.desc())).orElse(null)) != null) {
            return ((targetMethod.access & 8) == 0 ? 1 : 0) + Type.getArgumentTypes((String)targetMethod.desc).length;
        }
        boolean needsLocalOffset = annotation.matchesDesc("Lorg/spongepowered/asm/mixin/injection/Redirect;") || annotation.matchesDesc("Lcom/llamalad7/mixinextras/injector/wrapoperation/WrapOperation;");
        return !methodContext.isStatic() && this.withOffset && needsLocalOffset ? 1 : 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    @CanIgnoreReturnValue
    public static class Builder {
        private final List<ParameterTransformer> transformers = new ArrayList<ParameterTransformer>();
        private boolean offset = false;
        private ParamTransformTarget targetType = ParamTransformTarget.ALL;

        public Builder transform(ParameterTransformer transformer) {
            this.transformers.add(transformer);
            return this;
        }

        public Builder transform(List<ParameterTransformer> transformers) {
            this.transformers.addAll(transformers);
            return this;
        }

        public Builder inject(int parameterIndex, Type type) {
            return this.transform(new InjectParameterTransform(parameterIndex, type));
        }

        public Builder replace(int index, Type type) {
            return this.transform(new ReplaceParametersTransformer(index, type));
        }

        public Builder replacements(List<Pair<Integer, Type>> replacements) {
            replacements.forEach(p -> this.replace((Integer)p.getFirst(), (Type)p.getSecond()));
            return this;
        }

        public Builder swap(int from, int to) {
            return this.transform(new SwapParametersTransformer(from, to));
        }

        public Builder substitute(int target, int substitute) {
            return this.transform(new SubstituteParameterTransformer(target, substitute));
        }

        public Builder inline(int target, Consumer<InstructionAdapter> adapter) {
            return this.transform(new InlineParameterTransformer(target, adapter));
        }

        public Builder remove(int index) {
            return this.transform(new RemoveParameterTransformer(index));
        }

        public Builder withOffset() {
            this.offset = true;
            return this;
        }

        public Builder withOffset(boolean offset) {
            this.offset = offset;
            return this;
        }

        public Builder targetType(ParamTransformTarget targetType) {
            this.targetType = targetType;
            return this;
        }

        public Builder chain(Consumer<Builder> consumer) {
            consumer.accept(this);
            return this;
        }

        @CheckReturnValue
        public TransformParameters build() {
            return new TransformParameters(this.transformers, this.offset, this.targetType);
        }
    }
}

