/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer.jar;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.jar.Attributes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.sinytra.adapter.patch.fixes.BytecodeFixerUpper;
import org.sinytra.adapter.patch.fixes.SimpleTypeAdapter;
import org.sinytra.adapter.patch.fixes.TypeAdapter;
import org.sinytra.adapter.patch.util.provider.ClassLookup;
import org.sinytra.connector.transformer.TransformerEnvironment;
import org.sinytra.connector.transformer.transform.TransformerUtil;

public class BytecodeFixerUpperFrontend {
    private static final List<TypeAdapter> FIELD_TYPE_ADAPTERS = List.of(new SimpleTypeAdapter(Type.getObjectType((String)"net/minecraft/core/Holder$Reference"), Type.getObjectType((String)"java/lang/Object"), (list, insn) -> list.insert(insn, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/core/Holder$Reference", "value", "()Ljava/lang/Object;"))), new SimpleTypeAdapter(Type.getObjectType((String)"net/minecraft/resources/ResourceLocation"), Type.getObjectType((String)"java/lang/String"), (list, insn) -> list.insert(insn, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/resources/ResourceLocation", "toString", "()Ljava/lang/String;"))), new SimpleTypeAdapter(Type.getObjectType((String)"net/minecraft/world/item/ItemStack"), Type.getObjectType((String)"net/minecraft/world/item/Item"), (list, insn) -> list.insert(insn, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/item/ItemStack", "getItem", "()Lnet/minecraft/world/item/Item;"))), new SimpleTypeAdapter(Type.getObjectType((String)"net/minecraft/world/entity/Mob"), Type.getObjectType((String)"net/minecraft/world/entity/monster/Monster"), (list, insn) -> {}));
    private final BytecodeFixerUpper bfu;
    private final TransformerUtil.CacheFile cacheFile;
    private final Path generatedJarPath;

    public BytecodeFixerUpperFrontend(ClassLookup cleanLookup, ClassLookup dirtyLookup, TransformerEnvironment environment) {
        this.bfu = new BytecodeFixerUpper(cleanLookup, dirtyLookup, FIELD_TYPE_ADAPTERS);
        this.generatedJarPath = environment.getGeneratedJarPath();
        this.cacheFile = TransformerUtil.getCached(null, this.generatedJarPath, environment.getJarCacheVersion());
        if (this.cacheFile.isUpToDate()) {
            this.bfu.getGenerator().loadExisting(this.generatedJarPath);
        }
    }

    public BytecodeFixerUpper unwrap() {
        return this.bfu;
    }

    public void saveGeneratedAdapterJar() throws IOException {
        Files.createDirectories(this.generatedJarPath.getParent(), new FileAttribute[0]);
        Files.deleteIfExists(this.generatedJarPath);
        Attributes attributes = new Attributes();
        attributes.putValue("FMLModType", "GAMELIBRARY");
        if (this.bfu.getGenerator().save(this.generatedJarPath, attributes)) {
            this.cacheFile.save();
        }
    }
}

