/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer.transform;

import com.google.common.collect.ImmutableList;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.LambdaExceptionUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.sinytra.adapter.patch.LVTOffsets;
import org.sinytra.adapter.patch.api.ClassTransform;
import org.sinytra.adapter.patch.api.MixinClassGenerator;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.api.PatchEnvironment;
import org.sinytra.adapter.patch.fixes.FieldTypePatchTransformer;
import org.sinytra.adapter.patch.fixes.FieldTypeUsageTransformer;
import org.sinytra.adapter.patch.transformer.dynamic.DynamicAnonymousShadowFieldTypePatch;
import org.sinytra.adapter.patch.transformer.dynamic.DynamicInheritedInjectionPointPatch;
import org.sinytra.adapter.patch.transformer.dynamic.DynamicInjectorOrdinalPatch;
import org.sinytra.adapter.patch.transformer.dynamic.DynamicLVTPatch;
import org.sinytra.adapter.patch.transformer.dynamic.DynamicModifyVarAtReturnPatch;
import org.sinytra.adapter.patch.transformer.dynfix.DynamicInjectionPointPatch;
import org.sinytra.connector.transformer.TransformerEnvironment;
import org.sinytra.connector.transformer.patch.EnvironmentStripperTransformer;
import org.sinytra.connector.transformer.transform.MappingAwareReferenceMapper;
import org.sinytra.connector.transformer.transform.MixinPatches;
import org.slf4j.Logger;
import reloc.net.minecraftforge.fart.api.Transformer;

public class MixinPatchTransformer
implements Transformer {
    private static final List<Patch> PRIORITY_PATCHES = MixinPatches.getPriorityPatches();
    private static final List<Patch> PATCHES = MixinPatches.getPatches();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static boolean completedSetup = false;
    private final List<ClassTransform> classTransforms;
    private final Patch classPatch;
    private final PatchEnvironment environment;
    private final List<? extends Patch> patches;

    public MixinPatchTransformer(TransformerEnvironment runtimeEnvironment, LVTOffsets lvtOffsets, PatchEnvironment environment, List<? extends Patch> adapterPatches) {
        this.classTransforms = List.of(new EnvironmentStripperTransformer(runtimeEnvironment.getEnvType()), new FieldTypeUsageTransformer());
        this.classPatch = ((Patch.ClassPatchBuilder)Patch.builder().transform(this.classTransforms)).build();
        this.environment = environment;
        this.patches = ImmutableList.builder().addAll(PRIORITY_PATCHES).addAll(adapterPatches).addAll(PATCHES).add((Object[])new Patch[]{((Patch.ClassPatchBuilder)((Patch.ClassPatchBuilder)((Patch.ClassPatchBuilder)((Patch.ClassPatchBuilder)((Patch.ClassPatchBuilder)((Patch.ClassPatchBuilder)Patch.builder().transform(new DynamicInjectorOrdinalPatch())).transform(new DynamicLVTPatch(() -> lvtOffsets))).transform(new DynamicAnonymousShadowFieldTypePatch())).transform(new DynamicModifyVarAtReturnPatch())).transform(new DynamicInheritedInjectionPointPatch())).transform(new DynamicInjectionPointPatch())).build(), ((Patch.InterfacePatchBuilder)Patch.interfaceBuilder().transform(new FieldTypePatchTransformer())).build()}).build();
    }

    public void finalize(Path zipRoot, Collection<String> configs, Map<String, MappingAwareReferenceMapper.SimpleRefmap> refmapFiles, Set<String> dirtyRefmaps) throws IOException {
        Path services;
        Map<String, MixinClassGenerator.GeneratedClass> generatedMixinClasses = this.environment.classGenerator().getGeneratedMixinClasses();
        if (!generatedMixinClasses.isEmpty()) {
            for (String config : configs) {
                Path entry = zipRoot.resolve(config);
                if (!Files.exists(entry, new LinkOption[0])) continue;
                try {
                    BufferedReader reader = Files.newBufferedReader(entry);
                    try {
                        String refmapName;
                        String pkg;
                        Map<String, MixinClassGenerator.GeneratedClass> mixins;
                        JsonElement element = JsonParser.parseReader((Reader)reader);
                        JsonObject json = element.getAsJsonObject();
                        if (!json.has("package") || (mixins = this.getMixinsInPackage(pkg = json.get("package").getAsString(), generatedMixinClasses)).isEmpty()) continue;
                        JsonArray jsonMixins = json.has("mixins") ? json.get("mixins").getAsJsonArray() : new JsonArray();
                        LOGGER.info("Adding {} mixins to config {}", (Object)mixins.size(), (Object)config);
                        mixins.keySet().forEach(arg_0 -> ((JsonArray)jsonMixins).add(arg_0));
                        json.add("mixins", (JsonElement)jsonMixins);
                        String output = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create().toJson((JsonElement)json);
                        Files.writeString(entry, (CharSequence)output, StandardCharsets.UTF_8, new OpenOption[0]);
                        if (!json.has("refmap") || !dirtyRefmaps.contains(refmapName = json.get("refmap").getAsString())) continue;
                        MappingAwareReferenceMapper.SimpleRefmap refmap = refmapFiles.get(refmapName);
                        Path path2 = zipRoot.resolve(refmapName);
                        if (!Files.exists(path2, new LinkOption[0])) continue;
                        String refmapString = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create().toJson((Object)refmap);
                        Files.writeString(path2, (CharSequence)refmapString, StandardCharsets.UTF_8, new OpenOption[0]);
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        if (Files.exists(services = zipRoot.resolve("META-INF/services"), new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(services, new FileVisitOption[0]);){
                stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(LambdaExceptionUtils.rethrowConsumer(path -> {
                    String serviceName = path.getFileName().toString();
                    List<String> providers = Files.readAllLines(path);
                    List<String> existingProviders = providers.stream().filter(cls -> Files.exists(zipRoot.resolve(cls.replace('.', '/') + ".class"), new LinkOption[0])).toList();
                    int diff = providers.size() - existingProviders.size();
                    if (diff > 0) {
                        LOGGER.debug("Removing {} nonexistent service providers for service {}", (Object)diff, (Object)serviceName);
                        if (existingProviders.isEmpty()) {
                            Files.delete(path);
                        } else {
                            String newText = String.join((CharSequence)"\n", existingProviders);
                            Files.writeString(path, (CharSequence)newText, StandardCharsets.UTF_8, new OpenOption[0]);
                        }
                    }
                }));
            }
        }
    }

    private Map<String, MixinClassGenerator.GeneratedClass> getMixinsInPackage(String mixinPackage, Map<String, MixinClassGenerator.GeneratedClass> generatedMixinClasses) {
        HashMap<String, MixinClassGenerator.GeneratedClass> classes = new HashMap<String, MixinClassGenerator.GeneratedClass>();
        for (Map.Entry<String, MixinClassGenerator.GeneratedClass> entry : generatedMixinClasses.entrySet()) {
            String name = entry.getKey();
            String className = name.replace('/', '.');
            if (!className.startsWith(mixinPackage)) continue;
            String specificPart = className.substring(mixinPackage.length() + 1);
            classes.put(specificPart, entry.getValue());
            generatedMixinClasses.remove(name);
        }
        return classes;
    }

    public static void completeSetup(Collection<Patch> patches) {
        if (completedSetup) {
            return;
        }
        PATCHES.addAll(patches);
        completedSetup = true;
    }

    @Override
    public Transformer.ClassEntry process(Transformer.ClassEntry entry) {
        Patch.Result patchResult = Patch.Result.PASS;
        ClassReader reader = new ClassReader(entry.getData());
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        if (MixinPatchTransformer.isMixinClass(node)) {
            patchResult = patchResult.or(this.classPatch.apply(node, this.environment));
            for (Patch patch : this.patches) {
                patchResult = patchResult.or(patch.apply(node, this.environment));
            }
        } else {
            for (ClassTransform classTransform : this.classTransforms) {
                patchResult = patchResult.or(classTransform.apply(node, null, PatchContext.create(node, List.of(), this.environment)));
            }
        }
        if (patchResult != Patch.Result.PASS) {
            ClassWriter writer = new ClassWriter(1 | (patchResult == Patch.Result.COMPUTE_FRAMES ? 2 : 0)){

                protected String getCommonSuperClass(String type1, String type2) {
                    ClassInfo t1Info = MixinPatchTransformer.this.getClassInfo(type1);
                    ClassInfo t2Info = MixinPatchTransformer.this.getClassInfo(type2);
                    Set<String> t1Inh = MixinPatchTransformer.this.getParents(t1Info);
                    Set<String> t2Inh = MixinPatchTransformer.this.getParents(t2Info);
                    if (t2Inh.contains(type1)) {
                        return type1;
                    }
                    if (t1Inh.contains(type2)) {
                        return type2;
                    }
                    if (t1Info.isInterface() || t2Info.isInterface()) {
                        return "java/lang/Object";
                    }
                    for (String t1Parent : t1Inh) {
                        if (!t2Inh.contains(t1Parent)) continue;
                        return t1Parent;
                    }
                    return super.getCommonSuperClass(type1, type2);
                }
            };
            node.accept((ClassVisitor)writer);
            return Transformer.ClassEntry.create(entry.getName(), entry.getTime(), writer.toByteArray());
        }
        return entry;
    }

    private Set<String> getParents(ClassInfo info) {
        LinkedHashSet<String> parents = new LinkedHashSet<String>();
        if (info.superClass() != null) {
            parents.add(info.superClass());
            parents.addAll(this.getParents(this.getClassInfo(info.superClass())));
        }
        for (String itf : info.interfaces()) {
            if (!parents.add(itf)) continue;
            parents.addAll(this.getParents(this.getClassInfo(itf)));
        }
        return parents;
    }

    private ClassInfo getClassInfo(String className) {
        Optional<ClassNode> asmNode = this.environment.cleanClassLookup().getClass(className);
        if (asmNode.isPresent()) {
            ClassNode node = asmNode.get();
            return new ClassInfo(Modifier.isInterface(node.access), node.superName, Objects.requireNonNullElse(node.interfaces, List.of()));
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = Class.forName(className.replace('/', '.'), false, classLoader);
            return new ClassInfo(clazz.isInterface(), clazz.getSuperclass() == null ? null : Type.getInternalName(clazz.getSuperclass()), Arrays.stream(clazz.getInterfaces()).map(Type::getInternalName).toList());
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException(className, e);
        }
    }

    @Override
    public Collection<? extends Transformer.Entry> getExtras() {
        ArrayList entries = new ArrayList();
        ImmutableList patches = ImmutableList.builder().add((Object)((Patch.ClassPatchBuilder)Patch.builder().transform(new DynamicInheritedInjectionPointPatch())).build()).build();
        this.environment.classGenerator().getGeneratedMixinClasses().forEach((arg_0, arg_1) -> this.lambda$getExtras$4((List)patches, entries, arg_0, arg_1));
        return entries;
    }

    private static boolean isMixinClass(ClassNode classNode) {
        if (classNode.invisibleAnnotations != null) {
            for (AnnotationNode annotation : classNode.invisibleAnnotations) {
                if (!annotation.desc.equals("Lorg/spongepowered/asm/mixin/Mixin;")) continue;
                return true;
            }
        }
        return false;
    }

    private /* synthetic */ void lambda$getExtras$4(List patches, List entries, String name, MixinClassGenerator.GeneratedClass cls) {
        for (Patch patch : patches) {
            patch.apply(cls.node(), this.environment);
        }
        ClassWriter writer = new ClassWriter(3);
        cls.node().accept((ClassVisitor)writer);
        byte[] bytes = writer.toByteArray();
        entries.add(Transformer.ClassEntry.create(name + ".class", 318211200000L, bytes));
    }

    private record ClassInfo(boolean isInterface, @Nullable String superClass, List<String> interfaces) {
    }
}

